// uv mapping mesh2 with normal
// uses spline to deform mesh2
// makes notes for Trash with SaveFile
 global_settings{ max_trace_level 20}

 #include "colors.inc"
 #include "Math.inc"
 //#include "stones.inc"
 //#include "metals.inc"
 #include "shapes.inc"
 #include "Woods.inc"

 camera{ location <0,0,-8>
       look_at <0,0,0>
       right x*image_width/image_height}
// light_source {<0,0,-100> White }//parallel point_at 0}
  light_source {<-37,10,-54> White }//parallel point_at 0}
plane{z,0 pigment{Green} hollow} 
 //light_source {<0,100,0> White}
//========Change============
#declare SizeX=1.5;//pov mesh X size 
#declare SizeY=1.5;//pov mesh Y size  
#declare Fx=50; // x divions
#declare Fy=50;// y divions
#declare Lz=0;// z location
//   UV Texture
#declare M_Tex=  texture{
    pigment{ uv_mapping  image_map {sys "HouseForS.bmp"  transmit all .02}}
    normal{agate scale .02}
    finish {specular 0.1 roughness 0.1 }
  }
//-----uncomment to save--------
//#declare SaveFile="G:\\POVRAY31\\Zcontest\\Rubrush\\Note2.inc"

//=======End of Changes============

#declare Tris=2*(Fx-1)*(Fy-1); // todle trangles

#declare Pnt=array[Fx*Fy];
#declare Fac=array[Tris];
#declare Nor=array[Fx*Fy];
#declare Uv=array[Fx*Fy];
// points
#declare Cx = Fx/2;
#declare Cy = Fy/2;
#declare SX = SizeX/Fx;
#declare SY = SizeY/Fx;
#declare K = 0;
#declare Cnt = 0;
#while (Cnt < Fy)
 #declare Cnt2 = 0;
 #while (Cnt2 < Fx)
   #declare Pnt[K]=<(Cnt2-Cx)*SX,(Cnt-Cy)*SY,Lz>;
 #declare K = K+1; 
 #declare Cnt2 = Cnt2+1; 
 #end
#declare Cnt = Cnt+1; 
#end

//============== deform pnts Pull=========================
#declare S=seed(1999);
#declare Cnt = 0;
//edges
#while (Cnt < Fy)
 #declare Rp=Cnt+(Fy-1)*Fx;
 #declare Pnt[Rp]=Pnt[Rp]+y*rand(S)*.02;
 #declare Rp=Cnt;
 #declare Pnt[Rp]=Pnt[Rp]-y*rand(S)*.02;
 #declare Rp=Cnt*Fx;
 #declare Pnt[Rp]=Pnt[Rp]-x*rand(S)*.02;
 #declare Rp=Cnt*Fx+(Fx-1);
 #declare Pnt[Rp]=Pnt[Rp]+x*rand(S)*.02;

#declare Cnt = Cnt+1; 
#end
// body
#declare Spl=spline{
            cubic_spline
    -.25, <0,-.25,.5>
    0.00, <0,0,.6>
    0.25, <0,.25,.6>
    0.50, <0,.5,.5>
    0.75, <0,.75,.3>
    1.00, <0,1,0>
    1.25, <0,1.25,0>
  }
#declare Spl2=spline{
            cubic_spline
    -.25, <0,-.25,.4>
    0.00, <0,0,.6>
    0.25, <0,.25,.5>
    0.50, <0,.5,.55>
    0.75, <0,.75,.6>
    1.00, <0,1,.5>
    1.25, <0,1.25,.1>
  }
 
//fix points
#declare Mx =.75;
#declare Cnt = 0;
#while (Cnt < Fy)
 #declare SpA=Spl(Cnt/(Fy-1));
 #declare Cnt2= 0;
 #while (Cnt2< Fx)
  #declare SpB=Spl2(Cnt2/(Fx-1));
   #declare Rp=Cnt2+Cnt*Fx;
   #declare Pnt[Rp]=Pnt[Rp]-z*Mx*(SpB+SpA)/2;
 #declare Cnt2= Cnt2+1; 
 #end
#declare Cnt = Cnt+1; 
#end



/*/#declare S=seed(234);
#declare Pul=<25,25,-2>;//pull location
#declare Rec=16;// points afected

#declare Wp=Pul.x+Pul.y*Fx;
#declare Pnt[Wp]=Pnt[Wp]+z*Pul.z;

#declare Cnt = 1;
 #while (Cnt < Rec)
 #declare Hv= Pul.z*(1-Cnt/(Rec-1));
#declare Cnt2 = -Cnt;
 #while (Cnt2 < Cnt+1)
 #declare Ov=1;
 #declare tpx=Pul.x-Cnt2; #if (tpx<0 | tpx>Fx) #declare Ov=0; #end
 #declare tpy=Pul.y-Cnt; #if (tpy<0 | tpy>Fy) #declare Ov=0; #end
 #declare Rp=tpx+tpy*Fx;
  #if (Rp>=0 & Rp<K & Ov>0) #declare Pnt[Rp]=Pnt[Rp]*<1,1,0>+z*Hv; #end
 #declare Ov=1;
 #declare tpx=Pul.x-Cnt2; #if (tpx<0| tpx> Fx) #declare Ov=0; #end
 #declare tpy=Pul.y+Cnt; #if (tpy>Fy| tpy<0) #declare Ov=0; #end
 #declare Rp=tpx+tpy*Fx;
  #if (Rp>=0 & Rp<K & Ov>0) #declare Pnt[Rp]=Pnt[Rp]*<1,1,0>+z*Hv; #end
 #declare Ov=1;
 #declare tpx=Pul.x-Cnt;  #if (tpx<0| tpx> Fx) #declare Ov=0; #end
 #declare tpy=Pul.y-Cnt2; #if (tpy<0| tpy> Fy) #declare Ov=0; #end
 #declare Rp=tpx+tpy*Fx;
  #if (Rp>=0 & Rp<K & Ov>0) #declare Pnt[Rp]=Pnt[Rp]*<1,1,0>+z*Hv; #end
 #declare Ov=1;
 #declare tpx=Pul.x+Cnt; #if(tpx<0| tpx> Fx) #declare Ov=0; #end
 #declare tpy=Pul.y-Cnt2; #if(tpy<0| tpy> Fy) #declare Ov=0; #end
 #declare Rp=tpx+tpy*Fx;
  #if (Rp>=0 & Rp<K & Ov>0) #declare Pnt[Rp]=Pnt[Rp]*<1,1,0>+z*Hv; #end

 #declare Cnt2 = Cnt2+1; 
 #end
#declare Cnt = Cnt+1; 
#end
 
*/
//------------ Faces-----------------
 #declare N=0;
 #declare Cnt=0;
 #while (Cnt< Fy-1)
  #declare L1=Fx*Cnt;
  #declare L2=Fx*(Cnt+1);
  #declare Cnt1=0;
  #while (Cnt1< Fx-1)
   #declare Fac[N]=<L1+Cnt1,L1+Cnt1+1,L2+Cnt1+1>;
   #declare N=N+1;
   #declare Fac[N]=<L1+Cnt1,L2+Cnt1+1,L2+Cnt1> ;
   #declare N=N+1;
  #declare Cnt1=Cnt1+1;
  #end 
 #declare Cnt=Cnt+1;
 #end
// normal
 #declare Cnt=0;
 #while (Cnt<Fx*Fy)
  #declare Nor[Cnt]=<0,0,0>;
 #declare Cnt=Cnt+1;
 #end 
 #declare Cnt=0;
 #while (Cnt< Tris)
   //#debug concat("Cnt="str(Cnt,0,0),"\n")
   #if(vlength(Fac[Cnt])>0)
     #declare Nbase=Fac[Cnt];
     //#debug concat(" Tri < " vstr(3,Nbase,",",3,3)," >\n")
    #declare Face=vcross(Pnt[Nbase.x]-Pnt[Nbase.z],Pnt[Nbase.x]-Pnt[Nbase.y]);
    //#debug concat("   Face= < " vstr(3,Face,",",3,3)," >\n")
    #declare Nor[Nbase.x]=Nor[Nbase.x]+Face;
    #declare Nor[Nbase.y]=Nor[Nbase.y]+Face;
    #declare Nor[Nbase.z]=Nor[Nbase.z]+Face;
   #end
 #declare Cnt = Cnt+1; 
 #end
// uv vectors
 #declare N=0;
 #declare Cnt=0;
 #while (Cnt< Fy)
  #declare L1=Fx*Cnt;
  #declare L2=Fx*(Cnt+1);
  #declare Cnt1=0;
  #while (Cnt1< Fx)
   #declare Uv[N]=<Cnt1/(Fx-1),Cnt/(Fy-1)>;
   #declare N=N+1;
  #declare Cnt1=Cnt1+1;
  #end 
 #declare Cnt=Cnt+1;
 #end


//================Mesh2=======================
mesh2{
// vertex vectors
 vertex_vectors{Fx*Fy 
 #declare Cnt=0;
 #while (Cnt< Fx*Fy)
    Pnt[Cnt]

 #declare Cnt=Cnt+1;
 #end
 }
// normal vectors 
   normal_vectors {
    Fx*Fy, 
    #declare Cnt=0;
    #while(Cnt<(Fx*Fy))
     Nor[Cnt] 
     #declare Cnt=Cnt+1;
    #end
    } 
//Uv vectors
   uv_vectors {
    Fx*Fy, 
    #declare Cnt=0;
    #while(Cnt<(Fx*Fy))
     Uv[Cnt] 
     #declare Cnt=Cnt+1;
    #end
    } 
// face 
 face_indices{Tris,
 #declare Cnt=0;
 #while (Cnt<Tris)
   Fac[Cnt] 
 #declare Cnt=Cnt+1;
 #end
 } 
 texture{M_Tex}
 double_illuminate 
}
#ifdef(SaveFile)
 #fopen MyFile SaveFile write
 #write (MyFile "#declare Thing = mesh2{\n")
// vertex vectors
 #write (MyFile "vertex_vectors{",Fx*Fy,"\n")
  #declare Cnt=0;
  #while (Cnt< Fx*Fy)
   #write (MyFile Pnt[Cnt],"\n")
  #declare Cnt=Cnt+1;
  #end
 #write (MyFile "}\n")  
// normal vectors 
  #write (MyFile "normal_vectors{",Fx*Fy,"\n")
    #declare Cnt=0;
    #while(Cnt<(Fx*Fy))
     #write (MyFile Nor[Cnt],"\n") 
     #declare Cnt=Cnt+1;      
     #end
    #write (MyFile "}\n") 
//Uv vectors
   #write (MyFile "uv_vectors {",Fx*Fy,"\n")
    #declare Cnt=0;
    #while(Cnt<(Fx*Fy))
     #write (MyFile Uv[Cnt] ,"\n") 
     #declare Cnt=Cnt+1;
    #end
    #write (MyFile "}\n") 
// faces
  #write (MyFile "face_indices{",Tris,"\n") 
   #declare Cnt=0;
   #while (Cnt<Tris)
   #write (MyFile Fac[Cnt] ,"\n") 
   #declare Cnt=Cnt+1;
   #end
 #write (MyFile "}\n") 
 #write (MyFile "texture{M_Tex}\n") 
 #write (MyFile "double_illuminate}\n") 
 
#end

   