
#include "colors.inc"
#include "metals.inc"
#include "stones.inc"
#include "woods.inc"
#include "glass.inc"

#include "shapes.inc"

#include "carpenter.inc"
#include "sanitary.inc"

global_settings 
{
  assumed_gamma 1.0
  max_trace_level 10
  photons {count 50000}
}


sphere
{
  0, 1000 pigment {color SkyBlue} hollow
}


camera {
  location  <-50, 100.0,  50>
  look_at   <  0,  70.0,  90>
  //look_at   <-250,  70.0,  90>
  angle 90

  focal_point <-5, 65, 75> aperture 1.0 blur_samples 20  
}

light_source 
{
  <-125, 200, 150> color 1.3*White
  area_light 8*x, 8*z, 3, 3 circular orient jitter
  //area_light 6*x, 6*z, 2, 2 circular orient jitter
}

light_source 
{
  <-50, 70, 30> color 0.2*White shadowless
  photons {refraction off reflection off}
}


/* Room and Tiles */

#declare DOORWAY = box {<-10,0,50>,<1,200,140> translate -250*x}

#declare T_PLASTER = texture
{
  pigment {color White}
  normal {bozo 1 scale 0.2}
}

#declare T_WALL_TILE = texture
{
  pigment 
  { 
    granite turbulence 0.5 color_map
    {
      [0.0, 0.3 color <1.0,0.7,0.6> color White]
    }
    scale 10
  }
  finish {reflection 0.15 crand 0.01}
}

#declare T_WALL_TILE_STRIP = texture
{
  pigment {color Black} 
  finish{reflection 0.15 crand 0.01}
}

object 
{
  build_room(250,260,300,20) translate <-125,0,150>
  texture {T_PLASTER}
}


#declare WALL_TILE = object
{
  Round_Box_Union(<0.2,0,0>, <-0.2, 15, 15>, 0.15) translate 0.5*y
  texture {T_WALL_TILE}
}


#declare WALL_TILE_STRIP = object
{
  Round_Box_Union(<0.2,0,0>, <-0.2, 5, 15>, 0.15) translate 0.5*y
  texture {T_WALL_TILE_STRIP}
}

#declare FLOOR_TILE = object
{
  Round_Box_Union(<0,-0.2,0>, < -30.5,0.2, 30.5>, 0.15) translate -0.5*x
  texture {T_Stone10 scale 15}
}


#declare STRIP_ROW = 5;

#declare STRIP = union
{
  #declare i = 0;
  #while (i < 19)
    object {WALL_TILE_STRIP translate 15.5*<0,STRIP_ROW,i>}  
    #declare i = i + 1;
  #end  
}


#macro WALL(xtiles)
union
{
  #declare i = 0;
  #while (i < xtiles)
    #declare j = 0;
    #while (j < 10)
      #if (j<STRIP_ROW)
        object {WALL_TILE  translate 15.5*<0,j,i>}
      #else
        object {WALL_TILE  translate 15.5*<0,j,i> + 5.5*y}
      #end
      #declare j = j + 1;
    #end    
    #declare i = i + 1;
  #end  
}
#end

object {WALL(19)}
object {STRIP}
object {WALL(3) rotate  -90*y translate 300*z}
object {STRIP rotate  -90*y translate 300*z}
object {STRIP rotate -180*y translate -250*x translate 300*z}
object {DOORWAY pigment {color 0.7*White}}


union
{
  #declare i = 0;
  #while (i < 10)
    #declare j = 0;
    #while (j < 9)
      object {FLOOR_TILE translate   31*<-j,0,i>}
      #declare j = j + 1;
    #end    
    #declare i = i + 1;
  #end  
}


/* Toilet paper holder */

#declare RRS = 14*ROLL_RADIUS;

#declare BEND = intersection
{
  torus {2,1 rotate 90*z}
  plane {z,0}
  plane {y,0}
  translate 2*y  
}

union
{
  union
  {
    object   {Round_Box_Union(<0,0,4>, <0.4, 15, -18>, 0.15)}
    union
    {
      cylinder {0, -15*z, 1}
      object {BEND translate -15*z}
      object {BEND scale <1, 1,-1>}
      cylinder {<0,2,2>,<0,6,2>, 1}
      object {BEND scale <1,-1,-1> translate 8*y}      
      cylinder {<0,8,0>,<0,8,-15>, 1}
      
      difference
      {
        cylinder {<0,8,-1>, <0,8, -2>, 2}
        cylinder {<0,8, 0>, <0,8, -3>, 1.2}
      }
      cylinder {<0,8,-15>, <0,8,-16>, 2}
  
      translate <-RRS,2*RRS-1,0.5>
    }
    texture {T_Chrome_1D}
  }
  object 
  {
    ROLL_PAPER
    rotate -90*x
    translate ROLL_RADIUS * <-1,1,0>
    scale 14
  }  
  translate <-0.6, 67.5, 77.25>
}


/* Toilet paper stand */

union
{
  union
  {
    cylinder {0,    y, 8}
    cylinder {0, 30*y, 2}
    sphere   {30*y, 2}
    sphere   {33*y, 2}
    texture {T_Chrome_1D}
  }
  object 
  {
    ROLL_PAPER scale 14
    rotate 3*x
    translate 1.1*y
  }
  object 
  {
    ROLL scale 14
    rotate 3*z
    translate 14.2*y
  }  
  translate <-10, 0.2, 107>
  photons {target collect off refraction off reflection on}  
}


/* Towel rack */

#declare RACK_RADIUS = 1.5;

#declare TOWEL_SHAPE = union
{
  cylinder {0, -35*z, RACK_RADIUS}
  difference
  {
    cylinder {0, -35*z, 20 scale <0.10,1,1> translate -13*y}
    plane {-y, 0}
  }
}

union
{
  // Metal bar
  union
  {
    object {BEND scale <1, 1,-1>}
    cylinder {0, -(40/RACK_RADIUS)*z, 1}
    object {BEND translate -(40/RACK_RADIUS)*z}
    rotate -90*z
    translate -2.2*x
    scale RACK_RADIUS
    texture {T_Chrome_1D}    
    photons {target collect off refraction off reflection on}    
  }
  
  // Towel
  difference
  {
    object {TOWEL_SHAPE}
    object {TOWEL_SHAPE scale <0.95, 1, 1.2> translate <0,-0.1,-0.1>}
    plane  {-1.5*x+y, -15}
    texture
    {
      pigment 
      { 
        object
        {
          text 
          {
            ttf "povlogo.ttf" "P" 10, 0 scale 15
            rotate 90*y translate <-5,-22,-15>
          }
          color 1.2*Khaki
          color White
          
        }
        turbulence 0.15
      }
      normal  
      {
        average normal_map
        {
          [0.5 wrinkles 1.0 scale 5]
          [0.5 bozo     5.0 scale 0.5]
          [0.5 planar   6.0 scale 3 rotate 87*x translate -25*z turbulence 0.3]
        }
      }
    }
    /*
    texture
    {
      pigment {checker color rgbt 1 color rgb 1 scale 5}
    }
    */
    translate <-2.2*RACK_RADIUS,0.1,-2.5>    
  }
  
  translate <0,107,174>
}


/* Shower cabin */

#declare SHOWER_RADIUS = 70;

union
{
  difference 
  {
    union
    {
      cylinder {0, 0.5*y, SHOWER_RADIUS texture{T_PLASTER}}  
      cylinder {0.5*y, 15.5*y, SHOWER_RADIUS texture {T_WALL_TILE}}  
      cylinder {15.5*y, 16*y, SHOWER_RADIUS texture{T_PLASTER}}  
      cylinder {16*y, 20*y, SHOWER_RADIUS texture {T_Chrome_1D}      }  
      intersection
      {
        cylinder {21*y,150*y, SHOWER_RADIUS+0.001}  
        plane {-x,0 rotate 3*y}
        texture {T_Chrome_1D}
      }        
    }
    cylinder {-y,200*y, SHOWER_RADIUS-3}
  }
  
  difference
  {
    cylinder {20*y,150*y, SHOWER_RADIUS} 
    cylinder {-y,200*y, SHOWER_RADIUS-1}
    pigment {color rgbt 1}
    normal {leopard 1 scale 0.2}
    finish {reflection 0.1}
    interior {I_Glass}
  }        
  
  union
  {
    cylinder {0, 10*y, SHOWER_RADIUS-3}  
    cylinder {<0,10,0>, <-SHOWER_RADIUS,10,0>,10}
    cylinder {<0,10,0>, <0,10,-SHOWER_RADIUS+3>,10}
    pigment {color White} 
    finish {reflection 0.05} 
  }   
  translate <-0.6,0.2,300>
}


/* Newspaper */

#declare NEWS_RADIUS = 50.0;

intersection
{
  difference 
  {
    cylinder {0,45*z, NEWS_RADIUS}
    cylinder {-z,46*z, NEWS_RADIUS - 0.01}
  }
  plane {-y,0}
  plane {x,15}
  plane {-x,19}
  translate -NEWS_RADIUS*y
  
  texture
  {
    pigment {color rgbf <0.9,0.9,0.8,0.3>}
    normal
    {
      average normal_map
      {
        [0.5 crackle 0.5 scale 3 turbulence 0.7]
        [0.5 granite 0.1 scale 3 turbulence 0.7]
      }
    }
    finish {crand 0.02}
  }
/*
  texture
  {
    pigment 
    { 
      image_map {sys "news.bmp" once transmit 1 1.0}
      rotate 90*x
      scale 30*<1,1,0.6>
      translate -17*x
      translate  (44.5-0.6*30)*z
      //turbulence 0.15
    }
  }
*/  
  
  rotate -20*x
  rotate  20*y
  translate <-35, 50, 18>
}
