/* // Scene Comment

Where is the light
Author: Daniel Volk
Created: 09/2006

Submission to the Internet Raytracing Competition irtc.org (round: September-October 2006 - topic: Absence)


*/ // End Scene Comment


#include "functions.inc"


#declare EnableMedia = true;



#declare TrunkHeight = 18.7;
#declare TrunkOffset = 1.5 * y;

#declare BrickSize = <2.8, 1.25, 2.8>;
#declare MortarSize = 0.1;



#macro BrickTexture(Pigment, Texture, HorizonalOnly)

#if ( HorizonalOnly )

	#local l_BrickSize = BrickSize * <20000, 1, 20000>;

#else

	#local l_BrickSize = BrickSize;

#end


#local MortarTex = texture
{
	Texture
}
texture
{
	pigment
	{
		bozo
		
		color_map
		{
			[0.7  color rgbt 1.0 ]
			[1.0  color rgbt <0, 0, 0, 0.7> ]
		}

		scale 0.05
	}
}


#if ( HorizonalOnly )
// dummy: block layered texture
#end


texture
{
	brick


	texture
	{
		MortarTex
	}
	
	texture
	{
		Texture
	}


	
	brick_size l_BrickSize
	mortar MortarSize
	
	
	scale 1/TrunkHeight

	warp
	{
		cylindrical 
		orientation x
		dist_exp 0
	}
}

#end


#declare Rust = texture
{
	pigment
	{
		bozo
		
		pigment_map
		{
			[ 0.10
				granite
				color_map
				{
					[ 0.0     rgbt <0.560212, 0.264544, 0.085588, 0.5> ]
					[ 0.4     rgbt <0.312467, 0.05803, 0.0, 0.5> ]
					[ 0.5     rgbt <0.31734, 0.188564, 0.036793, 0.5> ]
					[ 0.6     rgbt <0.198842, 0.125798, 0.113624, 0.5> ]
					[ 1.0     rgbt <0.451778, 0.21334, 0.069022, 0.5> ]
				}
				scale 0.01
				]
			[ 0.15
				granite
				color_map
				{
					[ 0.0     rgbt <0.560212, 0.264544, 0.085588, 1> ]
					[ 0.4     rgbt <0.312467, 0.05803, 0.0, 1> ]
					[ 0.5     rgbt <0.31734, 0.188564, 0.036793, 1> ]
					[ 0.6     rgbt <0.198842, 0.125798, 0.113624, 1> ]
					[ 1.0     rgbt <0.451778, 0.21334, 0.069022, 1> ]
				}
				scale 0.01
				]
		}
		
		scale <1, 4, 1> * 0.6
		/*
		warp
		{
			turbulence 0.2
		}*/
	}
}

#declare AlgaeP = pigment
{
	bozo
	
	color_map
	{
		[0.00 color rgbf <0.5, 1.0, 0.5, 0.95>]
		[0.50 color rgbf 1]
		[1.00 color rgbf 1]
	}
	
	warp
	{
		turbulence 0.2
	}
}

#declare AlgaeT = texture
{
	pigment
	{
		AlgaeP
	}
	normal
	{
		pigment_pattern { AlgaeP } bumps 1
	}
	
	scale <1, 30, 1> * 0.2
}


#declare BumpsScale = 0.01;
#declare Bumps = normal
{
	bozo
	normal_map
	{
		[0.15 bumps -0.2 scale 0.08 / BumpsScale]
		[0.15 bumps 0]
	}
	
	scale BumpsScale
}


// Red
#declare TrunkRedC = <170 / 255, 55 / 255, 45 / 255>;
#declare TrunkRedP = pigment
{
	bozo
	
	color_map
	{
		[0.0 color rgb TrunkRedC * 0.9]
		[1.0 color rgb TrunkRedC * 1.0]
	}
	
	scale 0.8
}
#declare TrunkRedBaseT = texture
{
	pigment
	{
		TrunkRedP
	}

	normal
	{
		Bumps
	}
	
	finish
	{
		reflection { 0.1, 0.3 }
		specular 0.5
		metallic
	}
}
texture
{
	Rust
}
#declare TrunkRedT = BrickTexture(TrunkRedP, TrunkRedBaseT, false)
#declare TrunkTopRedT = BrickTexture(TrunkRedP, TrunkRedBaseT, true)


// White
#declare TrunkWhiteC = <227 / 255, 214 / 255, 208 / 255>;
#declare TrunkWhiteP = pigment
{
	bozo
	
	color_map
	{
		[0.0 color rgb TrunkWhiteC * 0.9]
		[1.0 color rgb TrunkWhiteC * 1.0]
	}
	
	scale 0.8
}
#declare TrunkWhiteBaseT = texture
{
	pigment
	{
		TrunkWhiteP
	}
	
	normal
	{
		Bumps
	}	
	
	finish
	{
		reflection { 0.1, 0.3 }
		specular 0.5
		metallic
	}
}
texture
{
	Rust
}
#declare TrunkWhiteT = BrickTexture(TrunkWhiteP, TrunkWhiteBaseT, false)


#declare TrunkBlackPScale = <1, 2, 1> * 0.1;
#declare TrunkBlackP = pigment
{
	bozo
	
	color_map
	{
		[0.0 color rgb <19 / 255, 25 / 255, 25 / 255> * 0.5]
		[1.0 color rgb <22 / 255, 34 / 255, 56 / 255> * 0.5]
	}
	
	scale TrunkBlackPScale

	warp
	{
		turbulence <0.4, 0.5, 0.4>
	}
}
#declare TrunkBlackBaseT = texture
{
	pigment
	{
		TrunkBlackP
	}
	
	finish
	{
		reflection { 0.1, 0.3 }
		specular 0.5
		metallic
	}
}
//texture
//{
//	Rust
//}
texture
{
	AlgaeT
}
#declare TrunkBlackT = BrickTexture(TrunkBlackP, TrunkBlackBaseT, false)




#declare TrunkMaterial = material
{
	texture
	{
		gradient y
		
		texture_map
		{
			[0.00000 TrunkBlackT]
			[0.33422 TrunkBlackT]
			[0.33422 TrunkWhiteT]
			[0.60160 TrunkWhiteT]
			[0.60160 TrunkRedT]
			[0.80213 TrunkRedT]
			[0.80213 TrunkWhiteT]
			[1.00000 TrunkWhiteT]
		}
		
		scale TrunkHeight
	    translate TrunkOffset
	}
}


#declare TrunkTopMaterial = material
{
	texture
	{
		TrunkTopRedT
		
		scale TrunkHeight
		translate TrunkOffset
	}
}


#declare WhiteMaterial = material
{
	texture
	{
		TrunkWhiteT
		
		scale TrunkHeight
		//translate TrunkOffset
	}
}




#declare RoofP = pigment
{
	bozo
	color_map
	{
		[ 0.0     rgbft <0.0, 0.0, 0.0, 0.0, 0.0> ]
		[ 1.0     rgbft <0.294118, 0.294118, 0.294118, 0.0, 0.0> ]
	}
}

#declare RoofMaterial = material
{   
	texture
	{      
		pigment
		{
			RoofP
		}
		finish
		{
			reflection { 0.0, 0.5 }
		}
	}
}
   
   
#declare LatticeMaterial = material
{   
	texture
	{      
		pigment
		{
			hexagon 
			pigment { RoofP }
			pigment { RoofP }
			pigment { color rgbf 1 }
			
			scale  <0.01, 0.01, 0.01>
		}
	}
}


#declare FlagTexture = texture
{
	//uv_mapping
	pigment
	{
		image_map
		{
			tga   "valogo.tga"
			once
		}
		

		rotate <90, 0, 0>
		translate <-0.16, 0, -0.246666667>
	}

	scale 15
}




#declare fWaves = function { f_ridged_mf(x, y, z, 0.1, 3.0, 7, 0.7, 0.7, 2) }
#declare OceanMaterial = material
{
	texture
	{
		pigment
		{
			bozo
			
			color_map
			{
				[ 0.0 color rgbf 1 ]
				[ 1.0 color rgbf <0.25, 0.35, 0.4, 0.9> ]
			}
			scale 10
		}
		normal
		{
			function { fWaves(x, y, z) } 0.8
	        scale 2
	
			turbulence 0.4
		}
		finish
		{
			diffuse 0.0
			ambient 0.0
			reflection { 0.0, 1.0 }
			specular 0.4
	        roughness 0.003
		} 
	}
        
        
	interior
	{
 		ior 1.33
		fade_power 1
		fade_distance 100
		
		media
		{
			absorption <0.2, 0.2, 0.18>
		} 
 	}
}




#declare AtmosphereBoxSize = <3000, 3000, 1000>;


#declare NoDensity = density
{
	gradient z
	
	color_map
	{
		[ 0.0  color 0 ]
		[ 1.0  color 0 ]
	}
}

#declare FullDensity = density
{
	gradient z
	
	color_map
	{
		[ 0.0  color 1 ]
		[ 1.0  color 1 ]
	}
}

#declare FarBozoDensity = density
{
	bozo
	
	color_map
	{
		[ 0.0  color 0 ]
		[ 1.0  color 1 ]
	}
}

#declare NearBozoDensity = density
{
	bozo
	
	color_map
	{
		[ 0.0  color 0 ]
		//[ 0.5  color 0 ]
		[ 1.0  color 1 ]
	}
}

#declare RainMaterial = material
{   
	texture
	{      
		pigment
		{
			color rgbf <1.0, 1.0, 1.0, 1.0>
		}
	}
	interior
	{
#if ( EnableMedia )
		media		// rain drops
		{
			//intervals 10
			
            scattering
            {
               1,  rgb <0.001, 0.001, 0.0007> * 0.4
            }
            absorption <0.005, 0.005, 0.005> * 0.2
			density
			{
				bozo
				color_map
				{
					[0.3  color rgb 0.3]
					[1.0  color rgb 1.0]
				}
				scale <0.0001, 0.0001, 0.3>
				rotate <2, 0, 0>
			}
		}
		
		media		// fog
		{
			//intervals 10
			
            scattering
            {
               1,  rgb 0.0005
            }
            absorption 0.005 * 0.01
		}
		
		media		// spray (ship)
		{
			//intervals 10
			
            emission 0.04
            //absorption 0.9
            
            density
            {
            	spherical
            	
            	density_map
            	{
            		[ 0.0  NoDensity ]
            		[ 1.0  FarBozoDensity scale 0.1 ]
            	}
            	
            	warp
            	{
            		turbulence 0.5
            	}
            	
            	scale <1, 1, 1> / AtmosphereBoxSize
            	
            	scale <40, 90, 20>

            	rotate 10*x
            	

            	translate -1*z
            	
            	translate <-900, -70, 0> / AtmosphereBoxSize
            }
		}
		media		// clouds
		{
            scattering
            {
				1,  rgb 0.01
            }

			absorption 0.1
            
            density
            {
            	gradient z
            	
            	density_map
            	{
            		[ 0.30  NoDensity ]
            		[ 1.00  FarBozoDensity scale <10, 10, 30> / AtmosphereBoxSize ]
            	}
            	
            	warp
            	{
            		turbulence 0.3
            	}
            	
            	scale 2.5
            	translate -1.5
			}
		}
#end
#if ( false )
		media		// spray (tower)
		{
			//method 1
			intervals 10
			//samples 1,10
			
            emission 5.3
            /*scattering
            {
            	1, rgb 1
            }*/
            //absorption 1
            
            density
            {
            	spherical
            	
            	density_map
            	{
            		[ 0.00  NoDensity ]
            		[ 1.00  NearBozoDensity scale <0.1, 0.1, 0.2> ]
            	}
            	
            	warp
            	{
            		turbulence 0.5
            	}
           	
            	scale <10, 10, 10> / AtmosphereBoxSize
            	
				rotate 20*y
				
            	translate -1*z
            	
            	translate <0, 0, 0> / AtmosphereBoxSize
            }
		}
#end
	}
}
