// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.5
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?
//

//#version 3.5;
#version unofficial megapov 1.2; 

#include "colors.inc"   
#include "shapes.inc"     
#include "textures.inc" 
#include "simplemoss.inc"



#declare useFunctions=1;                            
#declare useTestTex=0;
#declare useHDRI = 1;     
#declare useRadiosity = 1; //0=none, 1=load, 2=save       
#declare useFocalBlur = 1;

global_settings {
  assumed_gamma 1.0
}

// ----------------------------------------

camera {
  location  <0.0, 20, -16.0>
  direction 1.5*z
  right     x*image_width/image_height
  look_at   <-4.0, 0.0,  15.0>
#if(useFocalBlur)
  aperture 0.1           // [0...N] larger is narrower depth of field (blurrier)
  blur_samples 5        // number of rays per pixel for sampling
  focal_point <-4,0,15>    // point that is in focus <X,Y,Z>
  confidence 0.995           // [0...<1] when to move on while sampling (smaller is less accurate)
  variance 1/20000            // [0...1] how precise to calculate (smaller is more accurate)
#end
}

// create a regular point light source
light_source {
  0*x                  // light's position (translated below)
  color rgb <1.7,1.6,1.3>
  area_light
  <3, 0, 0> <0, 0, 3> // lights spread out across this distance (x * z)
  10, 10                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3...
  jitter              // adds random softening of light
  circular            // make the shape of the light circular
  orient              // orient light
  translate <20, 20, -20>       
  // light_source { ...
  // put this inside a light_source to add light fading
  fade_distance 40
  fade_power 2
}

light_source {
  0*x                  // light's position (translated below)
  color rgb <1.7,1.6,1.3>*5
  area_light
  <3, 0, 0> <0, 0, 3> // lights spread out across this distance (x * z)
  10, 10                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3...
  jitter              // adds random softening of light
  circular            // make the shape of the light circular
  orient              // orient light
  translate <20, 20, -20>       
  projected_through { object { box { <6,-3,-4> <10,8,-1> } } }
  // light_source { ...
  // put this inside a light_source to add light fading
  fade_distance 40
  fade_power 2
}


#declare hair = union { 
         object { simplemoss_13_stems }
         object { simplemoss_13_leaves }
         scale 3
         }  
#declare generalRand = seed(1327);   

// Macro to return a random number

#macro gr(num)
        rand(generalRand)*num
#end

#if(useHDRI)
sphere {
  0,50
  pigment { image_map { hdr "thekitchen.hdr" once interpolate 2 map_type 1 } }
  finish { ambient 0.55 diffuse 0 }
  scale <1,1,1>
  hollow
  //rotate x*180 
  rotate <0, 0, 0> 
  translate <0, 10, 0>
}           
#end   

#declare PRETRACE_END=2/image_width;

global_settings {
 assumed_gamma 1.0
// ambient_light 0.0 
 max_trace_level 15        
#if(useRadiosity) 
 radiosity{ 
  // save settings: modified Outdoor settings from rad_def.inc
  #if (useRadiosity=2) 
//    adaptive 1
    pretrace_start 1
    pretrace_end  PRETRACE_END //1/image_width   
    
    count 500
    nearest_count 10
    //error_bound 0.2   
    error_bound { 0.2 adaptive 2.0, 20 }
  
    low_error_factor .8
    gray_threshold 0
    recursion_limit 2
    brightness 0.8
    adc_bailout 0.01/2
    normal on
    randomize on
    save_file "absence.rad"
  #end
  #if(useRadiosity=1)
    // load settings  
    pretrace_start 1 pretrace_end 1 
    load_file "absence.rad" 
//    error_bound 0.07    // it's important to specify the same value used to save data
    error_bound { 0.2 adaptive 2.0, 20 }
    recursion_limit 2  // also the same if specified
    always_sample off  // no more samples: specially useful with focal blur
    normal on
    randomize on
  #end
 }
 #end
}  

#declare whiska = sphere_sweep 
{
        //linear_spline                 // linear curve
        cubic_spline                // alternative spline curves
        //b_spline
        6,                            // number of specified sphere positions
        <0, 0, 0>, .05                // position, radius
        <-0.1, 0, -1>, .05                 // ...
        < 0.1, 0.05, -2>, .05
        < 0, -0.02, -3>, .05   
        < 0.025, 0, -4>, .05   
        < -0.1, -.05, -5>, .05   
        
        tolerance 0.01  
        bounded_by { box { <-1, -0.75, -6> <1, 0.75, 0.1> } }   
        scale 0.25     
} 

// floor  


#declare testTex = texture { pigment { rgb <0.6, 0.5, 0.475> } finish { ambient 0 } }

#if(useTestTex)
#declare tileTex = texture 
{ 
        pigment 
        { 
                bozo
                turbulence 0.2
                omega 0.65 
                lambda 3.5
                colour_map
                {
                        [ 0.0 rgb <0.8, 0.7, 0.65> ]
                        [ 0.2 rgb <0.8, 0.7, 0.65> ]
                        [ 1.0 rgb <0.5, 0.33, 0.08> ]
                }   
                scale 1.25
        }
        finish { ambient 0 phong 0.15 phong_size 25 reflection 0.002 }
        normal { granite 0.2 turbulence 1 scale 0.1 }  
}        
#else
#declare tileTex = texture 
{ 
        pigment 
        { 
                bozo
                turbulence 0.2
                omega 0.65 
                lambda 3.5
                colour_map
                {
                        [ 0.0 rgb <0.85, 0.83, 0.55> ]
                        [ 0.4 rgb <0.85, 0.83, 0.55> ]
                        [ 1.0 rgb <0.7, 0.48, 0.15> ]
                }   
                scale <1.5, 1.3, 1.4>
        }
        finish { ambient 0 phong 0.25 diffuse 0.5 phong_size 25 reflection 0.002 }
        normal { granite 0.4 turbulence 1 scale 0.1 }  
}        
texture
{ 
        pigment 
        { 
                marble
                turbulence 0.375
                omega 0.615 
                lambda 3.5
                colour_map
                {
                        [ 0.0 rgbt <1, 1, 1, 1> ]
                        [ 0.2 rgbt <1, 1, 1, 1> ]
                        [ 0.2 rgbt <0.3, 0.3, 0.3, 1> ]
                        [ 0.22 rgbt <0.3, 0.3, 0.3, 0.2> ]
                        [ 0.25 rgbt <0.3, 0.3, 0.3, 1> ]
                        [ 0.25 rgbt <1, 1, 1, 1> ]
                        [ 0.6 rgbt <1, 1, 1, 1> ]
                        [ 0.6 rgbt <0.2, 0.2, 0.2, 1> ]
                        [ 0.61 rgbt <0.2, 0.2, 0.2, 0.3> ]
                        [ 0.63 rgbt <0.2, 0.2, 0.2, 1> ]
                        [ 0.63 rgbt <1, 1, 1, 1> ]
                        [ 1.0 rgbt <1, 1, 1, 1> ]
                }   
                rotate <0, 35, 60> rotate <45, 0, 0>
                scale 0.7
        }
        finish { ambient 0 phong 0.25 diffuse 0.5 phong_size 25 reflection 0.002 }
        normal { granite 0.4 turbulence 1 scale 0.1 }  
}        
texture
{ 
        pigment 
        { 
                marble
                turbulence 0.475
                omega 0.625 
                lambda 3.25
                colour_map
                {
                        [ 0.0 rgbt <1, 1, 1, 1> ]
                        [ 0.1 rgbt <1, 1, 1, 1> ]
                        [ 0.1 rgbt <0.3, 0.1, 0.01, 1> ]
                        [ 0.15 rgbt <0.3, 0.1, 0.01, 0.2> ]
                        [ 0.2 rgbt <0.3, 0.1, 0.01, 1> ]
                        [ 0.2 rgbt <1, 1, 1, 1> ]
                        [ 0.6 rgbt <1, 1, 1, 1> ]
                        [ 0.6 rgbt <0.3, 0.2, 0.03, 1> ]
                        [ 0.65 rgbt <0.3, 0.2, 0.03, 0.3> ]
                        [ 0.7 rgbt <0.3, 0.2, 0.03, 1> ]
                        [ 0.8 rgbt <1, 1, 1, 1> ]
                        [ 1.0 rgbt <1, 1, 1, 1> ]
                }   
                rotate <0, -45, 70> rotate <65, 0, 0>
                scale <1.25, 1, 2>
        }
        finish { ambient 0 phong 0.25 diffuse 0.5 phong_size 25 reflection 0.002 }
        normal { granite 0.4 turbulence 1 scale 0.1 }  
}
texture
{ 
        pigment 
        { 
                wrinkles 
                scallop_wave
                turbulence 0.875
                omega 0.75 
                lambda 3.5
                colour_map
                {
                        [ 0.0 rgbt <1, 1, 1, 1> ]
                        [ 0.1 rgbt <1, 1, 1, 1> ]
                        [ 0.1 rgbt <0.2, 0.1, 0.01, 1> ]
                        [ 0.15 rgbt <0.2, 0.1, 0.01, 0.3> ]
                        [ 0.2 rgbt <0.2, 0.1, 0.01, 1> ]
                        [ 0.2 rgbt <1, 1, 1, 1> ]
                        [ 0.6 rgbt <1, 1, 1, 1> ]
                        [ 0.6 rgbt <0.1, 0.04, 0.0, 1> ]
                        [ 0.65 rgbt <0.1, 0.04, 0.0, 0.4> ]
                        [ 0.7 rgbt <0.1, 0.04, 0.0, 1> ]
                        [ 0.8 rgbt <1, 1, 1, 1> ]
                        [ 1.0 rgbt <1, 1, 1, 1> ]
                }   
        }
        finish { ambient 0 phong 0.25 diffuse 0.5 phong_size 25 reflection 0.002 }
        normal { granite 0.4 turbulence 1 scale 0.1 }  
} 
texture 
{
        pigment
        {
                gradient x
                turbulence 0.02 
                omega 0.7
                lambda 3
                colour_map
                {
                        [ 0.0 rgbt <0.035, 0.025, 0.01, 0> ]
                        [ 0.1 rgbt <0.035, 0.025, 0.01, 0.1> ]
                        [ 0.11 rgbt <0.15, 0.1, 0.05, 0.3> ]
                        [ 0.125 rgbt <0.25, 0.18, 0.08, 0.9> ]
                        [ 0.4 rgbt <0.25, 0.18, 0.08, 1> ]
                        [ 0.4 rgbt <1, 1, 1, 1> ]
                        [ 1.0 rgbt <1, 1, 1, 1> ]
                } 
                scale 100
                translate <-27.75, 0, 0>
        }
        finish 
        {
                ambient 0 phong 0.05 diffuse 0.4 phong_size 10 reflection 0 
        }       
        normal { granite 0.4 turbulence 1 scale 0.1 }  
}
texture 
{
        pigment
        {
                gradient z    
                turbulence 0.015
                omega 0.7
                lambda 3
                colour_map
                {
                        [ 0.0 rgbt <1, 1, 1, 1> ]
                        [ 0.6 rgbt <1, 1, 1, 1> ]
                        [ 0.6 rgbt <0.25, 0.18, 0.08, 1> ]
                        [ 0.8 rgbt <0.15, 0.1, 0.05, 0.9> ]
                        [ 0.825 rgbt <0.125, 0.08, 0.04, 0.3> ]
                        [ 0.85 rgbt <0.1, 0.025, 0.02, 0.15> ]
                        [ 1.0 rgbt <0.035, 0.01, 0.001, 0.1> ]
                } 
                scale 100
                translate <0, 0, -64.1>
        }
        finish 
        {
                ambient 0 phong 0.05 diffuse 0.4 phong_size 10 reflection 0 
        }       
        normal { granite 0.4 turbulence 1 scale 0.1 }  
}  
texture 
{ 
        pigment 
        { 
                bozo
                turbulence 0.5
                omega 0.65 
                lambda 3.5
                colour_map
                {
                        [ 0.0 rgbt <0.85, 0.83, 0.55,1> ]
                        [ 0.4 rgbt <0.85, 0.83, 0.55,0.9> ]
                        [ 1.0 rgbt <0.85, 0.83, 0.55,1> ]
                }   
                scale 0.5
        }
        finish { ambient 0 phong 0.25 diffuse 0.5 phong_size 25 reflection 0.002 }
        normal { granite 0.4 turbulence 1 scale 0.1 }  
}        
       
#end

#declare zTile=-50;   
#declare tileSize=2;
#declare tileDepth=1; 
#declare tScale=0.98;
union
{
#while(zTile < 30)
        #declare xTile=-20;
        #while(xTile < 25)
                isosurface 
                {
                        #if(useFunctions)
                                function{f_rounded_box(x,y,z,0.1, tileSize*tScale*0.99, tileDepth*0.95, tileSize*tScale*0.99)-(f_dents(x*.75,y*.75,z*.75)*0.1)}
                        #else
                                function{f_rounded_box(x,y,z,0.1, tileSize*tScale, tileDepth, tileSize*tScale)}
                        #end
                        contained_by { box { <-tileSize*1.1, -tileDepth*1.1, -tileSize*1.1> <tileSize*1.1, tileDepth*1.1, tileSize*1.1> } }             
                        accuracy 0.0005
                        max_gradient 1.125       

                        // randomly rotate tiles by 90 degrees
                        rotate <0, floor(gr(4))*90, 0>
                        translate <xTile, -tileDepth, zTile>   
                }
                #declare xTile=xTile+tileSize*2;
        #end
        #declare zTile=zTile+tileSize*2;
#end
                        texture { tileTex }   
 }
// floor under tiles
box { <-50, -2, -50> <50, -0.1, 50>  
texture
{ 
        pigment 
        { 
                granite
                cubic_wave
                turbulence 0.45
                omega 0.7 
                lambda 3.5
                colour_map
                {
                        [ 0.0 rgb  <0.4, 0.3, 0.1> ]
                        [ 0.25 rgb <0.55, 0.49, 0.175> ]
                        [ 0.65 rgb <0.45, 0.3, 0.1> ]
                        [ 1.0 rgb  <0.5, 0.42, 0.18> ]
                }        
                scale 0.05
        }
        finish { ambient 0 diffuse 0.4 }
        normal { granite 1 turbulence 0.5 scale 0.1 }  
}
texture
{ 
        pigment 
        { 
                wrinkles 
                sine_wave
                turbulence 0.275
                omega 0.75 
                lambda 3.5
                colour_map
                {
                        [ 0.0 rgbt <1, 1, 1, 1> ]
                        [ 0.1 rgbt <1, 1, 1, 1> ]
                        [ 0.1 rgbt <0.2, 0.1, 0.01, 1> ]
                        [ 0.4 rgbt <0.2, 0.1, 0.01, 0.3> ]
                        [ 0.6 rgbt <0.2, 0.1, 0.01, 1> ]
                        [ 0.6 rgbt <1, 1, 1, 1> ]
                        [ 0.7 rgbt <1, 1, 1, 1> ]
                        [ 0.7 rgbt <0.1, 0.04, 0.0, 1> ]
                        [ 0.8 rgbt <0.1, 0.04, 0.0, 0.4> ]
                        [ 0.9 rgbt <0.1, 0.04, 0.0, 1> ]
                        [ 0.9 rgbt <1, 1, 1, 1> ]
                        [ 1.0 rgbt <1, 1, 1, 1> ]
                }   
        }
        finish { ambient 0 diffuse 0.4 }
        normal { granite 1 turbulence 0.5 scale 0.1 }  
}
}
#if(useTestTex)
#declare cupboardWoodTex = testTex;
#declare worktopTex = testTex;
#else
#declare cupboardWoodTex = texture
{
        pigment 
        {
                bozo                 
                turbulence 0.475
                omega 0.7
                lambda 4
                colour_map
                {
                        [ 0.0 rgb <0.38, 0.17, 0.04> ]
                        [ 0.2 rgb <0.25, 0.125, 0.03> ]
                        [ 0.4 rgb <0.34, 0.23, 0.06> ]
                        [ 0.7 rgb <0.21, 0.10, 0.03> ]
                        [ 0.85 rgb <0.25, 0.132, 0.035> ]
                        [ 1.0 rgb <0.2, 0.05, 0.005> ]
                }                                  
                scale <5, 0.2,0.2>
                rotate <0, 1, 0>                
                 
        }      
}     
texture
{
        pigment 
        {
                wood                 
                turbulence 0.315
                omega 0.65
                lambda 3.5
                colour_map
                {
                        [ 0.0 rgbt <0.4, 0.16, 0.045, 0.35> ]
                        [ 0.2 rgbt <0.3, 0.120, 0.023, 0.35> ]
                        [ 0.4 rgbt <0.35, 0.19, 0.05, 0.35> ]
                        [ 0.7 rgbt <0.2, 0.1, 0.03, 0.35> ]
                        [ 0.85 rgbt <0.25, 0.118, 0.025, 0.35> ]
                        [ 1.0 rgbt <0.2, 0.05, 0.001, 0.35> ]
                }                                  
                rotate <0, 90, 0>                                 
                scale <1, 0.2,0.2>
                rotate <0, 5, 0.1>                
                 
        }      
}     
texture // varnish
{
        pigment 
        { 
                wrinkles 
                triangle_wave    
                turbulence 0.8
                omega 0.65 
                colour_map 
                { 
                        [ 0.0 rgbt <0.275, 0.18, 0.05, 0.95> ]
                        [ 0.075 rgbt <0.225, 0.14, 0.02, 0.9> ]
                        [ 0.15 rgbt <0.3, 0.18, 0.03, 0.95> ]
                        [ 0.2 rgbt <0.25, 0.135, 0.05, 0.925> ]
                        [ 0.25 rgbt <0.25, 0.1, 0.03, 0.95> ]
                        [ 1.0 rgbt <0.2, 0.125, 0.05, 0.9> ]
                }               
                scale 10
        }
        finish { ambient 0 phong 0.3 phong_size 40 reflection 0.01 }     
        normal {
                average 
                normal_map
                {
                        [ 1 wrinkles 0.075 turbulence 0.1 scale <100, 0.01, 0.01> rotate <0, 0, 1> ]
                        [ 1 dents 1 turbulence 0.2 scale <0.5, 0.4, 0.4> ]
                }
        }
        
}
/*
texture
{
        pigment 
        {
                bozo                 
                turbulence 0.475
                omega 0.7
                lambda 4
                colour_map
                {
                        [ 0.0 rgb <0.61, 0.3, 0.075> ]
                        [ 0.2 rgb <0.36, 0.172, 0.03> ]
                        [ 0.4 rgb <0.547, 0.363, 0.1> ]
                        [ 0.7 rgb <0.3, 0.133, 0.022> ]
                        [ 0.85 rgb <0.41, 0.24, 0.026> ]
                        [ 1.0 rgb <0.31, 0.07, 0.001> ]
                }                                  
                scale <5, 0.1,0.1>
                rotate <0, 1, 0>                
                 
        }      
}     
texture
{
        pigment 
        {
                wood                 
                turbulence 0.275
                omega 0.65
                lambda 3.5
                colour_map
                {
                        [ 0.0 rgbt <0.61, 0.3, 0.07, 0.35> ]
                        [ 0.2 rgbt <0.36, 0.172, 0.033, 0.35> ]
                        [ 0.4 rgbt <0.547, 0.363, 0.1, 0.35> ]
                        [ 0.7 rgbt <0.3, 0.133, 0.022, 0.35> ]
                        [ 0.85 rgbt <0.41, 0.24, 0.03, 0.35> ]
                        [ 1.0 rgbt <0.31, 0.07, 0.001, 0.35> ]
                }                  
                rotate <0, 90, 0>                                 
                scale <1, 0.1,0.1>
                rotate <0, 4, 0>                
                 
        }      
}     
texture // varnish
{
        pigment 
        { 
                wrinkles 
                triangle_wave
                turbulence 0.8
                omega 0.65
                lambda 3 
                colour_map 
                { 
                        [ 0.0 rgbt <0.3, 0.1, 0, 0.95> ]
                        [ 0.075 rgbt <0.3, 0.05, 0, 0.9> ]
                        [ 0.15 rgbt <0.3, 0.1, 0, 0.95> ]
                        [ 0.2 rgbt <0.3, 0.05, 0, 0.925> ]
                        [ 0.25 rgbt <0.3, 0, 0, 0.95> ]
                        [ 1.0 rgbt <0.3, 0.05, 0, 0.9> ]
                }               
                scale 10
        }
        finish { ambient 0 phong 0.2 phong_size 35 reflection 0.003 }     
        normal { wrinkles 0.25 turbulence 0.25 scale <100, 0.01, 0.05> rotate <0, 1, 0> }        
}
*/
#declare worktopTex1 = texture
{
        pigment 
        {
                bozo                 
                turbulence 0.475
                omega 0.7
                lambda 4
                colour_map
                {
                        [ 0.0 rgb <0.4, 0.16, 0.045> ]
                        [ 0.2 rgb <0.25, 0.120, 0.023> ]
                        [ 0.4 rgb <0.35, 0.18, 0.05> ]
                        [ 0.7 rgb <0.22, 0.1, 0.03> ]
                        [ 0.85 rgb <0.25, 0.120, 0.025> ]
                        [ 1.0 rgb <0.21, 0.05, 0.001> ]
                }                                  
                scale <5, 0.2,0.2>
                rotate <0, 1, 0>                
                 
        }      
}     
texture
{
        pigment 
        {
                wood                 
                turbulence 0.315
                omega 0.65
                lambda 3.5
                colour_map
                {
                        [ 0.0 rgbt <0.4, 0.16, 0.045, 0.35> ]
                        [ 0.2 rgbt <0.25, 0.119, 0.023, 0.35> ]
                        [ 0.4 rgbt <0.35, 0.20, 0.05, 0.35> ]
                        [ 0.7 rgbt <0.22, 0.1, 0.03, 0.35> ]
                        [ 0.85 rgbt <0.25, 0.120, 0.025, 0.35> ]
                        [ 1.0 rgbt <0.22, 0.05, 0.001, 0.35> ]
                }                                  
                rotate <0, 90, 0>                                 
                scale <1, 0.2,0.2>
                rotate <0, 0.5, 10>                
                 
        }      
}     
texture // varnish
{
        pigment 
        { 
                wrinkles 
                triangle_wave    
                turbulence 0.8
                omega 0.65 
                colour_map 
                { 
                        [ 0.0 rgbt <0.25, 0.1, 0.05, 0.95> ]
                        [ 0.075 rgbt <0.225, 0.08, 0.04, 0.9> ]
                        [ 0.15 rgbt <0.3, 0.08, 0.03, 0.95> ]
                        [ 0.2 rgbt <0.25, 0.05, 0.02, 0.925> ]
                        [ 0.25 rgbt <0.25, 0.08, 0.04, 0.95> ]
                        [ 1.0 rgbt <0.2, 0.075, 0.04, 0.9> ]
                }               
                scale 10
        }
        finish { ambient 0 phong 0.3 phong_size 40 reflection 0.01 }     
        normal 
        { 
                average
                normal_map
                {
                        [ 1 wrinkles 0.05 turbulence 0.1 scale <100, 0.01, 0.01> rotate <0, 0, 1> ]
                        [ 1 dents 1 turbulence 0.2 scale <0.5, 0.4, 0.4> ]
                }
        }         
}

#declare worktopTex2 = texture
{
        pigment 
        {
                bozo                 
                turbulence 0.375
                omega 0.7
                lambda 4
                colour_map
                {
                        [ 0.0 rgb <0.4, 0.16, 0.045>*0.8]
                        [ 0.2 rgb <0.25, 0.110, 0.023>*0.8 ]
                        [ 0.4 rgb <0.35, 0.20, 0.05>*0.8 ]
                        [ 0.7 rgb <0.22, 0.1, 0.03>*0.8 ]
                        [ 0.85 rgb <0.25, 0.120, 0.025>*0.8 ]
                        [ 1.0 rgb <0.22, 0.05, 0.001>*0.8 ]
                }                                  
                scale <5, 0.2,0.2>
                rotate <0, 1, 0>                
                 
        }      
}     
texture
{
        pigment 
        {
                wood                 
                turbulence 0.135
                omega 0.65
                lambda 3
                colour_map
                {
                        [ 0.0 rgbt <0.4*0.8, 0.16*0.8, 0.045*0.9, 0.5> ]
                        [ 0.2 rgbt <0.25*0.8, 0.112*0.8, 0.023*0.9, 0.5> ]
                        [ 0.4 rgbt <0.35*0.8, 0.20*0.8, 0.05*0.9, 0.5> ]
                        [ 0.7 rgbt <0.22*0.8, 0.1*0.8, 0.03*0.9, 0.5> ]
                        [ 0.85 rgbt <0.25*0.8, 0.118*0.8, 0.025*0.9, 0.5> ]
                        [ 1.0 rgbt <0.22*0.8, 0.05*0.8, 0.001*0.9, 0.5> ]
                }                                  
                rotate <0, 90, 0>                                 
                scale <1, 0.2,0.2>
                rotate <0, 0.5, 10>                
                 
        }      
}     
texture // varnish
{
        pigment 
        { 
                wrinkles 
                triangle_wave    
                turbulence 0.8
                omega 0. 
                colour_map 
                { 
                        [ 0.0 rgbt <0.25, 0.1, 0.05, 0.95> ]
                        [ 0.075 rgbt <0.225, 0.07, 0.04, 0.9> ]
                        [ 0.15 rgbt <0.3, 0.1, 0.05, 0.95> ]
                        [ 0.2 rgbt <0.25, 0.05, 0.02, 0.925> ]
                        [ 0.25 rgbt <0.25, 0.04, 0.02, 0.95> ]
                        [ 1.0 rgbt <0.2, 0.05, 0.03, 0.9> ]
                }               
                scale 10
        }
        finish { ambient 0 phong 0.3 phong_size 40 reflection 0.01 }     
        normal 
        { 
                average
                normal_map
                {
                        [ 1 wrinkles 0.05 turbulence 0.1 scale <100, 0.01, 0.01> rotate <0, 0, 1> ]
                        [ 1 dents 1 turbulence 0.2 scale <0.5, 0.4, 0.4> ]
                }
        }
}  


#declare wt1 = texture
{
        gradient x
        texture_map
        {
                [ 0.0 worktopTex1 ]
                [ 0.5 worktopTex1 ]
                [ 0.5 worktopTex2 ]
                [ 1.0 worktopTex2 ]                                
        }    
        scale <10, 1, 1>                      
}                                  

#declare wt2 = texture
{
        gradient x
        texture_map
        {
                [ 0.0 worktopTex1 ]
                [ 0.5 worktopTex1 ]
                [ 0.5 worktopTex2 ]
                [ 1.0 worktopTex2 ]                                
        }                          
        scale <10, 1, 1>
        translate <2.5, 3, 5>                      
} 

#declare worktopTex = texture
{
        gradient z
        texture_map
        {
                [ 0.0 wt1 ]
                [ 0.5 wt1 ]
                [ 0.5 wt2 ]
                [ 1.0 wt2 ]                
        }           
        scale <1, 1, 1.25>
}                                 

#end                 

#declare handleTex = texture
{
        pigment 
        {
                agate
                turbulence 1
                lambda 5
                colour_map
                {
                        [ 0 rgb <0.002, 0.001, 0> ]
                        [ 1 rgb <0.1, 0.1, 0.1> ]                                               
                }                                  
                scale 0.01
        }
        normal
        {
                dents 5 scale 0.01 
        }
        finish
        {
          ambient 0 specular 0.6 roughness 0.02 reflection { 0.01, 0.08 fresnel on metallic } conserve_energy 
        }
}                         


#macro mkCupboard()
union
{
      box { <0, 1, 0.5> <7, 10, 8> } // cupboards   

        object { Round_Box_Union(<0.1, 1.1, 0>, <1.5, 9.9, 0.5>, 0.25) texture { cupboardWoodTex  rotate <0, 0, 90> } }
        object { Round_Box_Union(<5.5, 1.1, 0>, <6.9, 9.9, 0.5>, 0.25) texture { cupboardWoodTex  rotate <0, 0, 90> }}
        object { Round_Box_Union(<0.1, 8.5, 0.01>, <6.9, 9.9, 0.5>, 0.25) texture { cupboardWoodTex  rotate <0, 0, 0> }}
        object { Round_Box_Union(<0.1, 1.1, 0.01>, <6.9, 2.5, 0.5>, 0.25) texture { cupboardWoodTex  rotate <0, 0, 0> }} 
        cylinder { <1.5, 2, 0.25> <1.5, 9, 0.25> 0.1 texture { cupboardWoodTex  rotate <0, 0, 90> }}
        cylinder { <5.5, 2, 0.25> <5.5, 9, 0.25> 0.1 texture { cupboardWoodTex  rotate <0, 0, 90> }}
        cylinder { <1, 2.5, 0.25> <6, 2.5, 0.25> 0.1 texture { cupboardWoodTex  rotate <0, 0, 0> }}
        cylinder { <1, 9.5, 0.25> <6, 9.5, 0.25> 0.1 texture { cupboardWoodTex  rotate <0, 0, 0> }}  
        box { <1, 2, 0.25> <6, 9, 0.5> texture { cupboardWoodTex  rotate <0, 0, 90> }} // cupboards   
        // handle
        union
        {
                difference
                {
                        torus { 0.7, 0.075 }
                        box { <-1.7, -0.2, -0.3> <1.7, 0.2, 1.7> }
                        translate <0, 0, 0.3>
                        rotate <0, 0, 90>
                }
                object { Round_Cylinder_Union(<0, 0, -0.05>, <0, 0, 0.1>, 0.12, 0.025) scale <1, 1.5, 1> translate <0, 0.65, 0> }
                object { Round_Cylinder_Union(<0, 0, -0.05>, <0, 0, 0.1>, 0.12, 0.025) scale <1, 1.5, 1> translate <0, -0.65, 0> }
                sphere { <0, 0.75, -0.055> 0.05 }
                sphere { <0, -0.75, -0.055> 0.05 }
                texture { handleTex }
                
                translate <6.25, 8.5, 0>
        }
      texture { cupboardWoodTex  rotate <0, 0, 90> }
      //   { <0, 1, 0> <8, 8, 1> } // cupboards   
}
#end


#macro mkDrawers()
union
{
      box { <0, 1, 0.5> <5, 10, 8> } // back part   

      #local dCount=0;
      #while(dCount < 5)
      
        object { Round_Box_Union(<0, 1.1, 0.01>, <5, 2.8, 0.5>, 0.25) translate <0, 1.76*dCount, 0> texture { cupboardWoodTex  rotate <0, 0, 0> }}
        // handle
        union
        {
                difference
                {
                        torus { 0.7, 0.075 }
                        box { <-1.7, -0.2, -0.3> <1.7, 0.2, 1.7> }
                        translate <0, 0, 0.3>
                        rotate <0, 0, 90>
                }
                object { Round_Cylinder_Union(<0, 0, -0.05>, <0, 0, 0.1>, 0.12, 0.025) scale <1, 1.5, 1> translate <0, 0.65, 0> }
                object { Round_Cylinder_Union(<0, 0, -0.05>, <0, 0, 0.1>, 0.12, 0.025) scale <1, 1.5, 1> translate <0, -0.65, 0> }
                sphere { <0, 0.75, -0.055> 0.05 }
                sphere { <0, -0.75, -0.055> 0.05 }
                texture { handleTex }
                rotate <0, 0, 90>
                translate <2.5, 1.95+(dCount*1.76), 0>
        }

        #local dCount=dCount+1;
      #end


      //   { <0, 1, 0> <8, 8, 1> } // cupboards   
texture { cupboardWoodTex  rotate <0, 0, 90> }
}
#end

#macro mkCornerCupboard()
union
{
      box { <-8, 1, 0.5> <4.5, 10, 8> } // cupboard back
      box { <-8, 1, -4.5> <-0.5, 10, 8> } // cupboard back   

        object { Round_Box_Union(<-0.1, 1.1, 0>, <1.3, 9.9, 0.5>, 0.25) texture { cupboardWoodTex  rotate <0, 0, 90> } }
        object { Round_Box_Union(<3, 1.1, 0>, <4.4, 9.9, 0.5>, 0.25) texture { cupboardWoodTex  rotate <0, 0, 90> }}
        object { Round_Box_Union(<0, 8.5, 0.01>, <4.4, 9.9, 0.5>, 0.25) texture { cupboardWoodTex  rotate <0, 0, 0> } }
        object { Round_Box_Union(<0, 1.1, 0.01>, <4.4, 2.5, 0.5>, 0.25) texture { cupboardWoodTex  rotate <0, 0, 0> } } 
        cylinder { <1.3, 2, 0.25> <1.3, 9, 0.25> 0.1 texture { cupboardWoodTex  rotate <0, 0, 90> }}
        cylinder { <3, 2, 0.25> <3, 9, 0.25> 0.1 texture { cupboardWoodTex  rotate <0, 0, 90> }}
        cylinder { <1, 2.5, 0.25> <4, 2.5, 0.25> 0.1 texture { cupboardWoodTex  rotate <0, 0, 0> }}
        cylinder { <1, 9.5, 0.25> <4, 9.5, 0.25> 0.1 texture { cupboardWoodTex  rotate <0, 0, 0> }}    
        box { <1, 2, 0.25> <4, 9, 0.5> texture { cupboardWoodTex  rotate <0, 0, 90> }} // cupboards   

        // left side
        object { Round_Box_Union(<-0.5, 1.1, -4.4>, <0, 9.9, -3>, 0.25) texture { cupboardWoodTex  rotate <90, 0, -90> }}
        object { Round_Box_Union(<-0.5, 1.1, -1.4>, <0, 9.9, 0>, 0.25) texture { cupboardWoodTex  rotate <90, 0, -90> }}
        object { Round_Box_Union(<-0.5, 8.5, -4.4>, <0, 9.9, -1>, 0.25) texture { cupboardWoodTex  rotate <0, -90, 0> }}
        object { Round_Box_Union(<-0.5, 1.1, -4.4>, <0, 2.5, -1>, 0.25) texture { cupboardWoodTex  rotate <0, -90, 0> }} 
        cylinder { <-0.25, 2, -3> <-0.25, 9, -3> 0.1 texture { cupboardWoodTex  rotate <90, 0, -90> }}
        cylinder { <-0.25, 2, -1.4> <-0.25, 9, -1.4> 0.1 texture { cupboardWoodTex  rotate <90, 0, -90> }}
        cylinder { <-0.25, 2.5, -4> <-0.25, 2.5, -1> 0.1 texture { cupboardWoodTex  rotate <0, -90, 0> }}
        cylinder { <-0.25, 9.5, -4> <-0.25, 9.5, -1> 0.1 texture { cupboardWoodTex  rotate <0, -90, 0> }}    
        box { <-0.25, 2, -4> <-0.25, 9, -1> texture { cupboardWoodTex  rotate <90, 0, -90> }} // cupboards   
        
        
        // hinge
        union
        {
                cylinder { <-0.1, 1.2, 0.1> <-0.1, 9.7, 0.1> 0.025 }
        #local hLength=(9.7-1.2)/15;
        #local hPos=1.2;
        #while(hPos < 9.7-hLength)
                Round_Cylinder_Union(<-0.1, hPos+(hLength/25), 0.1>, <-0.1, hPos+hLength-(hLength/25), 0.1>, 0.04, 0.015)
                #local hPos=hPos+hLength;
        #end   
/*        texture
        {
                pigment 
                { 
                        bozo    
                        turbulence 0.435
                        
                        colour_map
                        {
                                [ 0.0 rgb <0.01, 0.01, 0.01> ]
                                [ 0.4 rgb <0.02, 0.01, 0.0> ]
                                [ 0.8 rgb <0.1, 0.06, 0.01> ]
                                [ 1.0 rgb <0.03, 0.01, 0.001> ]
                        }    
                        scale 0.1
                }
                normal { dents scale 0.05 }
                finish 
                {
                        specular 0.7
                        roughness 0.01
                        brilliance 5
                        ambient 0
                        diffuse 0.5
                        reflection { 0.01, 0.075 fresnel on metallic } 
                        conserve_energy
                }         
        } 
        */
texture {
    pigment { rgb <0.2, 0.2, 0.2> }
    finish {
        ambient 0.0
        diffuse 0.15
        brilliance 5.0
        reflection { 0.05, 0.3 fresnel on metallic }
        specular 0.8
        roughness 0.01       
        metallic                                    
        conserve_energy
        }    
        normal
        {
                dents 0.1 
                turbulence 0.1256
                scale <.2, 1.5, .2>
                rotate <15, 5, -30>
        }
}             
texture
{
        pigment 
        {       
                dents  
                turbulence 0.3244
                colour_map
                {
                        [ 0.0 rgbf <1, 1, 1, 1> ]
                        [ 0.8 rgbf <1, 1, 1, 1> ]
                        [ 1.001 rgbf <0.1, 0.05, 0, 0> ]
                }    
                scale <0.25, 1.7, 0.5>
                rotate <10, 0, -20>    
        }
                
                                                   
        finish
        {
                ambient 0
                diffuse 0.3
                reflection 0.0001
                specular 0.02
                roughness 0.15
        }   
        normal
        {
                granite
        }
        }         
        }
        // handle
        union
        {
                difference
                {
                        torus { 0.7, 0.075 }
                        box { <-1.7, -0.2, -0.3> <1.7, 0.2, 1.7> }
                        translate <0, 0, 0.3>
                        rotate <0, 0, 90>
                }
                object { Round_Cylinder_Union(<0, 0, -0.05>, <0, 0, 0.1>, 0.12, 0.025) scale <1, 1.5, 1> translate <0, 0.65, 0> }
                object { Round_Cylinder_Union(<0, 0, -0.05>, <0, 0, 0.1>, 0.12, 0.025) scale <1, 1.5, 1> translate <0, -0.65, 0> }
                sphere { <0, 0.75, -0.055> 0.05 }
                sphere { <0, -0.75, -0.055> 0.05 }
                texture { handleTex }
                
                translate <3.75, 8.5, 0>
        }
texture { cupboardWoodTex  rotate <0, 0, 90> }
      //   { <0, 1, 0> <8, 8, 1> } // cupboards   
}
#end

#declare blackPlastic = texture 
{
        pigment
        {
                rgb <0.005, 0.005, 0.005> 
        }                                 
        finish { ambient 0 phong 0.2 phong_size 20 }
        normal { granite 0.2 scale 0.001 }
} 

#declare brushedChrome = texture
{
        pigment { rgb <0.5, 0.5, 0.5> }
        finish { ambient 0 brilliance 8 diffuse 0.15 specular 0.5 roughness 0.06 metallic reflection { 0.1, 0.5 fresnel on metallic } conserve_energy }
        normal
        {
                marble 0.0075 rotate <0, 0, 90> scale <1, 0.05, 1> 
        }
}  
texture // add some marks/small scratches
{
        pigment
        {
                granite
                scallop_wave
                turbulence 0.5
                omega 0.8
                colour_map
                {
                        [ 0.0 rgbt 1 ]
                        [ 0.075 rgbt 1 ]
                        [ 0.075 rgbt <0.3, 0.3, 0.3, 0.075> ]
                        [ 0.15 rgbt <0.3, 0.3, 0.3, 0.075> ]
                        [ 0.15 rgbt 1 ]
                        [ 0.2 rgbt 1 ]
                        [ 0.2 rgbt <0.2, 0.2, 0.2, 0.025> ]
                        [ 0.25 rgbt <0.2, 0.2, 0.2, 0.025> ]
                        [ 0.25 rgbt 1 ]
                        [ 1.0 rgbt 1 ]
                }
                scale 5
        }
        finish { ambient 0 diffuse 0.3 metallic brilliance 4 }        

} 
texture // add some marks/small scratches
{
        pigment
        {
                granite
                scallop_wave
                turbulence 0.75
                omega 0.8
                colour_map
                {
                        [ 0.0 rgbt 1 ]
                        [ 0.075 rgbt 1 ]
                        [ 0.075 rgbt <0.3, 0.3, 0.3, 0.075> ]
                        [ 0.15 rgbt <0.3, 0.3, 0.3, 0.075> ]
                        [ 0.15 rgbt 1 ]
                        [ 0.2 rgbt 1 ]
                        [ 0.2 rgbt <0.2, 0.2, 0.2, 0.025> ]
                        [ 0.25 rgbt <0.2, 0.2, 0.2, 0.025> ]
                        [ 0.25 rgbt 1 ]
                        [ 1.0 rgbt 1 ]
                }
                scale 15
        }
        finish { ambient 0 diffuse 0.3 metallic brilliance 4 }        

}   
texture // add some marks/small scratches
{
        pigment
        {
                granite
                scallop_wave
                turbulence 0.725
                omega 0.8
                colour_map
                {
                        [ 0.0 rgbt 1 ]
                        [ 0.075 rgbt 1 ]
                        [ 0.075 rgbt <0.3, 0.3, 0.3, 0.075> ]
                        [ 0.15 rgbt <0.3, 0.3, 0.3, 0.075> ]
                        [ 0.15 rgbt 1 ]
                        [ 0.2 rgbt 1 ]
                        [ 0.2 rgbt <0.2, 0.2, 0.2, 0.025> ]
                        [ 0.25 rgbt <0.2, 0.2, 0.2, 0.025> ]
                        [ 0.25 rgbt 1 ]
                        [ 1.0 rgbt 1 ]
                }
                scale 10                                              
                rotate <5,20,55>
        }
        finish { ambient 0 diffuse 0.3 metallic brilliance 4 }        
} 

#declare handleChrome = texture
{
        pigment { rgb <0.5, 0.5, 0.5> }
        finish { ambient 0 brilliance 4 diffuse 0.2 specular 0.5 roughness 0.08 reflection { 0.005, 0.08 fresnel on } conserve_energy }
        normal
        {
                dents 0.01 turbulence 0.005 rotate <0, 0, 90> scale <100, 0.025, 1> 
        }
}

#declare doorGlass = material
{
        texture
        {
                pigment { rgbt <0, 0, 0, 0.35> }
                finish { phong 1 ambient 0 diffuse 0 phong_size 100 reflection { 0.05, 0.6 fresnel on } conserve_energy }
        }                                                                                                               
        texture // add some marks/small scratches
        {
                pigment
                {
                        granite
                        scallop_wave
                        turbulence 0.5
                        omega 0.8
                        colour_map
                        {
                                [ 0.0 rgbt 1 ]
                                [ 0.075 rgbt 1 ]
                                [ 0.075 rgbt <0.3, 0.3, 0.3, 0.075> ]
                                [ 0.15 rgbt <0.3, 0.3, 0.3, 0.075> ]
                                [ 0.15 rgbt 1 ]
                                [ 0.2 rgbt 1 ]
                                [ 0.2 rgbt <0.2, 0.2, 0.2, 0.025> ]
                                [ 0.25 rgbt <0.2, 0.2, 0.2, 0.025> ]
                                [ 0.25 rgbt 1 ]
                                [ 1.0 rgbt 1 ]
                        }
                        scale 25
                }
                finish { ambient 0 phong 1 diffuse 0 phong_size 100 brilliance 4 reflection { 0.01, 0.2 fresnel on } conserve_energy }
        } 
        texture // add some marks/small scratches
        {
                pigment
                {
                        granite
                        scallop_wave
                        turbulence 0.65
                        omega 0.8
                        colour_map
                        {
                                [ 0.0 rgbt 1 ]
                                [ 0.075 rgbt 1 ]
                                [ 0.075 rgbt <0.3, 0.3, 0.3, 0.075> ]
                                [ 0.15 rgbt <0.3, 0.3, 0.3, 0.075> ]
                                [ 0.15 rgbt 1 ]
                                [ 0.2 rgbt 1 ]
                                [ 0.2 rgbt <0.2, 0.2, 0.2, 0.025> ]
                                [ 0.25 rgbt <0.2, 0.2, 0.2, 0.025> ]
                                [ 0.25 rgbt 1 ]
                                [ 1.0 rgbt 1 ]
                        }
                        scale 10
                }
                finish { ambient 0 phong 1 diffuse 0 phong_size 100 brilliance 4 reflection { 0.01, 0.2 fresnel on } conserve_energy }
        } 
        interior
        {
                ior 1.6
        }
}  

#declare cookerLightTex = material
{                               
        texture
        {
                pigment 
                { 
                        wood 
                        colour_map
                        {
                                [ 0.0 rgb <.1, 0.025, 0> ] 
                                [ 0.3 rgb <.1, 0.025, 0> ] 
                                [ 0.3 rgb <0.2, 0.05, 0> ] 
                                [ 0.7 rgb <0.2, 0.05, 0> ] 
                                [ 0.7 rgb <.1, 0.025, 0> ] 
                                [ 1.0 rgb <.1, 0.025, 0> ] 
                                
                        }  
                        rotate <90, 0, 0>
                        scale 0.05
                }                 
                finish { ambient 0 diffuse 0.8 brilliance 0.9 phong 0.9 phong_size 70 reflection 0.05 }
       }
       interior
       {
                ior 1.7
       }
                            
                

}

#declare cookerFoot = union
{
        object { Round_Cylinder_Union(<0, 0, 0>, <0, 0.1, 0>, 0.25, 0.02) }
        object { Round_Cylinder_Union(<0, 0, 0>, <0, 0.3, 0>, 0.15, 0.02) }
        object { Round_Cylinder_Union(<0, 0, 0>, <0, 0.6, 0>, 0.05, 0.02) }
        texture { blackPlastic }       
}  

// cooker knob 
#macro knob(nMarkings) 
union
{
        difference
        {
                sphere { <0, 0, 0> 0.25 scale <1, 0.6, 1> }
                box { <-0.3, -0.3, -0.3> <0.3, 0.035, 0.3> }  
                cylinder { <0, 0, 0> <0, 0.3, 0> 0.175 }
        }    
        //markings
        intersection
        {
                difference
                {
                        sphere { <0, 0, 0> 0.252 scale <1, 0.6, 1> }
                        box { <-0.3, -0.3, -0.3> <0.3, 0.035, 0.3> }  
                        cylinder { <0, 0, 0> <0, 0.3, 0> 0.175 }
                }  
                union
                {
                #declare mCount=0;       
                #declare mRotate=360/nMarkings;
                #while(mCount < nMarkings)
                        box { <-0.005, 0.06, -0.3> <0.005, 0.1, 0> rotate <0, mCount*mRotate, 0> }
                        #declare mCount=mCount+1;
                #end                             
                }
                texture 
                {                     
                        pigment { rgb 0.025 }
                        finish { ambient 0 diffuse 0.3 phong 0.5 phong_size 50 }
                }
                 
        }  
        // add some grime                

        blob 
        {
                threshold 0.6
                #declare gCount=0;
                #while(gCount < 100)
                        sphere { 0, 0.01+gr(0.01), 1 scale <1, 0.1+gr(0.2), 1+gr(2)> translate <-(0.24+gr(0.05)), 0.02+gr(0.02), 0> rotate <0, gr(360), 0> }
            
                #declare gCount=gCount+1;
        #end 
                texture 
                {
                        pigment 
                        {
                                wrinkles
                                sine_wave
                                turbulence 0.265
                                omega 0.7
                                lambda 4
                                colour_map
                                {
                                        [ 0.0 rgbt <0.1, 0.03, 0.000, 0.4> ]
                                        [ 0.2 rgbt <0.2, 0.13, 0.001, 0.75> ]
                                        [ 0.4 rgbt <0.1, 0.06, 0.002, 0.5> ]                                        
                                        [ 0.5 rgbt <0.3, 0.11, 0.003, 0.8> ]
                                        [ 0.8 rgbt <0.1, 0.08, 0.001, 0.6> ]                                        
                                        [ 1.0 rgbt <0.05, 0.01, 0.003, 0.4> ]                                        
                                } 
                                scale 0.05
                        }      
                        finish { ambient 0 diffuse 0.4 }
                        normal { wrinkles 1.5 scale 0.1 turbulence 0.15 }
                }
        }
        
        intersection
        {
                sphere { <0, 0, 0> 0.275 scale <1, 0.6, 1> }
                cylinder { <0, 0, 0> <0, 0.3, 0> 0.16 }
        }  
        Round_Box_Union(<-0.065, 0, -0.15>, <0.065, 0.25, 0.15>, 0.05)
        texture { handleChrome }
}  
#end

#declare cooker = union
{
 //       box { <0, 0, 0> <7, 10, 8> pigment { Blue } }
        // feet
        object { cookerFoot translate <0.3, 0.25, 0.5> }
        object { cookerFoot translate <6.7, 0.25, 0.5> }
        // base
        object { Round_Box_Union(<0, 0.5, 0.25>, <7, 1.2, 8>, 0.05) texture { blackPlastic } }    
        // sides
        object { Round_Box_Union(<0, 0.75, 0.2>, <0.2, 9, 8>, 0.05) texture { blackPlastic } }    
        object { Round_Box_Union(<6.8, 0.75, 0.2>, <7, 9, 8>, 0.05) texture { blackPlastic } }    
        // top
        object { Round_Box_Union(<0, 8.75, 0.2>, <7, 9.9, 8>, 0.05) texture { blackPlastic } }    
        // middle where doors meet
        object { Round_Box_Union(<0, 6, 0.2>, <7, 6.5, 8>, 0.05) texture { blackPlastic } }    
                
        // bottom door
        union
        {
          Round_Box_Union(<0, 0, 0>, <7, 1.5, 0.2>, 0.05)
          Round_Box_Union(<0, 4.5 0>, <7, 5.5, 0.2>, 0.05)
          Round_Box_Union(<0, 0, 0>, <1, 5.5, 0.2>, 0.05)
          Round_Box_Union(<6, 0, 0>, <7, 5.5, 0.2>, 0.05)
          // glass
          box { <0.5, 0.5, 0.1> <6.5, 5, 0.125> material { doorGlass }  }   
          
          // handle
          union
          {
                cylinder { <-2.5, 0, 0> <2.5 0, 0> 0.15 }
                intersection
                {
                        torus { 0.5, 0.15 }
                        box { <-1, -0.3, -1> <0, 0.3, 0> }
                        translate <-2.5, 0, 0.5>
                }                                
                intersection
                {
                        torus { 0.5, 0.15 }
                        box { <0, -0.3, -1> <1, 0.3, 0> }
                        translate <2.5, 0, 0.5>
                }                                
                translate <3.5, 5.25, -0.2>   
                texture { handleChrome }
          }
          
          texture { brushedChrome }    
          translate <0, 0.75, 0>
                
        }    
     
        // top door
        union
        {
          Round_Box_Union(<0, 0, 0>, <7, 1, 0.2>, 0.05)
          Round_Box_Union(<0, 2.5 0>, <7, 3.5, 0.2>, 0.05)
          Round_Box_Union(<0, 0, 0>, <1, 3.5, 0.2>, 0.05)
          Round_Box_Union(<6, 0, 0>, <7, 3.5, 0.2>, 0.05)
          
          // glass
          box { <0.5, 0.5, 0.1> <6.5, 3, 0.125> material { doorGlass }  }

          // handle
          union
          {
                cylinder { <-2.5, 0, 0> <2.5 0, 0> 0.15 }
                intersection
                {
                        torus { 0.5, 0.15 }
                        box { <-1, -0.3, -1> <0, 0.3, 0> }
                        translate <-2.5, 0, 0.5>
                }                                
                intersection
                {
                        torus { 0.5, 0.15 }
                        box { <0, -0.3, -1> <1, 0.3, 0> }
                        translate <2.5, 0, 0.5>
                }                                
                translate <3.5, 3.25, -0.2>   
                texture { handleChrome }
          }

          texture { brushedChrome }    
          translate <0, 6.35, 0>
                
        }  
        
        // controls
        union
        {
                difference
                {
                        object { Round_Box_Union(<0, 0, 0>, <7, 0.6, 8>, 0.15) }
                        box { <0.15, 0.4, 1.4> <6.85,0.7, 7.5> }    
                        object { Round_Box_Union(<0.2, 0, 0>, <6.8, 1, 1>, 0.2) rotate <-25, 0, 0> translate <0, 0.15, 0.1> } 
                        object { Round_Box_Union(<2.5, 0, 0.1>, <4.5, 1, 0.9>, 0.1) rotate <-25, 0, 0> translate <0, 0.1, 0.1> }
                        // light holes
                        cylinder { <0, 0, 0> <0, 1, 0> 0.05 translate <2.4, 0, 0.45> rotate <-25, 0, 0> }
                        cylinder { <0, 0, 0> <0, 1, 0> 0.05 translate <4.6, 0, 0.45> rotate <-25, 0, 0> }
                        texture { brushedChrome }
                }
                // LED glass
                union
                {
                        object { Round_Box_Union(<2.5, 0, 0.1>, <4.5, 0.1, 0.9>, 0.1) }  
                        // symbols on glass
                        union
                        {      
                                // symbols above buttons
                                union  // Plus on right hand side
                                {
                                        box { <-0.01, 0, -0.05> <0.01, 0.001, 0.05> }
                                        box { <-0.05, 0, -0.01> <0.05, 0.001, 0.01> }
                                        translate <4.15, 0.1, 0.35>   
                                }  
                                difference  // O in middle
                                {
                                        cylinder { <0, 0, 0> <0, 0.001, 0> 0.05 }
                                        cylinder { <0, -0.001, 0> <0, 0.002, 0> 0.04 }
                                        translate <3.5, 0.1, 0.35>   
                                }     
                                union  // Minus on left hand side
                                {
                                        box { <-0.05, 0, -0.01> <0.05, 0.001, 0.01> }
                                        translate <2.85, 0.1, 0.35>   
                                }     
                                // clock face symbol
                                union
                                {
                                        difference  // O in middle
                                        {
                                                cylinder { <0, 0, 0> <0, 0.001, 0> 0.06 }
                                                cylinder { <0, -0.001, 0> <0, 0.002, 0> 0.05 }
                                        }
                                        box { <0, 0, -0.01> <0.03, 0.001, 0.01> }
                                        box { <-0.01, 0, 0> <0.01, 0.001, 0.04> }

                                        translate <4.25, 0.1, 0.65>   
                                }     
                                // Arrow symbol
                                union
                                {
                                        box { <-0.05, 0, -0.05> <-0.03, 0.001, 0.05> }
                                        box { <0.0, 0, -0.035> <0.02, 0.001, 0.035> }
                                        box { <-0.05, 0, -0.01> <0.06, 0.001, 0.01> }  
                                        box { <-0.02, 0, 0.0> <0.0, 0.001, 0.045> rotate <0, -45, 0> translate <0.06, 0, 0> }
                                        box { <-0.02, 0, -0.045> <0.0, 0.001, 0.0> rotate <0, 45, 0> translate <0.06, 0, 0> }                                        
            
                                        translate <2.75, 0.1, 0.65>  
                                }
                                
                                
                                
                                texture
                                {
                                        pigment { rgb 1 }
                                        finish { phong 1 phong_size 100 brilliance 0.5 ambient 0 diffuse 1 }
                                }                              
                        }
                        rotate <-25, 0, 0> translate <0, 0.1, 0.1> 
                        material { doorGlass } 
                }
                // power lights
                object { Round_Cylinder_Union(<0, 0, 0>, <0, 0.125, 0>, 0.075, 0.01) material { cookerLightTex } translate <2.4, 0, 0.5> rotate <-25, 0, 0> }
                object { Round_Cylinder_Union(<0, 0, 0>, <0, 0.125, 0>, 0.075, 0.01) material { cookerLightTex } translate <4.6, 0, 0.5> rotate <-25, 0, 0> }
                
                // small buttons on LED screen
                union
                {
                        object { Round_Cylinder_Union(<0, 0, 0>, <0, 0.05, 0>, 0.05, 0.015) translate <0, 0.1, 0> }
                        cylinder { <0, 0,0 > <0, 0.1, 0> 0.025 }
                        texture { handleChrome }
                        translate <2.85, 0.1, 0.35> rotate <-25, 0, 0> 
                }   
                union
                {
                        object { Round_Cylinder_Union(<0, 0, 0>, <0, 0.05, 0>, 0.05, 0.015) translate <0, 0.1, 0> }
                        cylinder { <0, 0,0 > <0, 0.1, 0> 0.025 }
                        texture { handleChrome }
                        translate <3.5, 0.1, 0.35> rotate <-25, 0, 0> 
                }   
                union
                {
                        object { Round_Cylinder_Union(<0, 0, 0>, <0, 0.05, 0>, 0.05, 0.015) translate <0, 0.1, 0> }
                        cylinder { <0, 0,0 > <0, 0.1, 0> 0.025 }
                        texture { handleChrome }
                        translate <4.15, 0.1, 0.35> rotate <-25, 0, 0> 
                }   



                box { <0.15, 0.4, 1.4> <6.85,0.5, 7.5> material { doorGlass } }    
 
                object { knob(8) rotate <-25, 0, 0> translate <0.7, 0.365, 0.6125>  }
                object { knob(5) rotate <-25, 0, 0> translate <1.4, 0.365, 0.6125>  }
                object { knob(14) rotate <-25, 0, 0> translate <2.1, 0.365, 0.6125>  }


                object { knob(14) rotate <-25, 0, 0> translate <6.3, 0.365, 0.6125>  }
                object { knob(5) rotate <-25, 0, 0> translate <5.6, 0.365, 0.6125>  }
                object { knob(8) rotate <-25, 0, 0> translate <4.9, 0.365, 0.6125>  }
                translate <0, 9.9, 0>
        }
}

#declare plinthTex = texture { cupboardWoodTex } 
texture
{
        pigment
        {
                gradient y  
                omega 0.725
                lambda 3
                turbulence 0.05
                colour_map      
                {
                        [ 0.0 rgbt <0.025, 0.01, 0, 0.2> ]
                        [ 0.1 rgbt <0.035, 0.05, 0, 0.3> ]
                        [ 0.3 rgbt <0.125, 0.085, 0.02, 0.8> ]
                        [ 0.35 rgbt <0.15, 0.09, 0.04, 1> ]
                        [ 0.35 rgbt <1, 1, 1, 1> ]
                        [ 1.0 rgbt <1, 1, 1, 1> ]                                
                }       
                scale <100, 2, 100>
                translate <0, -0.05, 0>                 
        }        
        finish 
        {
                ambient 0 diffuse 0.5 
        }   
        normal { wrinkles 0.25 turbulence 0.25 scale <100, 0.01, 0.05> rotate <0, 1, 0>  }

}

//  back cupboards.

union
{        
        // worktop
        intersection
        {         
                object { Round_Box_Union(<-22, 9.75, 18.75>, <-3.5, 10.5, 26>, 0.095) }
                box { <-14.8, 10, 18.65> <-3.8, 10.55, 26> }
                texture { worktopTex } 
        } 
        box { <-22, 0.15, 19.5> <-3.825, 1, 20> texture { plinthTex } } // plinth 

        intersection
        {         
                object { Round_Box_Union(<3.15, 9.75, 18.75>, <26, 10.5, 26>, 0.095) } // worktop
                box { <3.35, 10, 18.55> <26, 10.65, 26> texture { worktopTex } } // worktop
       
                texture { worktopTex } 
        } 
        box { <3.35, 0.15, 19.5> <26, 1, 20> texture { plinthTex  rotate <0, 0, 0> }} // plinth 

//        box { <-22, 1, 19> <26, 8, 26> } // cupboards   
  

        object { mkCornerCupboard() translate <-15, 0, 19> }     
        object { mkCupboard() translate <-10.675, 0, 19> }     
        object { cooker translate <-3.75, 0, 19> }     
        object { mkDrawers() translate <3.35, 0, 19> }     
        object { mkCupboard() translate <8.3, 0, 19> }     
        object { mkCupboard() translate <15.3, 0, 19> }     
        
        // cooker
        
        
        texture { testTex }
}


//  left cupboards.

union
{
        box { <-16, 0.15, -30> <-15.5, 1, 20> texture { plinthTex  rotate <0, 90, 0> }} // plinth 
//        box { <-22, 1, -30> <-15, 10, 20> } // cupboards   
        intersection
        {         
                object { Round_Box_Union(<-22, 9.75, -30>, <-14.75, 10.5, 20>, 0.095) } // worktop
                box { <-22, 10, -30> <-14.65, 10.65, 20> } // worktop
       
                texture { worktopTex rotate <0, 90, 0> } 
        } 


        object { mkDrawers() rotate <0, -90, 0> translate <-15, 0, 9.5> }     
        object { mkCupboard() rotate <0, -90, 0> translate <-15, 0, 2.5> }     
        object { mkCupboard() rotate <0, -90, 0> translate <-15, 0, -4.5> }     
        
        
        texture { testTex }
}

#declare hairRand = seed(1245);   

// Macro to return a random number

#macro hr(num)
        rand(hairRand)*num
#end

#declare pen = union
{       
        // pen
        union
        {
        
                cylinder { <-1.6, 0, 0> <1.75, 0, 0> 0.2 }
                cone { <-2.15, 0, 0> 0.075 <-1.6, 0, 0> 0.2 }
                torus { 0.04, 0.035 rotate <0, 0, -90> translate <-2.15, 0, 0> }    
                // nib
                union
                {
                        cylinder { <-2.35, 0, 0> <-2, 0, 0> 0.06 }
                        sphere { <-2.35, 0, 0> 0.05 }
                        texture
                        {
                                pigment { rgb <0.25, 0.15 0.025> }
                                finish { specular 0.8 roughness 0.02 brilliance 4 metallic reflection 0.1 }
                        }
                }
                texture
                {
                        pigment
                        {
                                rgb <0.6, 0.125, 0.2> 
                        }  
 
                }
                texture
                {
                        pigment
                        {
                                wrinkles
                                cubic_wave
                                turbulence 0.2
                                colour_map
                                {
                                        [ 0.0 rgbt 1 ]
                                        [ 0.4 rgbt 1 ]
                                        [ 0.4 rgbt <0.55, 0.125, 0.25, 0> ]
                                        [ 0.7 rgbt <0.55, 0.125, 0.25, 0> ]
                                        [ 0.7 rgbt 1 ]
                                        [ 1.0 rgbt 1 ]                                       
                                }  
                                scale 0.05  
                        }
                        finish { specular 2 roughness 0.01 reflection 0.1 brilliance 2 ambient 0 diffuse 0.7 }
                        normal { wrinkles 1 cubic_wave turbulence 0.2 scale 0.05 }
                }
        }
        // add hair to pen
        union
        {
                #declare hR= -100;
                #while(hR < 100)  
                        #declare hL=0+hr(0.05);
                        #while(hL < 2)
                                object { hair scale <0.7+hr(0.5),1+hr(1),0.7+hr(0.5)> rotate <0, hr(360), hr(-40)> rotate <hr(10), 0, 0>
                                         translate <hL+hr(0.1), 0.2, 0> rotate <hR+hr(2), 0, 0> }//rotate <0, mr(360), 0> Reorient_Trans(-fallDirection,N) translate S } 
                                #declare hL=hL+hr(0.15)+0.2;
                        #end
                        #declare hR=hR+5+hr(3);
                #end
                texture
                {
                        pigment
                        {
                                        rgb <0.55, 0.15, 0.25>
                        }
                        finish { ambient 0 diffuse 0.7 brilliance 0.95 }
                }
        }
        // add silver hair bit to hpen
        union
        {
                #declare hR= -90;
                #while(hR < 90)  
                        #declare hL=0+hr(0.05);
                        #while(hL < 2)
                                object { hair scale <1+hr(0.2),1.85+hr(1.25),1+hr(0.2)> rotate <0, hr(360), hr(-40)> rotate <hr(10), 0, 0>
                                         translate <hL+hr(0.2), 0.2, 0> rotate <hR+hr(2), 0, 0> }//rotate <0, mr(360), 0> Reorient_Trans(-fallDirection,N) translate S } 
                                #declare hL=hL+hr(0.2)+0.3;
                        #end
                        #declare hR=hR+25+hr(15);
                #end
                texture
                {
                        pigment
                        {
                                        rgb 0.25
                        }
                        finish { specular 2 roughness 0.02 reflection 0.8 brilliance 4 metallic ambient 0 diffuse 0.15 }
                }
        }   
}


// basket

union
{
        difference
        {
                union
                {
                        cone { <0, 0, 0> 3 <0, 2, 0> 3.5 }
                }
                union
                {
                        box { <-0.95, 0.2, -5> <0.95, 2.5, 0> }
                        cone { <0, 0.2, 0> 2.8 <0, 2.01, 0> 3.3 }
                }
                
        }
        // rim
        difference
        {
                torus { 3.5, 0.2 translate <0, 2, 0> }
                box { <-0.95, 0.2, -5> <0.95, 2.5, 0> }
                
        }   
        // cushion
        union
        {           
                
                #declare fluffIter=0;
                #while(fluffIter < 6)
                #declare cFluff=0;
                
                blob
                {
                        threshold 0.6
                        
                #while(cFluff < 1000)        //0.05                        //1+                                  //87
                        sphere { 0, 0.05+gr(0.1), 1 scale <1+gr(1), 1.5+gr(1), 1+gr(1)> translate <0, 2.95, 0> rotate <gr(81), gr(360), 0> } 
                        #declare cFluff=cFluff+1;
                #end
                }
                #declare fluffIter=fluffIter+1;
                #end

                sphere { <0, 0, 0> 2.85 }
                scale <1, 0.3, 1> translate <0, 0.25, 0>   
                texture
                {
                        pigment 
                        { 
                                wrinkles
                                colour_map
                                {
                                        [ 0.0 rgb <0.7, 0.6, 0.5> ]
                                        [ 0.2 rgb <0.7, 0.6, 0.5> ]
                                        [ 1.0 rgb <0.4, 0.2, 0.1> ]
                                }                                  
                                scale 0.1
                        }
                        finish { ambient 0 diffuse 0.7 }
                        normal { wrinkles 0.5 scale 0.025 }                        
                } 
        } 
        
        // add the pen
        object { pen translate <0, 0.2, 0> scale 0.3 rotate <0, 0, 2> rotate <0, -25, 0> translate <-0.75, 1.125, 0.35> }  
        
        texture 
        { 
                pigment { rgb <0.4, 0.1, 0.025> }     
                finish { phong 0.25 phong_size 15 brilliance 0.975 ambient 0 diffuse 0.65 }
                normal { leopard 1.5 scale 0.01 }
        }  
        texture
        {
                pigment
                {
                        granite
                        turbulence 0.5
                        omega 0.75
                        colour_map
                        {
                                [ 0.0 rgbt <0.1, 0.025, 0.0, 0.5> ]
                                [ 0.6 rgbt <0.1, 0.025, 0.0, 1> ]
                                [ 0.6 rgbt <1, 1, 1, 1> ]
                                [ 1.0 rgbt <1, 1, 1, 1> ]
                        }  
                        scale 0.25
                }
                finish { phong 0.1 phong_size 10 brilliance 1 ambient 0 diffuse 0.55 }
                normal { leopard 1.5 scale 0.01 }
        }
        texture
        {
                pigment
                {
                        gradient  y
                        turbulence 0.05
                        omega 0.7
                        colour_map
                        {
                                [ 0.0 rgbt <0.1, 0.025, 0.0, 0.1> ]
                                [ 0.2 rgbt <0.1, 0.025, 0.0, 1> ]
                                [ 0.2 rgbt <1, 1, 1, 1> ]
                                [ 1.0 rgbt <1, 1, 1, 1> ]
                        }  
                        scale 10 translate <0, -0.5, 0>
                }
                finish { phong 0.1 phong_size 10 brilliance 1 ambient 0 diffuse 0.55 }
                normal { leopard 1.5 scale 0.01 }
        }
        rotate <0, -30, 0>     
        translate <-10, 0.1, 12.5>
}                                                       


// toys

// ping-pong ball
sphere { <0, 0, 0> 0.3 
texture
{
        pigment 
        { 
                spiral1 3     
                turbulence 1
                colour_map
                {
                        [ 0.0 rgb <0.1, 0.7, 0.1> ]
                        [ 0.2 rgb <0.02, 0.1, 0.7> ]
                        [ 0.4 rgb <.6, .6, 0> ]
                        [ 0.6 rgb <0.8, 0.2, 0.2> ]
                        [ 0.8 rgb <.5, 0, .5> ]                       
                        [ 1.0 rgb <0.1, 0.6, .6> ]                       
                }
        }
}
translate <-14, 0.3, 8> 
}    

// mouse on string
union 
{

        blob {
          // threshold (0.0 < threshold <= StrengthVal) surface falloff threshold #
          threshold 0.6
          sphere { <0, 0, 0>, 1, 1 }
          cylinder { <0, 0, 0>, <0.8, 0, 0>, 1, 1 }
          #declare np=0;    
          #declare ns=0.5;
          #while(np < 1.0)
                sphere { <0.8+np, 0-(np*0.3), 0>, ns, 1 }
                #declare np=np+0.1;
                #declare ns=ns-0.02;
          #end    
          // ears
          sphere { <0, 0, 0>, 0.2, 1 scale <0.3, 1, 0.7> translate <1, 0.4, -0.3>}
          sphere { <0, 0, 0>, 0.2, 1 scale <0.3, 1, 0.7> translate <1, 0.4, 0.3>}
          
          // [sturm]
         
        } 
        // eyes
        union
        {
                sphere { <1.4, 0.1, -0.18> 0.05 } 
                sphere { <1.4, 0.1, 0.18> 0.05 }   
        
        // whiskas  
                object { whiska rotate <15, -20, 0> translate <1.7, -0.2, -0.05> }
                object { whiska rotate <5, 5, 50> translate <1.75, -0.225, -0.05> }
                object { whiska rotate <-10, -8, -90> translate <1.725, -0.25, -0.05> }
        
                object { whiska rotate <165, -20, 0> translate <1.7, -0.2, 0.05> }
                object { whiska rotate <190, 5, 50> translate <1.75, -0.225, 0.05> }
                object { whiska rotate <200, -8, -90> translate <1.725, -0.25, 0.05> }     
                texture { blackPlastic }
        }        
        // tail
        sphere_sweep 
        {
                //linear_spline                 // linear curve
                cubic_spline                // alternative spline curves
                //b_spline
                6,                            // number of specified sphere positions
                <0, 0, 0>, .05                // position, radius
                <-1, 0.2, -0.2>, .25                 // ...
                < -2, -0.05, 0.1>, .23
                < -3, 0.02, 0.2>, .21   
                < -4, 0.2, -0.075>, .19   
                < -5, 0.5, -0.15>, .17   
                
                tolerance 0.01  
                bounded_by { box { <-6, -1, -1> <1, 1, 1> } }   
                scale <0.65, 0.4, 0.65>
                translate <0, 0, 0>     
        } 

        
        texture 
        {
                pigment 
                {
                        gradient x
                        turbulence 0.01
                        colour_map
                        {
                                [ 0.0 rgb <0.9, 0.9, 0.85> ]
                                [ 0.5 rgb <0.9, 0.9, 0.85> ]
                                [ 0.5 rgb <0.01, 0.25, 0.05> ]
                                [ 1 rgb <0.01, 0.25, 0.05> ]                                
                        }  
                        scale 0.8
                }    
                finish { ambient 0 diffuse 0.55 }
                normal { wrinkles 1 scale 0.1 }
        }   
        texture
        {
                pigment
                {
                        wrinkles
                        turbulence 0.35
                        omega 0.75
                        colour_map
                        {
                                [ 0.0 rgbt <0.05, 0.0125, 0.0, 0.1> ]
                                [ 1.0 rgbt <0.1, 0.025, 0.0, 1> ]
                        }  
                        scale 0.15
                }               
                finish { ambient 0 diffuse 0.55 }
                normal { wrinkles 1 scale 0.1 }
        }        
        scale 0.6
        rotate <0.2, -0.2, 0>    
        
        translate <-8, 0.4, 8>      

}  

// page

  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -1.937402, 0.000000>, <0.000000, -1.874804, 0.000000>, <1.000000, -2.000000, 0.000000>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -0.937402, 0.000000>, <0.000000, -1.000000, 0.000000>, <1.000000, -1.125196, -0.125196>, 
      <-1.937402, 0.000000, 0.000000>, <-0.749609, -0.250391, 0.000000>, <0.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 1.000000, -0.062598>, <-0.187793, 1.000000, 0.187793>, <1.000000, 1.000000, -0.062598>
    } 
     texture { pigment { image_map { jpeg "chilli.jpg"  } scale <3, 3, 1> translate <-2, -2, 0> } 
                normal 
                { 
                        average
                        normal_map
                        {
                                [ 1 wrinkles 0.3 scale 0.3 ]
                                [ 1 quilted 0.5 scale 3 rotate <0, 0, 45> turbulence 0.2 ]
                                [ 1 quilted 0.5 scale 3 rotate <0, 0, -40> turbulence 0.2 ]
                                
                        }
                }
                finish { ambient 0 diffuse 0.6 phong 0.1 phong_size 10 }
     } 
     texture 
     { 
        pigment 
        { 
                wrinkles
                   
                omega 0.675
                lambda 3
                turbulence 0.6
                colour_map 
                {
                        [ 0.0 rgbt <0.1, 0.05, 0, 1> ]
                        [ 0.4 rgbt <0.1, 0.05, 0, 0.9> ]
                        [ 0.5 rgbt <0.1, 0.05, 0, 1> ]
                        [ 0.7 rgbt <0.1, 0.05, 0, 1> ]
                        [ 0.8 rgbt <0.1, 0.05, 0, 0.6> ]
                        [ 1.0 rgbt <0.1, 0.05, 0, 1> ]
                }     
                scale 1.5
        }
        normal 
        { 
                average
                normal_map
                {
                        [ 1 wrinkles 0.3 scale 0.3 ]
                        [ 1 quilted 0.5 scale 3 rotate <0, 0, 45> turbulence 0.2 ]
                        [ 1 quilted 0.5 scale 3 rotate <0, 0, -40> turbulence 0.2 ]
                        
                }
        }
        finish { ambient 0 diffuse 0.5 phong 0.01 phong_size 5 }
    }         
     texture 
     { 
        pigment 
        { 
                wrinkles
                cubic_wave   
                omega 0.675
                lambda 3
                turbulence 0.55
                colour_map 
                {
                        [ 0.0 rgbt <0.03, 0.02, 0, 1> ]
                        [ 0.2 rgbt <0.03, 0.02, 0, 0.7> ]
                        [ 0.3 rgbt <0.03, 0.02, 0, 1> ]
                        [ 0.8 rgbt <0.03, 0.02, 0, 1> ]
                        [ 0.9 rgbt <0.03, 0.02, 0, 0.9> ]
                        [ 1.0 rgbt <0.03, 0.02, 0, 1> ]
                }     
                scale 0.5
        }
        normal 
        { 
                average
                normal_map
                {
                        [ 1 wrinkles 0.3 scale 0.3 ]
                        [ 1 quilted 0.5 scale 3 rotate <0, 0, 45> turbulence 0.2 ]
                        [ 1 quilted 0.5 scale 3 rotate <0, 0, -40> turbulence 0.2 ]
                        
                }
        }
        finish { ambient 0 diffuse 0.5 phong 0.01 phong_size 5 }
    }         
     scale <1, 1.25, 1>
     rotate <90, 18, 0>  
     translate <-3, 0.095, 2.25>
    }
    
    
// Kettle
   union
   {
        // base
        object { Round_Cylinder_Union(<0, 0, 0>, <0, 0.2, 0>, 1.5, 0.05) texture { blackPlastic } }
        // kettle bottom
        object { Round_Cylinder_Union(<0, 0.2, 0>, <0, 0.3, 0>, 1.5, 0.025) texture { blackPlastic } }
        union
        {
                difference
                {
                        sphere { <0, 0, 0> 1.45 }
                        box { <-1.6, -1.6, -1.6> <1.6, 0, 1.6> }
                        translate <0, 0.7, 0>
                }  
                cylinder { <0, 0.3, 0> <0, 0.7, 0> 1.45 }
                texture 
                { 
                        pigment { rgb 0.3 }
                        finish { specular 1 roughness 0.001 ambient 0 diffuse 0.15 brilliance 10 reflection { 0.7, 1 fresnel on metallic } conserve_energy }
                }  
                
        }
        translate <-19, 10.501, 14.25>
         
   }        

// add paw prints
#macro pawPrint(xp,yp,zp,yr,sc)
box { <0, 0, 0> <1, 1, 0.01>       
  no_shadow
  texture
  {
        pigment { image_map { gif "pawprint.gif" once transmit all 0.3+gr(0.3) transmit 255, 1 } turbulence 0+gr(0.1) omega 0.6+gr(0.2) lambda 3+gr(2) }//filter 255,1 } }
        normal { granite 2 scale 0.15 }
        finish { ambient 0 diffuse 0.3 }
  }
  translate <-0.5, -0.5, 0>    
  scale 0.75
  scale sc
  rotate <90, yr, 0>       
  translate <xp,yp,zp>
}
#end

union
{
        object { pawPrint(-7.2, 0.1, 9.85, -50, <-1,1,1>) }

        object { pawPrint(-6.8, 0.1, 8.35, -51, <1,1,1>) }

        object { pawPrint(-4.9, 0.1, 8.5, -52, <-1,1,1>) }

        object { pawPrint(-4.2, 0.1, 6.8, -51, <1,1,1>) }

        object { pawPrint(-2.4, 0.1, 6.8, -54, <-1,1,1>) }

        object { pawPrint(-1.8, 0.1, 5.2, -51, <1,1,1>) }

        object { pawPrint(-0.4, 0.1, 5.3, -50, <-1,1,1>) }

        object { pawPrint(-0.1, 0.1, 3.9, -50, <1,1,1>) }

        object { pawPrint(1.4, 0.1, 3.8, -49, <-1,1,1>) }

        object { pawPrint(1.2, 0.1, 1.8, -48, <1,1,1>) }

        object { pawPrint(2.8, 0.1, 1.6, -47, <-1,1,1>) }

        
        #declare pRad=15;
        #declare pRot=8;
        #declare pCurrRot=0;
        #while(pCurrRot < 90)
        
                object { pawPrint(0, 0.1, 0, 90, <1,1,1>) translate <0, 0, pRad+gr(0.1)> rotate <0, pCurrRot+gr(1),0> translate <-7,0,10-pRad> }
                object { pawPrint(0, 0.1, 0, 90, <-1,1,1>) translate <0, 0, pRad+gr(0.1)> rotate <0, pCurrRot+gr(1),0> translate <-6,0,10.7-pRad> }
                #declare pCurrRot=pCurrRot+pRot;
        #end
        
}
