#include "textures.inc"
#include "colors.inc"
#include "woods.inc"
#include "stones2.inc"

light_source {
	<18, 30, -15>
		color White
		area_light <2, 0, 0>, <0, 0, 2>, 6, 6
		adaptive 1
		jitter
}



camera {
	location <30, 30, -25>
		look_at <0, 0, 20>
}

sky_sphere {
	pigment{White}
}


#declare Puzzle =
difference{
	union{
		intersection {
			height_field {gif "heightmapneg.gif" smooth}
			box{<0.000001,-.5,0.000001><.99999,.99999,.99999>}
			finish {ambient .2 roughness  .2 specular .6}
			pigment {image_map {png "starswhole.png"} rotate <90,-90,0>}
		}
		box {<0,0,0><1,2,1> translate <0,-2,0> pigment{Brown}}
	}
	intersection {
		height_field{gif "piececut.gif"}
		box{<0,.1,0><.99999,.99999,.99999>}
		scale <1,10,1>
			translate <0,-5,0>
	}
}

#declare BWidth=16;
#declare BHeight=10;
#declare BDepth=-2;

#declare PuzzleLid = union{
	box{<0,0,0><1,1,1> //front
			pigment{image_map {png "boxfront.png"} 
				rotate <0,180,0>} 
		scale<BWidth,BHeight,.1>
			normal {bump_map {gif "canvas" bump_size .15} scale 5}}
	
	box{<0,BHeight,0><BWidth,BHeight-.1,BDepth> //top
			pigment{image_map {png "boxlongside.png"} 
				rotate <-90,0,0> 
					scale <BWidth,BHeight,BDepth>}
		normal {bump_map {gif "canvas" bump_size .15} 	
			scale 5 rotate <90,0,0>}}
	
	box{<0,0,0><.1,BHeight-.1,BDepth> //rightside
			pigment{image_map {png "boxshortside.png"} 
				rotate <0,90,0>
					rotate <-90,0,180>
					scale <1,BHeight-.1,BDepth>} 
		normal {bump_map {gif "canvas" bump_size .15} 	
			scale 5 rotate <0,90,0>}}
	
	box{<BWidth-.1,0,0><BWidth,BHeight-.1,BDepth> //leftside
			pigment{image_map {png "boxshortside.png"} 
				rotate <0,0,0> 
					scale <1,BHeight,BDepth>}
		normal {bump_map {gif "canvas" bump_size .1} 	
			scale 5 rotate <0,0,90>}}
	
	box{<0,0,0><BWidth,.1,BDepth> //bottom
			pigment{image_map {png "boxlongside.png"} 
				rotate <90,0,0> 
					scale <BWidth,BHeight,BDepth>} }
}

#declare PuzzleBase = difference{
	box{<.1,.1,.1><BWidth-.1,BHeight-.1,BDepth>}
	box{<.2,.2,.2><BWidth-.2,BHeight-.2,BDepth+.5>}
	pigment {DarkBrown}
	normal {granite 1}
}

#declare PuzzleBox=union{
	object{PuzzleLid
			finish {ambient .5 roughness  .1 specular .3}
	}
	object{PuzzleBase
			rotate <-90,0,0>
			translate <0,-BDepth,0>
			normal{granite scale 5}
	}
}
object{PuzzleBox rotate<0,170,0> translate<23,0,23.5>}
object{Puzzle scale <27,.05,20> translate <0,.1,0>}
plane {y, 0 pigment {White} finish {ambient .3}}