// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.6
// Desc: IRTC competition - October 2006 - Topic is Absence
// Date: 09/21/2006
// Auth: ?
//

#version 3.6;

#include "colors.inc"
#include "textures.inc"
#include "glass.inc"
#include "metals.inc"
#include "golds.inc"
#include "stones.inc"
#include "woods.inc"


global_settings { assumed_gamma 1.0 }

#default {
	texture {
		pigment {rgb 1}
		finish	{
			ambient 0.2
			diffuse 0.9
			specular 0.9
			}
		}
	}

// ----------------------------------------

#declare camera_01 =
	camera {
		right x*image_width/image_height
		location  <12,10,-40>
		look_at   <12,10,0>
		}
	;
	
#declare camera_02 =
	camera {
		right x*image_width/image_height
		location  <4,80,-30>
		look_at   <10,0,8>
		direction z*1.5
		}
	;

#declare camera_03 =
	camera {
		right x*image_width/image_height
		location  <4,80,-30>
		look_at   <10,0,8>
		direction z*1.5
		aperture 2
		blur_samples 100
		focal_point <0,15,0>
		confidence 1
		variance 1/200
		}
	;

camera{camera_03}


#declare light_01 =
	light_source {
		<-65,78,-40>
		color rgb <1, 1, 1>
		}
	;

#declare light_02 =
	light_source {
		0*x                 // light's position (translated below)
		color rgb 1.0       // light's color
		area_light
		<2, 0, 0> <0, 0, 2> // lights spread out across this distance (x * z)
		8, 8                // total number of lights in grid (4x*4z = 16 lights)
		adaptive 3          // 0,1,2,3...
		circular            // make the shape of the light circular
		orient              // orient light
		translate <-65,78,-40>   // <x y z> position of light
		}
	;

light_source { light_02 }
         
// ----------------------------------------

plane { y, 0 
	texture	{ 
		finish {
			ambient 0.4
			diffuse 0.8
			}
		}  
	}

plane{<0,1,0>,1 hollow  
       texture{ pigment{ bozo turbulence 0.76
                         color_map { [0.5 rgb <0.20, 0.20, 1.0>]
                                     [0.6 rgb <1,1,1>]
                                     [1.0 rgb <0.5,0.5,0.5>]}
                       }
                finish {ambient 1 diffuse 0} }      
       scale 10000}




#declare dist = 0.2;
#declare r_bareau = 0.08;

union	{
	union	{	// socle
		difference {
			cylinder { <0,0,0>,<0,5,0>, 12 }
			cylinder { <0,0+dist,0>,<0,5+dist,0>, 12-dist }
			}
		torus { 12, dist translate y*5}
		#declare f_color = 0.6;
		texture	{ 
			pigment { color rgb <0.94*f_color, 0.93*f_color, 0.80*f_color> } 
			finish {
				brilliance 2
				metallic
				specular 0.80
				roughness 1/20
				reflection 0.1
				}
			}  
		}
	union {
		difference {
			union {	// bareau
				#declare n_bareau = 64;
				#declare myCount = 0;
				#while (myCount < 360)
					union {
						intersection {
							torus { 12-dist, r_bareau 
								rotate x*90
								scale y*0.5
								translate y*23}
							box { <13, 30, -1>, <0, 23, 1> }
							}
					        cylinder { <12-dist, 4.5, 0>, <12-dist, 23, 0>, r_bareau }
						rotate y*myCount
				  		}
					#declare myCount = myCount+(360/n_bareau);
				#end
			        torus { 12, r_bareau translate y*20}
			        torus { 12, r_bareau translate y*7}
				}
			#declare n_bareau_porte = 8;
			difference {
				box {<0+(r_bareau*2), 9, 0> < 13,  18,  -13> }
				box {<0-(r_bareau*2), 8, 3> < 13,  19,  -20> rotate y*(360/n_bareau)*-n_bareau_porte}
				} 
		        } 
		intersection {
		        union	{
			        torus { 12, r_bareau translate y*18} 
			        torus { 12, r_bareau translate y*9} 
		        	}
			difference {
				box {<0-r_bareau, 9-(r_bareau*2), 0> < 13,  18+(r_bareau*2),  -13> }
				box {<0+r_bareau, 8, 3> < 13,  19,  -20> rotate y*(360/n_bareau)*-n_bareau_porte}
				} 
		        }  
		
		// porte
		
		union	{
			intersection {
			        union	{
				        torus { 12, r_bareau translate y*18-(r_bareau*3)} 
				        torus { 12, r_bareau translate y*9+(r_bareau*3)} 
			        	}
				difference {
					box {<0, 9-(r_bareau*2), 0> < 13,  18+(r_bareau*2),  -13> }
					box {<0+r_bareau, 8, 3> < 13,  19,  -20> rotate y*(360/n_bareau)*-n_bareau_porte}
					} 
			        }
			intersection {
				union {	// bareau
					#declare n_bareau = 64;
					#declare myCount = 0;
					#while (myCount < 360)
						cylinder { <12-dist, 9+r_bareau, 0>, <12-dist, 18-r_bareau, 0>, r_bareau rotate y*myCount }
						#declare myCount = myCount+(360/n_bareau);
					#end
					}
				difference {
					box {<0, 9-(r_bareau*2), 0> < 13,  18+(r_bareau*2),  -13> }
					box {<0+r_bareau, 8, 3> < 13,  19,  -20> rotate y*(360/n_bareau)*-n_bareau_porte}
					} 
				}
			translate z*12
			rotate y*80
			translate z*-12
			}	
		// perchoire
		union	{
			torus { 0.5, r_bareau rotate x*90 translate y*28}
			difference {
				torus { 4, r_bareau*2 rotate x*90}
				box { <-5, -5, -1>, <5, 0, 1> }
				translate y*23.5
				}
			cylinder { <4, 23.5, 0>, <4, 16, 0>, r_bareau*2 }
			cylinder { <-4, 23.5, 0>, <-4, 16, 0>, r_bareau*2 }
			cylinder { <4, 16, 0>, <-4, 16, 0>, 0.5 
				texture{ DMFWood3    
					normal { wood 0.5 scale 0.05 rotate<0,0,0> }
					rotate<0,0,0> scale 1  translate<0,0,0>
					} // end of texture 

				}
			rotate y*45
			}
		
		
		texture	{ 
			pigment { color rgb <0.94, 0.93, 0.80> } 
			finish {
				brilliance 2
				metallic
				specular 0.80
				roughness 1/20
				reflection 0.1
				}
			}  
		}		

        union	{	// support
	        intersection { 
	        	sphere { <0, 0, 0>, 3.2 scale y*0.8 translate y*27.75}
	        	cone { <0, 29, 0>, 3, <0, 31.5, 0>, 3 }
	        	}
	        intersection { 
	        	sphere { <0, 0, 0>, 4 scale y*0.6 translate y*27.75}
	        	cone { <0, 29-r_bareau, 0>, 3, <0, 29.75, 0>, 3 }
	        	}
		union	{
			cylinder { <0, 28, 0>, <0, 32, 0>, 0.3 }
			torus { 1.2, 0.2 rotate x*90 rotate y*-40 translate y*32.5}
			}
		texture	{ 
			pigment { color rgb <0.94, 0.93, 0.80> } 
			finish {
				brilliance 2
				metallic
				specular 0.80
				roughness 1/20
				reflection 0.1
				}
			}  
		}
	rotate y*-25
	}    
	
