#version unofficial megapov 1.21;

// presets
#default { finish { diffuse 0.8 } }
#declare ghost_loc = <-0.8, 0, -0.6>;

// radiosity pass
#declare pass = 2;

#declare InnerMat = texture {
  pigment { color rgb 0.2*<0.8, 0.95, 1> }
  finish { ambient 1 } }

#include "colors.inc"
#include "shapes.inc"
#include "BillMacros.inc"
#include "Books.inc"
#include "aikoghost_inner_POV_geom.inc"
#include "aikoghost_outer_POV_geom.inc"
#include "big_hair_POV_geom.inc"

global_settings {
  max_trace_level 15
  assumed_gamma 1
  radiosity {
    #if (pass = 1)
      pretrace_start 0.08
      pretrace_end 0.01
      error_bound 0.025
      minimum_reuse 0.000001
      nearest_count 8
      brightness 40
      count 1600
      save_file "absence.rad"
    #end
    #if (pass = 2)
      pretrace_start 1
      pretrace_end 1
      error_bound 0.05
      minimum_reuse 0.000001
      nearest_count 20
      brightness 50
      count 1600
      load_file "absence.rad"
    #end
    always_sample on
    media off
    recursion_limit 1
    low_error_factor 1
    gray_threshold 0.1
    adc_bailout 0.2 } }

camera {
  location <0, 1.75, -15>
  up <0, 1, 0>
  right <2.4, 0, 0>
  angle 20
  look_at <0, 0.75, 0> }

// --- chair ---
#declare Leather = texture {
  pigment { color Orange }
  finish { ambient 0 reflection { 0.4 exponent 0.5} }
  normal { bumps 0.22 scale 0.000001 } }
#declare Wood = texture {
  pigment {
    granite
    color_map {
      [0 color DarkWood]
      [0.5 color LightWood]
      [1 color MediumWood] }
    scale <0.1, 1, 0.1> }
  finish { ambient 0 reflection { 0.05 } } }
#declare er = 0.005;
#declare erm = 4;
#declare LeatherChair = union {
  // --- arms and back ---
  cylinder { <0.5, 1, 0>, <0.5, 1, 0.5>, 0.2 }
  cylinder { <-0.5, 1, 0>, <-0.5, 1, 0.5>, 0.2 }
  difference {
    torus { 0.5, 0.2+er*erm/2 }
    plane { <0, 0, 1>, 0 }
    translate <0, 1, 0.5> }
  // --- arm detail front ---
  sphere { <0, 0, 0>, 1 scale <0.2, 0.2, er*erm> translate <-0.5, 1, 0> }
  sphere { <0, 0, 0>, 1 scale <0.2, 0.2, er*erm> translate <0.5, 1, 0> }
  difference {
    torus { 0.2, er rotate <90, 0, 0> }
    object { Cube translate <1, -1, 0> }
    translate <-0.5, 1, 0> }
  difference {
    torus { 0.2, er rotate <90, 0, 0> }
    object { Cube translate <-1, -1, 0> }
    translate <0.5, 1, 0> }
  sphere { <-0.5, 0.5, 0>, er }
  sphere { <0.5, 0.5, 0>, er }
  // --- arm detail sides ---
  difference {
    torus { 0.2, er*erm/2 rotate <90, 0, 0> scale <1, 1, 0.5/(er*erm/2)> }
    plane { <0, 0, -1>, 0 }
    translate <-0.5, 1, 0.5> }
  difference {
    torus { 0.2, er*erm/2 rotate <90, 0, 0> scale <1, 1, 0.5/(er*erm/2)> }
    plane { <0, 0, -1>, 0 }
    translate <0.5, 1, 0.5> }
  // --- arm and back support ---
  object { Cube scale <0.1, 0.25, 0.25> translate <-0.4, 0.75, 0.25> }
  object { Cube scale <0.1, 0.25, 0.25> translate <0.4, 0.75, 0.25> }
  difference {
    cylinder { <0, 0, 0>, <0, 0.5, 0>, 0.5+er*erm/2 }
    cylinder { <0, -0.1, 0>, <0, 0.6, 0>, 0.3-er*erm/2 }
    plane { <0, 0, 1>, 0 }
    translate <0, 0.5, 0.5> }
  // --- arm and back support detail ---
  // inner
  difference {
    cylinder { <0, -1, 0>, <0, 1, 0>, 1 scale <er*erm/2, 0.25, 0.5> }
    plane { <0, 0, -1>, 0 }
    translate <-0.3, 0.75, 0.5> }
  difference {
    cylinder { <0, -1, 0>, <0, 1, 0>, 1 scale <er*erm/2, 0.25, 0.5> }
    plane { <0, 0, -1>, 0 }
    translate <0.3, 0.75, 0.5> }
  // corners
  cylinder { <-0.3, 1, 0>, <-0.3, 0.5, 0>, er }
  cylinder { <0.3, 1, 0>, <0.3, 0.5, 0>, er }
  cylinder { <-0.5, 0.8, 0>, <-0.5, 0.5, 0>, er }
  cylinder { <0.5, 0.8, 0>, <0.5, 0.5, 0>, er }
  // front
  cylinder { <0, -1, 0>, <0, 1, 0>, 1 scale <0.1, 0.25, er*erm/2> translate <-0.4, 0.75, 0> }
  cylinder { <0, -1, 0>, <0, 1, 0>, 1 scale <0.1, 0.25, er*erm/2> translate <0.4, 0.75, 0> }
  // outer
  difference {
    cylinder { <0, -1, 0>, <0, 1, 0>, 1 scale <er*erm/2, 0.25, 0.5> }
    plane { <0, 0, -1>, 0 }
    translate <0.5, 0.75, 0.5> }
  difference {
    cylinder { <0, -1, 0>, <0, 1, 0>, 1 scale <er*erm/2, 0.25, 0.5> }
    plane { <0, 0, -1>, 0 }
    translate <-0.5, 0.75, 0.5> }
  // --- base ---
  object { Cube scale <0.3, 0.1, 0.25> translate <0, 0.4, 0.25> }
  cylinder { <0, 0.3, 0.5>, <0, 0.5, 0.5>, 0.3 }
  intersection {
    union {
      cylinder { <-0.3, 0.5, 0>, <-0.3, 0.5, 0.5>, 0.2 }
      torus { 0.1, 0.1 rotate <90, 0, 0> scale <1, 1, (er*erm/2)/0.1> translate <-0.3, 0.5, 0> } }
    object { Cube scale <0.2, 0.2, 0.5> translate <-0.5, 0.3, 0.25> } }
  intersection {
    union {
      cylinder { <0.3, 0.5, 0>, <0.3, 0.5, 0.5>, 0.2 }
      torus { 0.1, 0.1 rotate <90, 0, 0> scale <1, 1, (er*erm/2)/0.1> translate <0.3, 0.5, 0> } }
    object { Cube scale <0.2, 0.2, 0.5> translate <0.5, 0.3, 0.25> } }
  difference {
    torus { 0.3, 0.2+er*erm/2 }
    plane { <0, -1, 0>, 0 }
    plane { <0, 0, 1>, 0 }
    translate <0, 0.5, 0.5> }
  // --- base detail ---
  sphere { <-0.3, 0.5, 0>, er }
  sphere { <0.3, 0.5, 0>, er }
  cylinder { <-0.3, 0.5, 0>, <0.3, 0.5, 0>, er }
  cylinder { <-0.3, 0.3, 0>, <0.3, 0.3, 0>, er }
  cylinder { <-1, 0, 0>, <1, 0, 0>, 1 scale <0.3, 0.1, er*erm/2> translate <0, 0.4, 0> }
  intersection {
    union {
      torus { 0.2, er rotate <90, 0, 0> translate <-0.3, 0.5, 0> }
      torus { 0.2, er rotate <90, 0, 0> translate <0.3, 0.5, 0> } }
    union {
      object { Cube scale <0.2, 0.2, 0.5> translate <-0.5, 0.3, 0> }
      object { Cube scale <0.2, 0.2, 0.5> translate <0.5, 0.3, 0> } } }
  difference {
    torus { 0.2, er*erm/2 rotate <90, 0, 0> scale <1, 1, 0.5/(er*erm/2)> }
    plane { <0, 0, -1>, 0 }
    plane { <0, -1, 0>, 0 }
    plane { <1, 0, 0>, 0 }
    translate <0.3, 0.5, 0.5> }
  difference {
    torus { 0.2, er*erm/2 rotate <90, 0, 0> scale <1, 1, 0.5/(er*erm/2)> }
    plane { <0, 0, -1>, 0 }
    plane { <0, -1, 0>, 0 }
    plane { <-1, 0, 0>, 0 }
    translate <-0.3, 0.5, 0.5> }
  // --- cushion ---
  union {
    object { Cube scale <0.3, 0.1, 0.225> translate <0, 0, 0.025> }
    object { Cube scale <0.25, 0.1, 0.25> }
    cylinder { <-0.25, -0.1, -0.2>, <-0.25, 0.1, -0.2>, 0.05 }
    cylinder { <0.25, -0.1, -0.2>, <0.25, 0.1, -0.2>, 0.05 }
    difference {
      cylinder { <0, -0.1, 0.25>, <0, 0.1, 0.25>, 0.3 }
      plane { <0, 0, 1>, 0.25 } }
    // edges
    cylinder { <-0.25, 0.1, -0.25>, <0.25, 0.1, -0.25>, er }
    cylinder { <-0.25, -0.1, -0.25>, <0.25, -0.1, -0.25>, er }
    cylinder { <-0.3, 0.1, -0.2>, <-0.3, 0.1, 0.25>, er }
    cylinder { <-0.3, -0.1, -0.2>, <-0.3, -0.1, 0.25>, er }
    cylinder { <0.3, 0.1, -0.2>, <0.3, 0.1, 0.25>, er }
    cylinder { <0.3, -0.1, -0.2>, <0.3, -0.1, 0.25>, er }
    difference {
      union {
        torus { 0.3, er translate <0, 0.1, 0.25> }
        torus { 0.3, er translate <0, -0.1, 0.25> } }
      plane { <0, 0, 1>, 0.25 } }
    intersection {
      union {
        torus { 0.05, er translate <-0.25, 0.1, -0.2> }
        torus { 0.05, er translate <-0.25, -0.1, -0.2> }
        torus { 0.05, er translate <0.25, 0.1, -0.2> }
        torus { 0.05, er translate <0.25, -0.1, -0.2> } }
      union {
        object { Cube scale <0.05, 1, 0.05> translate <0.3, 0, -0.25> }
        object { Cube scale <0.05, 1, 0.05> translate <-0.3, 0, -0.25> } } }
    // sides
    cylinder { <-1, 0, 0>, <1, 0, 0>, 1 scale <0.25, 0.1, er*erm/2> translate <0, 0, -0.25> }
    cylinder { <0, 0, -1>, <0, 0, 1>, 1 scale <er*erm/2, 0.1, 0.225> translate <0.3, 0, 0.025> }
    cylinder { <0, 0, -1>, <0, 0, 1>, 1 scale <er*erm/2, 0.1, 0.225> translate <-0.3, 0. 0.025> }
    torus { 0.05, er*erm/2 scale <1, 0.1/(er*erm/2), 1> translate <0.25, 0, -0.2> }
    torus { 0.05, er*erm/2 scale <1, 0.1/(er*erm/2), 1> translate <-0.25, 0, -0.2> }
    torus { 0.3, er*erm/2 scale <1, 0.1/(er*erm/2), 1> translate <0, 0, 0.25> }
    // top / bottom
    sphere { <0, 0, 0>, 1 scale <0.05, er*erm, 0.05> translate <-0.25, 0.1, -0.2> }
    sphere { <0, 0, 0>, 1 scale <0.05, er*erm, 0.05> translate <0.25, 0.1, -0.2> }
    cylinder { <-1, 0, 0>, <1, 0, 0>, 1 scale <0.25, er*erm, 0.05> translate <0, 0.1, -0.2> }
    cylinder { <0, 0, -1>, <0, 0, 1>, 1 scale <0.05, er*erm, 0.225> translate <0.25, 0.1, 0.025> }
    cylinder { <0, 0, -1>, <0, 0, 1>, 1 scale <0.05, er*erm, 0.225> translate <-0.25, 0.1, 0.025> }
    torus { 0.25, 0.05 scale <1, (er*erm)/0.05, 1> translate <0, 0.1, 0.25> }
    sphere { <0, 0, 0>, 1 scale <0.05, er*erm, 0.05> translate <-0.25, -0.1, -0.2> }
    sphere { <0, 0, 0>, 1 scale <0.05, er*erm, 0.05> translate <0.25, -0.1, -0.2> }
    cylinder { <-1, 0, 0>, <1, 0, 0>, 1 scale <0.25, er*erm, 0.05> translate <0, -0.1, -0.2> }
    cylinder { <0, 0, -1>, <0, 0, 1>, 1 scale <0.05, er*erm, 0.225> translate <0.25, -0.1, 0.025> }
    cylinder { <0, 0, -1>, <0, 0, 1>, 1 scale <0.05, er*erm, 0.225> translate <-0.25, -0.1, 0.025> }
    torus { 0.25, 0.05 scale <1, (er*erm)/0.05, 1> translate <0, -0.1, 0.25> }
    object { Cube scale <0.25, 0.1+er*erm, 0.225> translate <0, 0, 0.025> }
    cylinder { <0, -0.1-er*erm, 0.25>, <0, 0.1+er*erm, 0.25>, 0.25 }
    scale 0.975
    translate <0, 0.61, 0.24> }
  // --- legs ---
  difference {
    union {
      object { RoundedBox(0.04, 0.2, 0.04, 0.02) texture { Wood } translate <0, -0.2, 0> rotate <0, 0, 10> translate <0.25, 0.3, 0.1> }
      object { RoundedBox(0.04, 0.2, 0.04, 0.02) texture { Wood } translate <0, -0.2, 0> rotate <0, 0, -10> translate <-0.25, 0.3, 0.1> }
      object { RoundedBox(0.04, 0.2, 0.04, 0.02) texture { Wood } translate <0, -0.2, 0> rotate <0, 0, 10> translate <0.25, 0.3, 0.55> }
      object { RoundedBox(0.04, 0.2, 0.04, 0.02) texture { Wood } translate <0, -0.2, 0> rotate <0, 0, -10> translate <-0.25, 0.3, 0.55> } }
    plane { <0, 1, 0>, 0 } }
  texture { Leather } }

// --- lamp ---
#declare DullChrome = texture {
  pigment { color Black }
  finish { ambient 0 diffuse 0 reflection { 0.4 exponent 0.7 } } }
#declare GreyGlass = texture {
  pigment { color White }
  finish { ambient 0 reflection { 0.4 exponent 0.8 } } }
#declare Lamp = union {
  // stand
  cylinder { <0, 0, 0>, <0, 0.04, 0>, 0.195 }
  cylinder { <0, 0.005, 0>, <0, 0.035, 0>, 0.2 }
  torus { 0.195, 0.005 translate <0, 0.005, 0> }
  torus { 0.195, 0.005 translate <0, 0.035, 0> }
  cylinder { <0, 0.045, 0>, <0, 1.5, 0>, 0.015 }
  torus { 0.01, 0.005 translate <0, 0.045, 0> }
  // head
  difference {
    cylinder { <0, 1.3, 0>, <0, 1.5, 0>, 0.05 }
    torus { 0.05, 0.035 scale <1, 0.2/0.035, 1> translate <0, 1.3, 0> } }
  torus { 0.05, 0.005 translate <0, 1.505, 0> }
  // glass
  union {
    difference {
      sphere { <0, 0, 0>, 0.15 }
      sphere { <0, 0, 0>, 0.145 }
      plane { <0, -1, 0>, 0 } }
    torus { 0.1475, 0.0025 }
    translate <0, 1.645, 0>
    texture { GreyGlass } }
  // reading light
  union {
    difference {
      torus { 0.1, 0.01 rotate <90, 0, 0> }
      plane { <0, 1, 0>, 0 }
      plane { <0, 1, 0>, 0 rotate <0, 0, 45> } }
    difference {
      cylinder { <0, 0, 0>, <0, 0.04, 0>, 0.02 }
      torus { 0.02, 0.01 scale <1, 4, 1> }
      torus { 0.02, 0.005 translate <0, 0.045, 0> }
      translate <-0.1, 0, 0> rotate <0, 0, -135> }
    // reading light glass
    union {
      difference {
        sphere { <0, 0, 0>, 0.05 scale <1, 2, 1> }
        sphere { <0, 0, 0>, 0.045 scale <1, 2, 1> }
        plane { <0, -1, 0>, 0 } }
      torus { 0.0475, 0.0025 }
      translate <-0.1, 0.1325, 0> rotate <0, 0, -135>
      texture { GreyGlass } }
    translate <0.105, 0.75, 0> rotate <0, 110, 0> }
  // power cord
  sphere_sweep {
    b_spline
    18,
    <0, 0.6, 0>, 0.005,
    <0.015, 0.6, 0>, 0.005,
    <0.025, 0.58, 0>, 0.005,
    <0.025, 0.5, 0>, 0.005,
    <0.0225, 0.3, -0.01>, 0.005,
    <0.025, 0.075, 0>, 0.005,
    <0.05, 0.045, 0.05>, 0.005,
    <0.075, 0.045, 0.04>, 0.005,
    <0.1, 0.045, 0.035>, 0.005,
    <0.25, 0.045, 0.01>, 0.005,
    <0.3, 0.005, 0.01>, 0.005,
    <0.5, 0.005, 0.05>, 0.005,
    <0.75, 0.005, 0.2>, 0.005,
    <1, 0.005, 0.1>, 0.005,
    <1.5, 0.005, 0.1>, 0.005,
    <2, 0.005, 0.4>, 0.005,
    <5, 0.005, 0.35>, 0.005,
    <8, 0.005, 0.4>, 0.005
    tolerance 0.001
    pigment { color Black }
    finish { ambient 0 phong 0.25 phong_size 5 } }
  texture { DullChrome } }

// --- fireplace ---
#declare Paintt = texture {
  pigment { color White }
  finish { ambient 0 reflection { 0.05 } }
  normal { bumps 0.05 scale 0.0001 } }
#declare Wallt = texture {
  #if (pass = 1)
    pigment { color White }
  #end
  #if (pass = 2)
    pigment {
      granite
      color_map {
        [0 color White]
        [1 color Gray90] }
      scale 0.05*<1, 50, 1> }
  #end
  finish { ambient 0 reflection { 0.001 } }
  normal { granite 0.02 scale 0.05*<1, 50, 1> } }
#declare fer = 0.005;
#declare FirePlace = union {
  // base
  difference {
    Round_Cylinder_Union( <-0.5, -0.5, 0>, <-0.5, 0.8, 0>, 0.2, fer )
    plane { <-1, 0, 0>, 0.5 } }
  difference {
    Round_Cylinder_Union( <0.5, -0.5, 0>, <0.5, 0.8, 0>, 0.2, fer )
    plane { <1, 0, 0>, 0.5 } }
  difference {
    RoundedBox(0.6, 0.05, 0.2, fer)
    plane { <1, 0, 0>, -0.5 }
    plane { <-1, 0, 0>, -0.5 }
    translate <0, 0.75, 0> }
  difference {
    union {
      object { RoundedBox(0.1, 0.8, 0.2, fer) translate <0.5, 0, 0> }
      object { RoundedBox(0.1, 0.8, 0.2, fer) translate <-0.5, 0, 0> } }
      plane { <1, 0, 0>, -0.5 }
      plane { <-1, 0, 0>, -0.5 } }
  // trim front
  object { RoundedBox(0.03, 0.78, 0.02, fer) translate <0.45, 0, -0.2> }
  object { RoundedBox(0.03, 0.78, 0.02, fer) translate <-0.45, 0, -0.2> }
  object { RoundedBox(0.48, 0.04, 0.02, fer) translate <0, 0.76, -0.2> }
  // trim top
  Round_Cylinder_Union( <0.5, 0.75, 0>, <0.5, 0.82, 0>, 0.18, fer )
  Round_Cylinder_Union( <-0.5, 0.75, 0>, <-0.5, 0.82, 0>, 0.18, fer )
  object { RoundedBox(0.5, 0.02, 0.18, fer) translate <0, 0.8, 0> }
  object { RoundedBox(0.46, 0.02, 0.2, fer) translate <0, 0.8, 0> }
  texture { Paintt } }
#declare Tile = object { RoundedBox(0.05, 0.01, 0.05, 0.005) }
#declare Tiles = union {
  #declare xp = -0.45;
  #declare zp = 0;
  #while (zp > -0.45)
    #while (xp <= 0.45)
      object { Tile translate <xp, -0.02, zp> }
      #declare xp = xp + 0.1;
    #end
    #declare xp = -0.45;
    #declare zp = zp - 0.1;
  #end
  pigment { color Black }
  finish { ambient 0 reflection { 0.15 } phong 1 phong_size 100 } }
#declare FirePlaceFloor = union {
  union {
    cylinder { <0.45, -0.01, 0>, <0.45, -0.01, -0.4>, 0.011 }
    cylinder { <-0.45, -0.01, 0>, <-0.45, -0.01, -0.4>, 0.011 }
    cylinder { <-0.45, -0.01, -0.4>, <0.45, -0.01, -0.4>, 0.011 }
    pigment { color White }
    finish { ambient 0 diffuse 0.3 reflection { 1 } phong 1 phong_size 75 } }
  object { Tiles }
  object { Cube scale <0.1, 0.001, 0.2> translate <0, -0.02, 0> texture { Paintt }  }
  photons { collect off } }
#declare FirePlaceBack1 = union {
  object { Cube scale <0.4, 0.7, 0.075> }
  intersection {
    object { Cube scale <0.4, 0.7, 0.15> }
    union {
      plane { <0, 0, -1>, 0 rotate <0, -20, 0> translate <-0.4, 0, -0.15> }
      plane { <0, 0, -1>, 0 rotate <0, 20, 0> translate <0.4, 0, -0.15> } } }
  pigment {
    granite
    color_map {
      [0 color Gray50]
      [0.2 color Gray75]
      [1 color White] }
    scale 0.2 }
  finish { ambient 0 } }
#declare FirePlaceInside = union {
  difference {
    object { FirePlaceBack1 }
    object { Cube scale <0.15, 0.3, 0.2> } }
  union {
    object { RoundedBox(0.015, 0.3, 0.015, 0.0025) translate <0.15, 0, -0.075> }
    object { RoundedBox(0.015, 0.3, 0.015, 0.0025) translate <-0.15, 0, -0.075> }
    object { RoundedBox(0.165, 0.015, 0.015, 0.0025) translate <0, 0.3, -0.075> }
    pigment { color White }
    finish { ambient 0 diffuse 0.3 reflection { 1 } phong 1 phong_size 75 }
    photons { collect off } } }

// --- ashtray ---
#declare AshtrayGlass = texture {
  pigment { color Clear }
  finish { ambient 0 reflection { 0.2 exponent 0.8 } phong 1 phong_size 100 } }
#declare InnerGroove = merge {
  difference {
    merge {
      torus { 0.04, 0.01 rotate <90, 0, 0> translate <0, 0.2, 0.26> }
      torus { 0.04, 0.01 rotate <90, 0, 0> translate <0, 0.2, 0.49> } }
    plane { <0, -1, 0>, -0.2 } }
  sphere { <-0.04, 0.2, 0.49>, 0.01 }
  sphere { <-0.04, 0.2, 0.26>, 0.01 }
  sphere { <0.04, 0.2, 0.49>, 0.01 }
  sphere { <0.04, 0.2, 0.26>, 0.01 }
  cylinder { <0.04, 0.2, 0.26>, <0.04, 0.2, 0.49>, 0.01 }
  cylinder { <-0.04, 0.2, 0.26>, <-0.04, 0.2, 0.49>, 0.01 } }
#declare AshTray = merge {
  difference {
    merge {
      difference {
        merge {
          object { Cube scale <0.25, 0.1, 0.4> translate <0, 0.1, 0> }
          object { Cube scale <0.4, 0.1, 0.25> translate <0, 0.1, 0> }
          object { Cube scale <0.25, 0.05, 0.5> translate <0, 0.15, 0> }
          object { Cube scale <0.5, 0.05, 0.25> translate <0, 0.15, 0> }
          cylinder { <0.25, 0.1, 0.25>, <0.25, 0.2, 0.25>, 0.25 }
          cylinder { <-0.25, 0.1, 0.25>, <-0.25, 0.2, 0.25>, 0.25 }
          cylinder { <0.25, 0.1, -0.25>, <0.25, 0.2, -0.25>, 0.25 }
          cylinder { <-0.25, 0.1, -0.25>, <-0.25, 0.2, -0.25>, 0.25 }
          cylinder { <-0.25, 0.1, -0.4>, <0.25, 0.1, -0.4>, 0.1 }
          cylinder { <-0.25, 0.1, 0.4>, <0.25, 0.1, 0.4>, 0.1 }
          cylinder { <-0.4, 0.1, -0.25>, <-0.4, 0.1, 0.25>, 0.1 }
          cylinder { <0.4, 0.1, -0.25>, <0.4, 0.1, 0.25>, 0.1 }
          cylinder { <-0.25, 0, -0.25>, <-0.25, 0.1, -0.25>, 0.15 }
          cylinder { <-0.25, 0, 0.25>, <-0.25, 0.1, 0.25>, 0.15 }
          cylinder { <0.25, 0, -0.25>, <0.25, 0.1, -0.25>, 0.15 }
          cylinder { <0.25, 0, 0.25>, <0.25, 0.1, 0.25>, 0.15 }
          torus { 0.15, 0.1 translate <-0.25, 0.1, -0.25> }
          torus { 0.15, 0.1 translate <-0.25, 0.1, 0.25> }
          torus { 0.15, 0.1 translate <0.25, 0.1, -0.25> }
          torus { 0.15, 0.1 translate <0.25, 0.1, 0.25> } }
        object { RoundedBoxMerge(0.25, 0.1, 0.25, 0.01) translate <0, 0.2, 0> } }
      // top rims
      cylinder { <-0.25, 0.2, -0.49>, <0.25, 0.2, -0.49>, 0.01 }
      cylinder { <-0.24, 0.2, -0.26>, <0.24, 0.2, -0.26>, 0.01 }
      cylinder { <-0.24, 0.2, 0.26>, <0.24, 0.2, 0.26>, 0.01 }
      cylinder { <-0.25, 0.2, 0.49>, <0.25, 0.2, 0.49>, 0.01 }
      cylinder { <-0.49, 0.2, -0.25>, <-0.49, 0.2, 0.25>, 0.01 }
      cylinder { <-0.26, 0.2, -0.24>, <-0.26, 0.2, 0.24>, 0.01 }
      cylinder { <0.26, 0.2, -0.24>, <0.26, 0.2, 0.24>, 0.01 }
      cylinder { <0.49, 0.2, -0.25>, <0.49, 0.2, 0.25>, 0.01 }
      difference {
        merge {
          torus { 0.24, 0.01 translate <0.25, 0.2, 0.25> }
          torus { 0.24, 0.01 translate <0.25, 0.2, -0.25> }
          torus { 0.24, 0.01 translate <-0.25, 0.2, 0.25> }
          torus { 0.24, 0.01 translate <-0.25, 0.2, -0.25> }
          torus { 0.02, 0.01 translate <0.24, 0.2, 0.24> }
          torus { 0.02, 0.01 translate <0.24, 0.2, -0.24> }
          torus { 0.02, 0.01 translate <-0.24, 0.2, 0.24> }
          torus { 0.02, 0.01 translate <-0.24, 0.2, -0.24> }
          difference {
            cylinder { <0.25, 0.15, 0.25>, <0.25, 0.21, 0.25>, 0.24 }
            cylinder { <0.24, 0.1, 0.24>, <0.24, 0.25, 0.24>, 0.02 } }
          difference {
            cylinder { <0.25, 0.15, -0.25>, <0.25, 0.21, -0.25>, 0.24 }
            cylinder { <0.24, 0.1, -0.24>, <0.24, 0.21, -0.24>, 0.02 } }
          difference {
            cylinder { <-0.25, 0.15, 0.25>, <-0.25, 0.21, 0.25>, 0.24 }
            cylinder { <-0.24, 0.1, 0.24>, <-0.24, 0.25, 0.24>, 0.02 } }
          difference {
            cylinder { <-0.25, 0.15, -0.25>, <-0.25, 0.21, -0.25>, 0.24 }
            cylinder { <-0.24, 0.1, -0.24>, <-0.24, 0.25, -0.24>, 0.02 } } }
        object { Cube scale <0.6, 0.1, 0.24> translate <0, 0.2, 0> }
        object { Cube scale <0.24, 0.1, 0.6> translate <0, 0.2, 0> } }
      object { Cube scale <0.25, 0.01, 0.115> translate <0, 0.2, -0.375> }
      object { Cube scale <0.25, 0.01, 0.115> translate <0, 0.2, 0.375> }
      object { Cube scale <0.115, 0.01, 0.25> translate <-0.375, 0.2, 0> }
      object { Cube scale <0.115, 0.01, 0.25> translate <0.375, 0.2, 0> } }
    cylinder { <-0.6, 0.2, 0>, <0.6, 0.2, 0>, 0.03 }
    cylinder { <0, 0.2, -0.6>, <0, 0.2, 0.6>, 0.03 }
    object { Cube scale <0.6, 0.01, 0.04> translate <0, 0.21, 0> }
    object { Cube scale <0.04, 0.01, 0.6> translate <0, 0.21, 0> }
    cylinder { <-0.26, 0.2, 0>, <0.26, 0.2, 0>, 0.04 }
    cylinder { <0, 0.2, -0.26>, <0, 0.2, 0.26>, 0.04 }
    cylinder { <-0.49, 0.2, 0>, <-0.6, 0.2, 0>, 0.04 }
    cylinder { <0.49, 0.2, 0>, <0.6, 0.2, 0>, 0.04 }
    cylinder { <0, 0.2, -0.49>, <0, 0.2, -0.6>, 0.04 }
    cylinder { <0, 0.2, 0.49>, <0, 0.2, 0.6>, 0.04 } }
  object { InnerGroove }
  object { InnerGroove rotate <0, 90, 0> }
  object { InnerGroove rotate <0, 180, 0> }
  object { InnerGroove rotate <0, 270, 0> }
  texture { AshtrayGlass }
  interior { ior 1.5 }
  photons { target reflection on refraction on collect off } }

// --- coffee table ---
#declare Grout = texture {
  pigment { color Gray70 }
  finish { ambient 0 } }
#declare TableWood = texture {
  pigment {
    granite
    color_map {
      [0 color rgb 0.5*<0.2, 0.1, 0.05>]
      [0.25 color rgb 0.5*<1, 0.4, 0.15>]
      [1 color rgb 0.5*<0.5, 0.3, 0.12>] }
    scale 0.25*<0.1, 5, 0.1> }
  finish { ambient 0 reflection { 0.1 } }
  normal {
    average
    normal_map {
      [1 granite 0.01 scale 0.25*<0.1, 5, 0.1>]
      [1 bumps 0.05 scale 0.000001] } } }
#declare RedGranite = pigment {
  granite
  color_map {
    [0 color 0.1*Red]
    [1 color Red] }
  scale 5 }
#declare YellowGranite = pigment {
  granite
  color_map {
    [0 color 0.2*Brass]
    [1 color Brass] }
  scale 5 }
#declare TileT = texture {
  pigment {
    spherical
    pigment_map {
      [0 YellowGranite]
      [0.1 RedGranite]
      [1 RedGranite] }
    scale 0.175
    translate <-0.1, 0, -0.1> }
  finish { ambient 0 reflection { 0.1 } }
  normal { bumps 0.1 scale 0.01 } }
#declare er = 0.0035;
#declare Tile = object { RoundedBox(0.11, 0.01, 0.11, er*2) texture { TileT } }
#declare Support = union {
  object { RoundedBox(0.2, 0.04, 0.014, er) translate <0, 0.36, 0> texture { TableWood rotate <0, 0, 90> } }
  object { RoundedBox(0.05, 0.2, 0.015, er) translate <-0.2, 0.2, 0> texture { TableWood } }
  object { RoundedBox(0.05, 0.2, 0.015, er) translate <0.2, 0.2, 0> texture { TableWood } }
  object { RoundedBox(0.2, 0.04, 0.014, er) translate <0, 0.04, 0> texture { TableWood rotate <0, 0, 90> } } }
#declare CoffeeTable = union {
  // top
  object { RoundedBox(0.25, 0.05, 0.015, er) translate <0, 0.35, -0.235> texture { TableWood rotate <0, 0, 90> } }
  object { RoundedBox(0.25, 0.05, 0.015, er) translate <0, 0.35, 0.235> texture { TableWood rotate <0, 0, 90> } }
  object { RoundedBox(0.015, 0.05, 0.22, er) translate <0.235, 0.35, 0> texture { TableWood rotate <90, 0, 0> } }
  object { RoundedBox(0.015, 0.05, 0.22, er) translate <-0.235, 0.35, 0> texture { TableWood rotate <90, 0, 0> } }
  // support squares
  object { Support translate <0, 0, -0.28> }
  object { Support translate <0, 0, 0.28> }
  // join
  object { RoundedBox(0.15, 0.015, 0.28, er) translate <0, 0.35, 0> }
  // top tiles
  object { Cube scale <0.22, 0.018, 0.22> translate <0, 0.38, 0> texture { Grout } }
  object { Tile translate <0.11, 0.39, 0.11> }
  object { Tile rotate <0, 90, 0> translate <0.11, 0.39, -0.11> }
  object { Tile rotate <0, -90, 0> translate <-0.11, 0.39, 0.11> }
  object { Tile rotate <0, 180, 0> translate <-0.11, 0.39, -0.11> } }

// --- vases ---
#declare RoundVaseT = texture {
  pigment {
    bozo turbulence 0.2 octaves 8 omega 0.8
    color_map {
      [0 color 0.001*SeaGreen]
      [1 color SeaGreen] }
    scale 100 }
  finish { ambient 0 reflection { 0.2 exponent 0.8 } } }
#declare RoundVase = lathe {
  bezier_spline
  44, //nr points
  /*   0*/ <100, 440.00001>, <105, 445.00001>, <110,440.00001>, <105,435.00001>,
  /*   1*/ <105, 435.00001>, <99.999997, 430.00001>, <75.000002,405.00001>, <75.000002,360.00001>,
  /*   2*/ <75.000002, 360.00001>, <75.000002, 345.00001>, <95.000002,345.00001>, <110,335.00001>,
  /*   3*/ <110, 335.00001>, <125, 325.00001>, <140,310.00001>, <140,275>,
  /*   4*/ <140, 275>, <140, 190>, <80.000004,49.999983>, <70.000004,29.999983>,
  /*   5*/ <70.000004, 29.999983>, <64.561824, 19.123683>, <70.000004,-1.7382812e-05>, <65.000004,-1.7382812e-05>,
  /*   6*/ <65.000004, -1.7382812e-05>, <60.000004, -1.7382812e-05>, <10.000004,-1.7382812e-05>, <3.8204725e-06,-1.7382812e-05>,
  /*   7*/ <3.8204725e-06, -1.7382812e-05>, <3.8204725e-06, 4.9999826>, <0,52.500003>, <0,95.000003>,
  /*   8*/ <0, 95.000003>, <0, 116.25>, <68.87219,118.30828>, <80.000002,135>,
  /*   9*/ <80.000002, 135>, <90.000002, 150>, <65.000002,340.00001>, <65.000002,360.00001>,
  /*  10*/ <65.000002, 360.00001>, <65.000002, 400.00001>, <94.999997,435.00001>, <100,440.00001>
  texture { RoundVaseT } }
#declare RoundVase2T = texture {
  pigment {
    bozo turbulence 0.2 octaves 8 omega 0.8
    color_map {
      [0 color 0.001*Orange]
      [1 color Orange] }
    scale 100 }
  finish { ambient 0 reflection { 0.2 exponent 0.8 } } }
#declare RoundVase2 = lathe {
  bezier_spline
  40, //nr points
  /*   0*/ <55.000002, 380.00001>, <50.000002, 375.00001>, <28.767333,329.86136>, <35.000001,280.00001>,
  /*   1*/ <35.000001, 280.00001>, <45.000001, 200.00001>, <95.000003,200>, <95.000003,130>,
  /*   2*/ <95.000003, 130>, <95.000003, 44.999984>, <55.000001,20>, <50.000001,15>,
  /*   3*/ <50.000001, 15>, <45.000001, 10>, <50.000001,0>, <45.000001,0>,
  /*   4*/ <45.000001, 0>, <40.000001, 0>, <10.000004,-1.7382812e-05>, <3.8204725e-06,-1.7382812e-05>,
  /*   5*/ <3.8204725e-06, -1.7382812e-05>, <3.8204725e-06, 4.9999826>, <0,52.500003>, <0,95.000003>,
  /*   6*/ <0, 95.000003>, <0, 116.25>, <8.8721886,98.308283>, <20.000001,115>,
  /*   7*/ <20.000001, 115>, <30.000001, 130>, <25.000001,260.00001>, <25.000001,280.00001>,
  /*   8*/ <25.000001, 280.00001>, <25.000001, 335.00001>, <45.000001,380.00001>, <50.000001,385.00001>,
  /*   9*/ <50.000001, 385.00001>, <55.000001, 390.00001>, <60.000002,385.00001>, <55.000002,380.00001>
  texture { RoundVase2T } }

// --- picture frames ---
#declare BackingT = texture {
  pigment { color LightWood }
  finish { ambient 0 }
  normal { granite 0.5 scale 0.001 } }
#declare PaneT = texture {
  pigment { color Clear }
  finish { ambient 0 reflection { 0.1 } } }
#declare FrameT = texture {
  pigment { color DarkWood }
  finish { ambient 0 reflection { 0.2 } } }
#declare Picture = texture {
  pigment {
    image_map {
      png "aikoimage1.png" interpolate 2 }
    scale <0.12, 0.22, 1> translate <-0.06, -0.11, 0> }
  finish { ambient 0 } }
#declare PlainCrossSection = union {
  object { Cube scale <1, 0.02, 0.01> translate <0, 0.02, 0> }
  cylinder { <-1, 0, 0>, <1, 0, 0>, 1 scale <1, 0.02, 0.01> translate <0, 0.02, -0.01> } }
#declare HandPicture = union {
  union { PictureFrame(PlainCrossSection, 0.12, 0.2, 0.04) }
  // back
  object {
    Cube scale <0.08, 0.13, 0.001> translate <0, 0, 0.01>
    texture { BackingT } }
  // glass front
  /*object {
    Cube scale <0.059999, 0.109999, 0.0025> translate <0, 0, -0.0025>
    texture { PaneT } }*/
  // picture
  object {
    Cube scale <0.06, 0.11, 0.0001>
    texture { Picture } }
  texture { FrameT } }

// --- wine bottle and glass ---
#declare Cork = lathe {
  bezier_spline
  20, //nr points
  /*   0*/ <0, 567.00001>, <10, 567.00001>, <10,569.00001>, <21.000001,569.00001>,
  /*   1*/ <21.000001, 569.00001>, <23.000001, 569.00001>, <24.000001,568.00001>, <24.000001,566.00001>,
  /*   2*/ <24.000001, 566.00001>, <24.000001, 563.95957>, <24.000001,507.00001>, <24.000001,505.00001>,
  /*   3*/ <24.000001, 505.00001>, <24.000001, 503.00001>, <23.000223,501.96417>, <21.000001,501.96968>,
  /*   4*/ <21.000001, 501.96968>, <10, 502.00001>, <10,504.00001>, <0,504.00001>
  pigment { color MediumWood }
  finish { ambient 0 } }
#declare Wine = lathe {
  bezier_spline
  28, //nr points
  /*   0*/ <0, 480.00001>, <5.0000001, 480.00001>, <20.000001,480.00001>, <24.000001,480.00001>,
  /*   1*/ <24.000001, 480.00001>, <24.000001, 478.00001>, <24.000001,477.00001>, <24.000001,475.00001>,
  /*   2*/ <24.000001, 475.00001>, <24.000008, 433.00001>, <36.000001,430.00001>, <50.000001,419.00001>,
  /*   3*/ <50.000001, 419.00001>, <65.104684, 407.13205>, <74.000002,394.00001>, <74.000002,370.00001>,
  /*   4*/ <74.000002, 370.00001>, <74.000002, 364.79897>, <74.000002,24.999983>, <74.000002,14.999983>,
  /*   5*/ <74.000002, 14.999983>, <74.000002, 10.999983>, <70.000002,10.999983>, <65.000002,10.999983>,
  /*   6*/ <65.000002, 10.999983>, <41.000001, 10.999983>, <35.000001,45.999983>, <0,45.999983> }
#declare Wrapper = lathe {
  bezier_spline
  16, //nr points
  /*   0*/ <0, 569.00001>, <6.0000002, 569.00001>, <21.054425,569.34242>, <25.000001,570.00001>,
  /*   1*/ <25.000001, 570.00001>, <37.000001, 572.00001>, <35.000001,566.04989>, <35.000001,556.00001>,
  /*   2*/ <35.000001, 556.00001>, <35.000001, 548.00001>, <32.000001,550.00001>, <31.000001,541.00001>,
  /*   3*/ <31.000001, 541.00001>, <29.026632, 523.23969>, <31.000001,491.00001>, <30.000001,482.00001> }
#declare WineBottle = lathe {
  bezier_spline
  60, //nr points
  /*   0*/ <0, 44.999983>, <35.000001, 44.999983>, <40.000001,9.9999826>, <65.000002,9.9999826>,
  /*   1*/ <65.000002, 9.9999826>, <70.000002, 9.9999826>, <75.000002,9.9999826>, <75.000002,14.999983>,
  /*   2*/ <75.000002, 14.999983>, <75.000002, 27.747583>, <75.000002,307.97561>, <75.000002,370.00001>,
  /*   3*/ <75.000002, 370.00001>, <75.000002, 395.00001>, <64.422207,409.18335>, <50.000001,420.00001>,
  /*   4*/ <50.000001, 420.00001>, <30.000001, 435.00001>, <25.000001,440.00001>, <25.000001,475.00001>,
  /*   5*/ <25.000001, 475.00001>, <25.000001, 495.00001>, <25.000001,515.00001>, <25.000001,535.00001>,
  /*   6*/ <25.000001, 535.00001>, <25.000002, 565.00001>, <25.000001,570.00001>, <30.000001,570.00001>,
  /*   7*/ <30.000001, 570.00001>, <35.000001, 570.00001>, <35.000001,566.90336>, <35.000001,560.00001>,
  /*   8*/ <35.000001, 560.00001>, <35.000001, 545.00001>, <30.000001,550.00001>, <30.000001,535.00001>,
  /*   9*/ <30.000001, 535.00001>, <30.000001, 527.50001>, <30.000001,500.00001>, <30.000001,475.00001>,
  /*  10*/ <30.000001, 475.00001>, <30.000001, 450.95578>, <32.111457,438.41642>, <50.000001,425.00001>,
  /*  11*/ <50.000001, 425.00001>, <70.000002, 410.00001>, <80.000002,395.00001>, <80.000002,370.00001>,
  /*  12*/ <80.000002, 370.00001>, <80.000002, 349.99999>, <80.000002,35.495083>, <80.000002,9.9999826>,
  /*  13*/ <80.000002, 9.9999826>, <80.000002, 4.9999826>, <75.000002,-1.7382812e-05>, <70.000002,-1.7382812e-05>,
  /*  14*/ <70.000002, -1.7382812e-05>, <30.000001, -1.7382812e-05>, <30.000001,34.999983>, <0,34.999983> }
#declare EmptyBottle = union {
  object {
    WineBottle scale 0.001
    pigment { color rgbf<0.6, 0.75, 0.1, 1> }
    finish { ambient 0 diffuse 0 reflection { 0.2 exponent 0.8 } }
    interior { ior 1.5 }
    photons { target reflection on refraction on collect off } }
  difference {
    cylinder { <0, 0.1, 0>, <0, 0.3, 0>, 0.0801 }
    cylinder { <0, 0, 0>, <0, 0.4, 0>, 0.08009 }
    plane { <0, 0, -1>, 0 rotate <0, 20, 0> }
    plane { <0, 0, -1>, 0 rotate <0, -20, 0> }
    pigment {
      image_map { jpeg "label2.jpg" interpolate 2 once }
      scale <7/18, 1, 1>
      warp { cylindrical }
      rotate <0, 160, 0> scale 0.2 translate <0, 0.1, 0> }
  finish { ambient 0 } } }
#declare FullRed = union {
  object {
    WineBottle scale 0.001
    pigment { color rgbf<0.6, 0.75, 0.1, 1> }
    finish { ambient 0 diffuse 0 reflection { 0.2 exponent 0.8 } }
    interior { ior 1.5 }
    photons { target reflection on refraction on collect off } }
  object { Cork scale 0.001 }
  object {
    Wine scale 0.001
    pigment { color rgbf<0.5,0,0,1> }
    finish { ambient 0 diffuse 0 }
    interior { ior 1.33 }
    photons { target reflection on refraction on collect off } }
  object {
    Wrapper scale 0.001
    pigment { color Navy }
    finish { ambient 0 reflection { 0.2 exponent 0.8 } } }
  difference {
    cylinder { <0, 0.1, 0>, <0, 0.3, 0>, 0.0801 }
    cylinder { <0, 0, 0>, <0, 0.4, 0>, 0.08009 }
    plane { <0, 0, -1>, 0 rotate <0, 20, 0> }
    plane { <0, 0, -1>, 0 rotate <0, -20, 0> }
    pigment {
      image_map { jpeg "label1.jpg" interpolate 2 once }
      scale <7/18, 1, 1>
      warp { cylindrical }
      rotate <0, 160, 0> scale 0.2 translate <0, 0.1, 0> }
    finish { ambient 0 } } }
#declare FullWhite = union {
  object {
    WineBottle scale 0.001
    pigment { color rgbf<1, 1, 1, 1> }
    finish { ambient 0 diffuse 0 reflection { 0.2 exponent 0.8 } }
    interior { ior 1.5 }
    photons { target reflection on refraction on collect off } }
  object { Cork scale 0.001 }
  object {
    Wine scale 0.001
    pigment { color rgbf<0.9,1,0,1> }
    finish { ambient 0 diffuse 0 }
    interior { ior 1.33 }
    photons { target reflection on refraction on collect off } }
  object {
    Wrapper scale 0.001
    pigment { color Gray10 }
    finish { ambient 0 reflection { 0.2 exponent 0.8 } } }
  difference {
    cylinder { <0, 0.1, 0>, <0, 0.3, 0>, 0.0801 }
    cylinder { <0, 0, 0>, <0, 0.4, 0>, 0.08009 }
    plane { <0, 0, -1>, 0 rotate <0, 20, 0> }
    plane { <0, 0, -1>, 0 rotate <0, -20, 0> }
    pigment {
      image_map { jpeg "label4.jpg" interpolate 2 once }
      scale <7/18, 1, 1>
      warp { cylindrical }
      rotate <0, 160, 0> scale 0.2 translate <0, 0.1, 0> }
    finish { ambient 0 } } }
#declare WineGlass = lathe {
  bezier_spline
  40, //nr points
  /*   0*/ <-1.7322834e-07, 160>, <15, 160>, <10.000001,145>, <30.000001,155>,
  /*   1*/ <30.000001, 155>, <50.000001, 165>, <60.000002,170>, <70.000002,200>,
  /*   2*/ <70.000002, 200>, <78.06226, 224.18678>, <75.000002,265>, <60.000002,285>,
  /*   3*/ <60.000002, 285>, <55.757359, 290.65686>, <61.837721,291.32457>, <65.000002,285>,
  /*   4*/ <65.000002, 285>, <80.000002, 255>, <80.827808,217.06952>, <70.000002,190>,
  /*   5*/ <70.000002, 190>, <60.000002, 165>, <45.000001,160>, <30.000001,150>,
  /*   6*/ <30.000001, 150>, <15, 140>, <5.0000001,100>, <5.0000001,80.000003>,
  /*   7*/ <5.0000001, 80.000003>, <5.0000001, 59.999983>, <4.7017787,13.162283>, <30.000001,9.9999826>,
  /*   8*/ <30.000001, 9.9999826>, <70.000002, 4.9999826>, <75.000002,-1.7382812e-05>, <70.000002,-1.7382812e-05>,
  /*   9*/ <70.000002, -1.7382812e-05>, <15, -1.7382812e-05>, <10,-1.7382812e-05>, <0,4.9999826>
  pigment { color Clear }
  finish { ambient 0 diffuse 0 reflection { 0.2 exponent 0.8 } }
  interior { ior 1.5 }
  photons { target reflection on refraction on collect off } }

// --- bowl ---
#declare Bowl = lathe {
  bezier_spline
  24, //nr points
  /*   0*/ <0, 14.999983>, <120, 14.999983>, <175,49.999983>, <145,100>,
  /*   1*/ <145, 100>, <142.42752, 104.28746>, <147.76393,104.47214>, <150,100>,
  /*   2*/ <150, 100>, <165, 70.000003>, <157.76606,53.212823>, <135,34.999983>,
  /*   3*/ <135, 34.999983>, <110, 14.999983>, <75.000002,14.999983>, <70.000002,9.9999826>,
  /*   4*/ <70.000002, 9.9999826>, <65.000002, 4.9999826>, <70.000002,-1.7382812e-05>, <65.000002,-1.7382812e-05>,
  /*   5*/ <65.000002, -1.7382812e-05>, <60.000002, -1.7382812e-05>, <10.000004,-1.7382812e-05>, <3.8204725e-06,-1.7382812e-05>
  scale 0.001
  texture {
    pigment {
      bozo
      color_map {
        [0 color rgb <0.5, 0.8, 1>]
        [0.7 color rgb <0.5, 0.8, 1>]
        [0.71 color Navy]
        [1 color Navy] }
      scale 0.005 }
    finish { ambient 0 } }
  texture {
    pigment {
      gradient y
      color_map {
        [0 color Clear]
        [0.75 color Clear]
        [0.76 color Navy]
        [1 color Navy] }
      scale 0.125 }
    finish { ambient 0 reflection { 0.2 exponent 0.8 } } } }

// --- big pictures ---
#declare WallCrossSection = union {
  difference {
    object { Cube scale <1, 0.2, 0.2> translate <0, 0.3, 0> }
    object { Cube scale <2, 0.2, 0.2> translate <0, 0, -0.3> }
    cylinder { <-2, 0.2, -0.2>, <2, 0.2, -0.2>, 0.1 } }
  cylinder { <-1, 0.1, 0>, <1, 0.1, 0>, 0.1 }
  cylinder { <-1, 0.4, -0.2>, <1, 0.4, -0.2>, 0.1 }
  scale <1, 0.1, 0.1>
  texture {
    pigment {
      granite
      color_map {
        [0 color LightWood]
        [1 color DarkWood] }
      scale <5, 0.1, 0.1> }
    finish { ambient 0 reflection { 0.2 exponent 0.8 } } } }
#declare WallPicture = union {
  union { PictureFrame(WallCrossSection, 0.9*1.667, 0.688, 0.05) }
  object {
    Cube scale <0.9*1.667/2, 0.688/2, 0.0001>
    texture {
      pigment { color White }
      finish { ambient 0 } }
    texture {
      pigment {
        image_map { png "prettyloch.png" interpolate 2 once }
        scale 0.8*<1.667, 0.688, 1> translate 0.8*<-1.667/2, -0.688/2, 1> }
      finish { ambient 0 } } }
  scale 0.5 }
#declare WallPicture2 = union {
  union { PictureFrame(WallCrossSection, 0.768, 1.024, 0.05) }
  object {
    Cube scale <0.768/2, 1.024/2, 0.0001>
    texture {
      pigment { color White }
      finish { ambient 0 } }
    texture {
      pigment {
        image_map { png "venice.png" interpolate 2 once }
        scale <0.85*0.768, 0.9*1.024, 1> translate <-0.85*0.768/2, -0.9*1.024/2, 1> }
      finish { ambient 0 } } }
    scale 0.5 }

// --- sideboard ---
#declare SideWood = texture {
  pigment {
    granite
    color_map {
      [0 color LightWood]
      [1 color MediumWood] }
    scale <1, 0.05, 0.05> }
  finish { ambient 0 reflection { 0.2 exponent 0.8 } } }
#declare SideKnob = union {
  torus { 0.1, 0.02 rotate <90, 0, 0> }
  cylinder { <0, 0, 0.02>, <0, 0, -0.02>, 0.1 }
  #declare a = 0;
  #while (a < 180)
    sphere { <0, 0, 0>, 1 scale <0.02, 0.1, 0.04> rotate <0, 0, a> }
    #declare a = a + 30;
  #end
  cylinder { <0, 0, -0.02>, <0, 0, -0.1>, 0.03 }
  torus { 0.06, 0.02 rotate <90, 0, 0> translate <0, 0, -0.09> }
  sphere { <0, 0, -0.12>, 0.08 }
  #declare a = 0;
  #while (a < 180)
    sphere { <0, 0, 0>, 1 scale <0.02, 0.085, 0.04> translate <0, 0, -0.1> rotate <0, 0, a> }
    #declare a = a + 15;
  #end
  sphere { <0, 0, -0.19>, 0.02 }
  pigment { color Black }
  finish { ambient 0 diffuse 0.4 reflection { 1 } } }
#declare SideDoor = union {
  object { RoundedBox(0.11, 0.02, 0.01, 0.001) translate <0, 0.13, 0> texture { SideWood } }
  object { RoundedBox(0.11, 0.02, 0.01, 0.001) translate <0, -0.13, 0> texture { SideWood } }
  object { RoundedBox(0.02, 0.13, 0.01, 0.001) translate <-0.09, 0, 0> texture { SideWood rotate <0, 0, 90> } }
  object { RoundedBox(0.02, 0.13, 0.01, 0.001) translate <0.09, 0, 0> texture { SideWood rotate <0, 0, 90> } }
  object { Cube scale <0.09, 0.13, 0.005> texture { SideWood rotate <0, 0, 90> } } }
#declare SideDrawer = union {
  object { RoundedBox(0.175, 0.045, 0.01, 0.001) }
  object { SideKnob scale 0.1 translate <0, 0, -0.01> } }
#declare SideFoot = union {
  object { RoundedBox(0.02, 0.05, 0.02, 0.001) translate <0, 0.05, 0> }
  object { RoundedBox(0.025, 0.025, 0.025, 0.001) translate <0, 0.025, 0> }
  texture { SideWood rotate <0, 0, 90> } }
#declare Sideboard = union {
  object { RoundedBox(0.5, 0.01, 0.2, 0.001) translate <0, 0.1, 0> texture { SideWood } }
  object { RoundedBox(0.5, 0.01, 0.2, 0.001) translate <0, 0.4, 0> texture { SideWood } }
  union {
    object { RoundedBox(0.025, 0.15, 0.025, 0.001) translate <-0.47, 0.25, -0.17> }
    object { RoundedBox(0.025, 0.15, 0.025, 0.001) translate <-0.47, 0.25, 0.17> }
    object { RoundedBox(0.025, 0.15, 0.025, 0.001) translate <0.47, 0.25, -0.17> }
    object { RoundedBox(0.025, 0.15, 0.025, 0.001) translate <0.47, 0.25, 0.17> }
    object { Cube scale <0.02, 0.15, 0.17> translate <-0.47, 0.25, 0> }
    object { Cube scale <0.02, 0.15, 0.17> translate <0.47, 0.25, 0> }
    object { Cube scale <0.47, 0.15, 0.02> translate <0, 0.25, 0.17> }
    object { RoundedBox(0.025, 0.15, 0.025, 0.001) translate <-0.2, 0.25, -0.17> }
    object { RoundedBox(0.025, 0.15, 0.025, 0.001) translate <0.2, 0.25, -0.17> }
    texture { SideWood rotate <0, 0, 90> } }
  object { SideDoor translate <-0.335, 0.25, -0.18> }
  object { SideDoor translate <0.335, 0.25, -0.18> }
  object { SideKnob scale 0.1 translate <-0.245, 0.25, -0.19> }
  object { SideKnob scale 0.1 translate <0.245, 0.25, -0.19> }
  object { SideDrawer translate <0, 0.11 + 0.28/6, -0.18> texture { SideWood } }
  object { SideDrawer translate <0, 0.25, -0.18> texture { SideWood } }
  object { SideDrawer translate <0, 0.11 + 5*0.28/6, -0.18> texture { SideWood } }
  object { SideFoot translate <-0.47, 0, -0.17> }
  object { SideFoot translate <-0.47, 0, 0.17> }
  object { SideFoot translate <0.47, 0, -0.17> }
  object { SideFoot translate <0.47, 0, 0.17> } }

// --- fireplace grate ---
#declare Grate = union {
  // edges
  object { RoundedBox(0.01, 0.01, 0.15, 0.001) translate <-0.15, 0.06, 0> }
  object { RoundedBox(0.01, 0.01, 0.15, 0.001) translate <0.15, 0.06, 0> }
  object { RoundedBox(0.16 0.01, 0.01, 0.001) translate <0, 0.06, 0.15> }
  object { RoundedBox(0.16, 0.01, 0.01, 0.001) translate <0, 0.06, -0.15> }
  object { RoundedBox(0.01, 0.06, 0.01, 0.001) translate <-0.15, 0.06, 0.15> }
  object { RoundedBox(0.01, 0.06, 0.01, 0.001) translate <-0.15, 0.06, -0.15> }
  object { RoundedBox(0.01, 0.06, 0.01, 0.001) translate <0.15, 0.06, 0.15> }
  object { RoundedBox(0.01, 0.06, 0.01, 0.001) translate <0.15, 0.06, -0.15> }
  object { RoundedBox(0.01, 0.01, 0.16, 0.001) translate <-0.15, 0.12, 0> }
  object { RoundedBox(0.01, 0.01, 0.16, 0.001) translate <0.15, 0.12, 0> }
  object { RoundedBox(0.16, 0.01, 0.01, 0.001) translate <0, 0.12, 0.15> }
  object { RoundedBox(0.16, 0.01, 0.01, 0.001) translate <0, 0.12, -0.15> }
    // floor
  object { RoundedBox(0.01, 0.01, 0.15, 0.001) translate <-0.1, 0.06, 0> }
  object { RoundedBox(0.01, 0.01, 0.15, 0.001) translate <-0.05, 0.06, 0> }
  object { RoundedBox(0.01, 0.01, 0.15, 0.001) translate <0, 0.06, 0> }
  object { RoundedBox(0.01, 0.01, 0.15, 0.001) translate <0.05, 0.06, 0> }
  object { RoundedBox(0.01, 0.01, 0.15, 0.001) translate <0.1, 0.06, 0> }
  // walls
  #declare zp = 0.12;
  #while (zp > -0.15)
    #declare ys = 0.0375 + abs(zp)/10;
    object { RoundedBox(0.004, ys, 0.01, 0.003) translate <-0.16, 0.06+ys, zp> }
    object { RoundedBox(0.004, ys, 0.01, 0.003) translate <0.16, 0.06+ys, zp> }
    #declare zp = zp - 0.03;
  #end
  #declare xp = -0.12;
  #while (xp < 0.15)
    #declare ys = 0.0375 + abs(xp)/10;
    object { RoundedBox(0.01, ys, 0.004, 0.003) translate <xp, 0.06+ys, 0.16> }
    object { RoundedBox(0.01, ys, 0.004, 0.003) translate <xp, 0.06+ys, -0.16> }
    #declare xp = xp + 0.03;
  #end
  // tray
  object { RoundedBox(0.14, 0.005, 0.15, 0.001) translate <0, 0.005, 0> }
  object { RoundedBox(0.14, 0.029, 0.01, 0.005) translate <0, 0.029, -0.155> }
  sphere { <0, 0.028, -0.17>, 0.015 }
  pigment {
    bozo turbulence 0.4 octaves 9 omega 0.9
    color_map {
      [0 color Gray20]
      [0.33 color Gray10]
      [1 color Orange] }
    scale 0.1 }
  finish { ambient 0 phong 1 phong_size 20 }
  normal { granite 0.5 scale 0.01 } }

// --- reflective ball ---
#declare MirrorBall = union {
  object {
    RoundedBox(0.05, 0.025, 0.05, 0.005) translate <0, 0.025, 0>
    pigment {
      granite
      color_map {
        [0 color Orange]
        [1 color Brown] }
      scale <0.05, 1, 0.05> }
    finish { ambient 0 reflection { 0.2 exponent 0.8 } } }
  sphere {
    <0, 0.11, 0>, 0.07
    pigment { color Black }
    finish { ambient 0 reflection { 1 } } } }

// --- bookshelf ---
#declare BookShelf = union {
  // sides
  object { RoundedBox(0.01, 0.875, 0.1, 0.001) translate <-0.5, 0.875, 0> }
  object { RoundedBox(0.01, 0.875, 0.1, 0.001) translate <0.5, 0.875, 0> }
  cylinder { <0.5, 0, -0.1>, <0.5, 1.74, -0.1>, 0.005 }
  cylinder { <-0.5, 0, -0.1>, <-0.5, 1.74, -0.1>, 0.005 }
  sphere { <0.5, 1.74, -0.1>, 0.005 }
  sphere { <-0.5, 1.74, -0.1>, 0.005 }
  union {
    object { RoundedBox(0.5, 0.01, 0.1, 0.001) translate <0, 1.74, 0> }
    object { RoundedBox(0.5, 0.05, 0.09, 0.001) translate <0, 0.05, 0> }
    cylinder { <-0.5, 1.74, -0.1>, <0.5, 1.74, -0.1>, 0.005 }
    cylinder { <-0.5, 0.1, -0.1>, <0.5, 0.1, -0.1>, 0.005 }
    object { RoundedBox(0.47, 0.03, 0.1, 0.001) translate <0, 0.05, 0> }
    texture { SideWood } }
  // back
  object { Cube scale <0.5, 0.875, 0.005> translate <0, 0.875, 0.095> }
  // shelves
  #declare yp = 0.1;
  #while (yp < 1.74)
    object { RoundedBox(0.5, 0.01, 0.1, 0.001) translate <0, yp, 0> texture { SideWood } }
    cylinder { <-0.5, yp, -0.1>, <0.5, yp, -0.1>, 0.005 texture { SideWood } }
    #declare yp = yp + 1.64/7;
  #end
  texture { SideWood rotate <0, 0, 90> } }
#declare crnd = seed(3);
#declare prnd = seed(1);
#declare  dShelf = 1.64/7;
#declare WholeBookShelf = union {
  object { BookShelf }
  // bottom shelf
  union { HardBackRow(0.3, 4, 0.1, 1, 3) translate <-0.48, 0.11, 0> }
  union { HardBackRow(0.4, 6, 0.08, 2, 1) translate <-0.18, 0.11, 0> }
  // second shelf
  union { HardBackRow(0.9, 20, 0.08, 3, 2) translate <-0.48, 0.11+dShelf, 0> }
  // third shelf
  union { RandomRow(0.9, 0.08) translate <-0.48, 0.11+2*dShelf, 0> }
  // fourth shelf
  union { PaperRow(0.4, 12, 0.07) translate <-0.48, 0.11+3*dShelf, 0> }
  union { RandomRow(0.5, 0.07) translate <-0.08, 0.11+3*dShelf, 0> }
  // fifth shelf
  union { PaperRow(0.3, 7, 0.06) translate <-0.48, 0.11+4*dShelf, 0> }
  union { PaperRow(0.2, 5, 0.07) translate <-0.18, 0.11+4*dShelf, 0> }
  // sixth shelf
  union { RandomRow(0.2, 0.07) translate <-0.48, 0.11+5*dShelf, 0> }
  union { PaperRow(0.1, 4, 0.07) translate <-0.28, 0.11+5*dShelf, 0> }
  union { RandomRow(0.1, 0.07) translate <-0.18, 0.11+5*dShelf, 0> }
  union { HardBackRow(0.3, 10, 0.07, 1, 1) translate <-0.08, 0.11+5*dShelf, 0> }
  // top shelf
  union { HardBackRow(0.1, 6, 0.08, 2, 2) translate <-0.48, 0.11+6*dShelf, 0> }
  union { RandomRow(0.2, 0.07) translate <-0.38, 0.11+6*dShelf, 0> }
  union { PaperRow(0.1, 5, 0.07) translate <-0.18, 0.11+6*dShelf, 0> }
  union { RandomRow(0.2, 0.07) translate <-0.08, 0.11+6*dShelf, 0> }
  union { PaperRow(0.2, 8, 0.07) translate <0.12, 0.11+6*dShelf, 0> } }

// --- place objects ---

object { LeatherChair scale 0.6 rotate <0, 30, 0> translate <1.5, 0, -0.5> photons { collect off } }
object { Lamp translate <1, 0, 0> photons { collect off } }
union {
  object { CoffeeTable }
  object { AshTray scale 0.15 rotate <0, 40, 0> translate <0.1, 0.4, -0.05> }
  object { WineGlass scale 0.0005 translate <0.17, 0.4, -0.17> }
  object { EmptyBottle scale 0.5 rotate <0, 90, 0> translate <-0.05, 0.4, 0> }
  rotate <0, -70, 0> translate <0.85, 0, -1.1> }
object { FirePlace translate <0, 0, 0.5> }
object { FirePlaceFloor translate <0, 0, 0.5> }
object { FirePlaceInside translate <0, 0, 0.5> }
object { Grate scale 0.75 translate <0, -0.01, 0.5> }
object { RoundVase scale 0.00045 translate <0.125, 0.82, 0.4> }
object { RoundVase2 scale 0.00045 translate <0.25, 0.82, 0.4> }
object { Bowl scale 0.4 translate <0.5, 0.82, 0.4> }
object { HandPicture translate <0, 0.15, 0> scale 0.5 rotate <15, 0, 0> rotate <0, 20, 0> translate <-0.3, 0.82, 0.4> }
object { WallPicture translate <0, 1.5, 0.49> }
object { WallPicture2 translate <-2, 1.5, 0.89> }
union {
  object { Sideboard }
  object { MirrorBall scale 0.75 translate <-0.3, 0.41, 0.1> }
  object { FullRed scale 0.333 translate <0.23, 0.41, 0.1> }
  object { FullRed scale 0.333 rotate <0, 30, 0> translate <0.17, 0.41, 0.1> }
  object { FullWhite scale 0.333 translate <0.1, 0.41, 0.12> }
  translate <0, 0, -0.2> scale 1.5 translate <-2, 0, 0.8> }
object { WholeBookShelf translate <2.65, 0, 0.79> }

// wall
difference {
  union {
    object { RoundedBox(1.22, 0.1, 0.42, 0.005) translate <0, 0, 0.4> texture { Paintt } }
    object { RoundedBox(10, 0.1, 0.02, 0.005) translate <0, 0, 0.4> texture { Paintt } }
    object { RoundedBox(1.2, 4, 0.4, 0.005) translate <0, 0, 0.4> texture { Wallt } }
    plane { <0, 0, -1>, -0.4 texture { Wallt } } }
  object { Cube scale <0.15, 0.3, 0.2> }
  translate <0, 0, 0.5> }

// ceiling
plane { <0, -1, 0>, -3 pigment { color White } finish { ambient 0 } }

// floor
difference {
  plane { <0, 1, 0>, 0 }
  object { Cube scale <0.45, 0.02, 0.4> translate <0, 0, 0.5> }
  #if (pass = 1)
    pigment { color rgb <1, 0.25, 0.25> }
  #end
  #if (pass = 2)
    pigment {
      bumps
      color_map {
        [0 color rgb <1, 0.25, 0.25>]
        [1 color rgb 0.5*<1, 0.25, 0.25>] }
      scale 0.0001 }
  #end
  finish { ambient 0 }
  //normal { bumps 0.4 scale 0.0001 }
  photons { collect off } }

// ghost
union {
union {
difference {
  object { aikoghost_outer_ rotate <90, 0, 0> }
  object { aikoghost_inner_ }
  hollow
  no_shadow
  interior {
    media {
      emission 300
      method 2
      intervals 10
      aa_threshold 0.01
      density {
        granite
        color_map {
          [0 color rgb <0.8, 0.95, 1>]
          [0.2 color rgb 0.5*<0.8, 0.95, 1>]
          [1 color rgb 0.1*<0.8, 0.95, 1>] }
        scale 0.25 } } } }
object {
  big_hair_ rotate <90, 0, 0>
  hollow
  no_shadow
  interior {
    media {
      emission 400
      method 2
      intervals 10
      aa_threshold 0.01
      density {
        granite
          color_map {
            [0 color rgb <0.8, 0.95, 1>]
            [0.2 color rgb 0.5*<0.8, 0.95, 1>]
            [1 color Black] }
          scale 0.4 } } } }
  scale 2.2 rotate <0, 180, 0> rotate <180, 0, 0> }
  object {
    HandPicture scale 0.5
      rotate <37, 0, 0> rotate <0, 180, 0> translate <-0.0875,1.17,-0.31> }
  rotate <0, -70, 0>
  translate ghost_loc }

