

/*_______________________________________________________________________________________________________*\

FILE NAME: Grassland_Blueground.pov
CREATED BY: Isaac Kulka, Copyright 12-28-2006
NOTES: Created for the Internet Raytracing Competition's Nov-Dec 2006 Contest: 'Complexity' (www.irtc.org)

DESCRIPTION: This file is used to create a distant background for the grassland scene consisting only of a height-field 
             and tree, all tinted blue.  This image is used as a background for Grassland_Mesoground.pov

\*_______________________________________________________________________________________________________*/




#include "Make_Sloped_Height_Field.inc"
#include "Make_Scatter_Tree.inc"





//Use these values to enable or time-consuming disable effects from the scene
#local use_filter = false;

#local render_trees = true; //scatter trees

 
 
 
 
 
 
 
 
global_settings
{
  max_trace_level 100
}







background{rgb 0}



light_source
{
  <100,500,-1000>
  
  rgb 1.0

}     



#local R1 = seed(242332);







/*
  //                                               \\
 //------------ FOREGROUND HEIGHT_FIELD ------------\\
//                                                   \\



#local hill_func=
function
{
  pattern
  {
    granite 
    turbulence 0.15
    
    scale 900
    translate y*7875 
    
    //turbulence 0.1  
  
    //scale 900
    //translate y*7874
  }
}



#local HF_X_START = -50;
#local HF_Z_START = 0;
#local HF_Y_START = 0;

#local HF_X_END = 50;
#local HF_Z_END = 100;
#local HF_Y_END = HF_Y_START;

    
    
    
#local HF_START = <HF_X_START, HF_Y_START, HF_Z_START>;
#local HF_END = <HF_X_END, HF_Y_END, HF_Z_END>;

#local HF_HEIGHT = 25;
#local HF_STEP = 3;
#local HF_SMOOTH = true;

#local HF_SLOPED_PERCENT = 0.85;

#local HF_PRIMARY_FIELD = false;

#local HF_TEXTURE = 
  texture
  {
    pigment{ rgb<0.55,0.70,0.23> }
    finish{ambient 0 diffuse 0.7 specular 0.5 roughness 0.2 crand 0.1}
  }



Make_Sloped_Height_Field(HF_START, HF_END, HF_HEIGHT, HF_STEP, HF_SMOOTH, HF_SLOPED_PERCENT, HF_PRIMARY_FIELD, HF_TEXTURE, hill_func) 









  //                                               \\
 //------------ MESOGROUND HEIGHT_FIELD ------------\\
//                                                   \\



#local hill_func_2=
function
{
  pattern
  {
    granite 
    turbulence 0.10
    
    scale 1300
    translate y*666666 

  }
}



#local HF_X_START = -160;
#local HF_Z_START = 110;
#local HF_Y_START = 16;

#local HF_X_END = -1*HF_X_START;
#local HF_Z_END = 250;
#local HF_Y_END = HF_Y_START;

    
    
    
#local HF_START = <HF_X_START, HF_Y_START, HF_Z_START>;
#local HF_END = <HF_X_END, HF_Y_END, HF_Z_END>;

#local HF_HEIGHT = 90;
#local HF_STEP = 4;
#local HF_SMOOTH = false;

#local HF_SLOPED_PERCENT = 0.60;

#local HF_PRIMARY_FIELD = false;

#local HF_TEXTURE = 
  texture
  {
    pigment{ rgb<0.55,0.70,0.23> }
    finish{ambient 0.2 diffuse 0.7 specular 0.5 roughness 0.2 crand 0.1}
  }



Make_Sloped_Height_Field(HF_START, HF_END, HF_HEIGHT, HF_STEP, HF_SMOOTH, HF_SLOPED_PERCENT, HF_PRIMARY_FIELD, HF_TEXTURE, hill_func_2) 
*/         
                            
                            
                            
                            
                            
                            
                            
                            
                            
                            
                            
                            
                            
                            

  //                                               \\
 //------------ BACKGROUND HEIGHT_FIELD ------------\\
//                                                   \\

//this hieght field is created using a function which will define not only the height-field's shape, but also where the trees are planted on it.

#local hill_func_3=
function
{
  pattern
  {
    granite 
    turbulence 0.04
    
    scale 2000
    translate y*79875

  }
}



#local HF_X_START = -250;
#local HF_Z_START = 260;
#local HF_Y_START = 64;

#local HF_X_END = -1*HF_X_START;
#local HF_Z_END = 450;
#local HF_Y_END = HF_Y_START;

    
    
    
#local HF_START = <HF_X_START, HF_Y_START, HF_Z_START>;
#local HF_END = <HF_X_END, HF_Y_END, HF_Z_END>;

#local HF_HEIGHT = 125;
#local HF_STEP = 4;
#local HF_SMOOTH = false;

#local HF_SLOPED_PERCENT = 0.70;

#local HF_PRIMARY_FIELD = true;

#local HF_TEXTURE = 
  texture
  {
    pigment{ rgb<0.35,0.55,0.65> }
    finish{ambient 0.5 diffuse 1.0 specular 0.35 roughness 0.2 crand 0.1}
  }



Make_Sloped_Height_Field(HF_START, HF_END, HF_HEIGHT, HF_STEP, HF_SMOOTH, HF_SLOPED_PERCENT, HF_PRIMARY_FIELD, HF_TEXTURE, hill_func_3) 











  //                                                  \\
 //---------- POPULATE HEIGHT FIELD -------------------\\
//                                                      \\

//this macro is used to add tree to the landscape of this scene

#macro Populate_Height_Field(DIST_FUNC, ARRAY, ARRAY_MAX, X_MAX, Z_MAX, X_START, Z_START, STEP, PROB, WIND_BEND, Y_WIND_ROT, FUNC_TYPE)
  
  #declare CNT = 0;
  
  #local Z = Z_START;
  #local X = X_START;

  
  #while (Z < Z_MAX)
    
    #local rx = rand(R1)*STEP + X;
    #local rz = rand(R1)*STEP + Z;
    #local ry = P_FUNC(rx,rz,0)*HF_HEIGHT + HF_Y_START; //set the y-value to the y-coordinate of the height_field at <rx,rz>
  
      

    
    //MAKE TREES
    #local bonus = P_FUNC(rx,rz,0)*0.50;
    
    #if(rand(R1) < 0.25)

      object{SCATTER_MAPLE_ARRAY[floor(rand(R1)*SCATTER_MAPLE_MAX)] scale (rand(R1)*0.15 + 0.6) rotate x*rand(R1)*7 rotate y*rand(R1)*360 translate<rx,ry,rz>}
      
      #declare CNT = CNT + 1;
   
    #end   
   
    
    #local X = X + STEP;
    #if(X >= X_MAX)
      #local X_MAX = min(X_MAX + STEP, HF_X_END);
      #local X = -X_MAX;
      #local Z = Z + STEP;
    #end
  #end  
    
    
#end //Populate_Height_Field 



   



#declare AVE_SCATTER_TRI = 0;
#declare SCATTER_CNT = 0;
#declare UNIQUE_SCATTER_TRI = 0;
   
   
   
      
      
      
      
   
  //                                               \\
 //--------------- MAKE TREES ----------------------\\
//                                                   \\

//These trees are created by macros in Make_Scatter_Tree.inc 
//The variables below are explained in greater detail in that file

#if(render_trees)

  //MAPLE TREES
  #local SCATTER_TREE_CNT = 1;
  #local VARIETY = 0.2;
  #local TREE_TYPE = 0;
  
  #local LEVEL_MAX = 4;
  #local HEIGHT = 15;
  #local THICKNESS = 0.040;
  
  #local SMOOTHNESS = 0.10;
  #local NORM = <0,1,0>;
  
  #local CURVINESS = 0.09;
  #local LEAFINESS = 0.20;
  #local LEAF_LENGTH = 0.40;
  
  #local COLOR_1 = rgb<0.25,0.70,0.70>;
  #local COLOR_2 = rgb<0.15,0.75,0.60>;
  #local C_VAR = 0.10;
  
  #local LUSTER = 0.30;
  
  #local FILTER = 0.60;
  #if(!use_filter)
    #local FILTER = 0.00;
  #end
  
  #local AMBIENT = 0.20;
  
  #local SEED = 6765;
  
  Populate_Scatter_Tree_Array(SCATTER_TREE_CNT, VARIETY, TREE_TYPE, LEVEL_MAX, HEIGHT, THICKNESS, SMOOTHNESS, NORM, CURVINESS, LEAFINESS, LEAF_LENGTH, COLOR_1, COLOR_2, C_VAR, FILTER, LUSTER, AMBIENT, SEED)
  
  
  
   
  #local tree_func = 
  function
  {
    pattern
    {
      granite 
      turbulence 0.15  
    
      scale 500
      translate y*8755
    }
  } 
  
  
  #local ARRAY_MAX = 1;  
  #local ARRAY = 1;
  
  
  #local X_MAX = 200;
  #local Z_MAX = HF_Z_END;
  #local X_START = -X_MAX;
  #local Z_START = HF_Z_START;
  
  #local STEP = 3.0;
  
  #local PROB = 0.70;
  
  #local WIND_BEND = 0;
  #local Y_WIND_ROT = 0;
  
  #local FUNC_TYPE = 2;
    
  Populate_Height_Field(tree_func, ARRAY, ARRAY_MAX, X_MAX, Z_MAX, X_START, Z_START, STEP, PROB, WIND_BEND, Y_WIND_ROT, FUNC_TYPE)
  
  #debug concat("\n************ TOTAL SCATTER TREES = ", str(CNT,0,0), " ************\n\n")
  #declare SCATTER_CNT = CNT;

#end    
        
    





  //                                               \\
 //----- Background Image and Camera Location ------\\
//                                                   \\  


//This macro was copied from the PovRay Cyclopedia at: http://www.spiritone.com/~english/cyclopedia/background.html
//downloaded 3-24-06
//John Van Sickle was mentioned in the credits, though it wasn't made exactly clear who created this code.

#declare CamLoc =  <0.00,10.00,-10.00>; //where the camera's location is
#declare CamLook = <0.00,11.00, 10.00>; // Camera's Look_at 

#declare cam_z = 1; //the amount of camera zoom you want
#declare back_dist = 6000; // how far away the background is
#declare cam_a = 4/3; // camera aspect ratio
#declare cam_s = <0,1,0>; // camera sky vector
#declare cam_d = vnormalize(CamLook-CamLoc); // camera direction vector
#declare cam_r = vnormalize(vcross(cam_s,cam_d)); // camera right vector
#declare cam_u = vnormalize(vcross(cam_d,cam_r)); // camera up vector
#declare cam_dir = cam_d * cam_z; // direction vector scaled
#declare cam_right = cam_r * cam_a; // right vector scaled

#declare fz = vlength(cam_dir);
#declare fx = vlength(cam_right)/2;
#declare fy = vlength(cam_u)/2; 

#macro OrientZ(p1,p2,cs)
  #local nz = vnormalize(p2-p1);
  #local nx = vnormalize(vcross(cs,nz)); 
  #local ny = vcross(nz,nx);
  matrix <nx.x,nx.y,nx.z, ny.x,ny.y,ny.z, nz.x,nz.y,nz.z, p1.x,p1.y,p1.z>          
#end


camera 
{
  location CamLoc
  up cam_u
  right cam_r * cam_a
  direction (cam_d * cam_z) 
}


light_group //insures that the Background does not interact with any light sources
{
 
  
  
  box 
  { 
    <0,0,0> 
    <1,1,0.1>
    pigment 
    { 
      image_map 
      {   
        jpeg "Clouds.jpg"        
      } 
    }
    
    finish 
    { 
      ambient 1.0
    }
    
    translate <-0.5,-0.5,0>
    scale 2*<fx,fy,0.5>
    translate fz*z
    scale back_dist
    OrientZ(CamLoc,CamLook,cam_s)
  }
  
  global_lights false
}





