

/*_______________________________________________________________________________________________________*\

FILE NAME: Grassland_Mesoground.pov
CREATED BY: Isaac Kulka, Copyright 12-28-2006
NOTES: Created for the Internet Raytracing Competition's Nov-Dec 2006 Contest: 'Complexity' (www.irtc.org)

DESCRIPTION: This files is used to generate a mid-level background between the distant "Blueground" and the closer 
             "Foreground".  This "Mesoground" is covered with grass, trees and other plants found also in the Foreground.
             This image is used as a background for Foreground.pov
\*_______________________________________________________________________________________________________*/


#include "Make_Sloped_Height_Field.inc"
#include "Make_Grass.inc"
#include "Make_Seeded_Grass.inc"
#include "Make_Flower_Susan.inc"
#include "Make_Flower_Stalk.inc"
#include "Make_Sumac.inc"
#include "Make_Sloped_Height_Field.inc"
#include "Make_Scatter_Tree.inc"





//Use these values to enable or disable time-consuming effects from the scene
#local use_area_lights = false;

#local use_radiosity   = false;

#local use_filter = false;
              
              
#local render_grass        = true; //main grass
#local render_tuff_grass   = true; //clump grass
#local render_susans       = true; //black-eyed susans
#local render_flower_stalk = true; //purple flower stalks
#local render_trees        = true; //scatter trees
#local render_sumac        = true; //sumac
                           
 
 

 
 
 
global_settings
{
  max_trace_level 100

  
  #if(use_radiosity)
    radiosity
    {
  
       
       count 70
       nearest_count 3
       error_bound 3.5
       recursion_limit 2 
       
        
       pretrace_start .08
       pretrace_end   .005
       
       max_sample 0.75                    
                           
       low_error_factor 0.25
       minimum_reuse 0.015
       
       adc_bailout 0.1
       brightness 1.00 
       gray_threshold 0.00 
       
       
       
       always_sample off
       media off          
       normal off  
    }
  #end
  

  
}


background{rgb 0}



light_source
{
  <100,500,-1000>
  
  rgb <1.0, 0.8, 0.0>*0.30 + <1.0, 1.0, 1.0>*0.70

  
  
  #if(use_area_lights)
    area_light <-90, 90, 0>, <90 -90, 50>, 2, 2
    jitter
  #end

}     







#local R1 = seed(242332);

















/*
  //                                               \\
 //------------ FOREGROUND HEIGHT_FIELD ------------\\
//                                                   \\



#local hill_func=
function
{
  pattern
  {
    granite 
    turbulence 0.15
    
    scale 900
    translate y*7875 
    
    //turbulence 0.1  
  
    //scale 900
    //translate y*7874
  }
}



#local HF_X_START = -50;
#local HF_Z_START = 0;
#local HF_Y_START = 0;

#local HF_X_END = 50;
#local HF_Z_END = 100;
#local HF_Y_END = HF_Y_START;

    
    
    
#local HF_START = <HF_X_START, HF_Y_START, HF_Z_START>;
#local HF_END = <HF_X_END, HF_Y_END, HF_Z_END>;

#local HF_HEIGHT = 25;
#local HF_STEP = 3;
#local HF_SMOOTH = false;

#local HF_SLOPED_PERCENT = 0.85;

#local HF_PRIMARY_FIELD = false;

#local HF_TEXTURE = 
  texture
  {
    pigment{ rgb<0.55,0.70,0.23> }
    finish{ambient 0 diffuse 0.7 specular 0.5 roughness 0.2 crand 0.1}
  }



Make_Sloped_Height_Field(HF_START, HF_END, HF_HEIGHT, HF_STEP, HF_SMOOTH, HF_SLOPED_PERCENT, HF_PRIMARY_FIELD, HF_TEXTURE, hill_func) 

*/







  //                                               \\
 //------------ MESOGROUND HEIGHT_FIELD ------------\\
//                                                   \\

//this hieght field is created using a function which will define not only the height-field's shape, but also where the plants are planted on it.

#local hill_func_2=
function
{
  pattern
  {
    granite 
    turbulence 0.10
    
    scale 1300
    translate y*666666

  }
}



#local HF_X_START = -160;
#local HF_Z_START = 110;
#local HF_Y_START = 16;//16;

#local HF_X_END = -1*HF_X_START;
#local HF_Z_END = 250;
#local HF_Y_END = HF_Y_START;

    
    
    
#local HF_START = <HF_X_START, HF_Y_START, HF_Z_START>;
#local HF_END = <HF_X_END, HF_Y_END, HF_Z_END>;

#local HF_HEIGHT = 90;
#local HF_STEP = 3;
#local HF_SMOOTH = false;

#local HF_SLOPED_PERCENT = 0.60;

#local HF_PRIMARY_FIELD = true;

#local HF_TEXTURE = 
  texture
  {
    pigment{ rgb<0.55,0.70,0.23> }
    finish{ambient 0.2 diffuse 0.7 specular 0.5 roughness 0.2 crand 0.1}
  }



Make_Sloped_Height_Field(HF_START, HF_END, HF_HEIGHT, HF_STEP, HF_SMOOTH, HF_SLOPED_PERCENT, HF_PRIMARY_FIELD, HF_TEXTURE, hill_func_2) 








  //                                               \\
 //------------------ WIND FUNCTIONS ---------------\\
//                                                   \\
#local x_wind_func = 
function
{
  pattern
  {
    agate 
      octaves 9
      lambda 2
      omega 0.1
      turbulence 5
      
    scale 50
    rotate y*-100
    translate y*483932
  }
}


#local y_wind_func = 
function
{
  pattern
  {
    agate 
      octaves 9
      lambda 2
      omega 0.1
      agate_turb 2
  
    scale 100 //150
    rotate y*120
    translate y*32
  }
}

#local x_wind_bend_max = 55; //will actually be rotated around the z-axis (you know, it "bends" in the x direction)
#local x_wind_bend_min = 5;
#local y_wind_bend = 10;
#local min_grass_bend = 0;









  //                                                  \\
 //---------- POPULATE HEIGHT FIELD -------------------\\
//                                                      \\

//This macro is responsible for plants the various trees, grasses and other plants on the height-field in this scene

#macro Populate_Height_Field(DIST_FUNC, ARRAY, ARRAY_MAX, X_MAX, Z_MAX, X_START, Z_START, STEP, PROB, WIND_BEND, Y_WIND_ROT, FUNC_TYPE)
  
  #declare CNT = 0;
  
  #local Z = Z_START;
  #local X = X_START;
  #local INV_PROB = 1-PROB;

  
  #while (Z < Z_MAX)
    
    #local rx = rand(R1)*STEP + X;
    #local rz = rand(R1)*STEP + Z;
    
    #local ry = 2;
    #if(Z >= 0)
      #local ry = P_FUNC(rx,rz,0)*HF_HEIGHT + HF_Y_START; //set the y-value to the y-coordinate of the height_field at <rx,rz>
    #end
      
    #local prob = DIST_FUNC(rx,0,rz) - INV_PROB;
    
    
    //PLANT ANYTHING BUT TREES AND GRASS
    #if(Z < Z_MAX*0.88 | (X > -40 & X < 100)) //cheep hack for this particular landscape
      #if(rand(R1) < prob & FUNC_TYPE = 0) 
        object
        {
          ARRAY[floor(rand(R1)*ARRAY_MAX)] 
          
          scale rand(R1)*0.25 + 0.75 
          #if(Z < 0) scale 1.25 #end
           
          rotate z*((rand(R1)*0.15 + 0.85)*x_wind_func(rx,0,rz)*WIND_BEND) 
          rotate y*(y_wind_func(rx,0,ry)*y_wind_bend)
          rotate y*(rand(R1)*2-1)*Y_WIND_ROT
          
          translate<rx,ry,rz>
        }
    
        
        #declare CNT = CNT + 1;
      #end
    #end
    
    
    //PLANT GRASS
    #if(FUNC_TYPE = 1)    
      
      #local grass_val = DIST_FUNC(rx,0,rz);
      #local green_chance = rand(R1);
      
      #if(Z < Z_MAX*0.88 | (X > -40 & X < 100)) //cheep hack for this particular landscape
        object
        {
           
          #if(grass_val < 0.40 | green_chance < 0.10) //green grass
            GRASS_ARRAY_0[floor(rand(R1)*GRASS_MAX_0)]
          #end
          
          #if(grass_val >= 0.40 & grass_val < 0.50 & green_chance >= 0.10) //randomly pick between green and brown
            #if(rand(R1) < 0.50)
              GRASS_ARRAY_0[floor(rand(R1)*GRASS_MAX_0)]
            #else
              GRASS_ARRAY_1[floor(rand(R1)*GRASS_MAX_1)]
            #end
          #end
          
          #if(grass_val >= 0.50 & green_chance >= 0.10) //brown grass
            GRASS_ARRAY_1[floor(rand(R1)*GRASS_MAX_1)]  
          #end
          
          scale rand(R1)*0.25 + 0.75 
          #if(Z < 0) scale 1.25 #end
          
          rotate z*((rand(R1)*0.15 + 0.85)*x_wind_func(rx,0,rz)*WIND_BEND + min_grass_bend) 
          rotate y*(y_wind_func(rx,0,ry)*y_wind_bend)
          rotate y*(rand(R1)*2-1)*Y_WIND_ROT
          
          translate<rx,ry,rz>
        }
     
        #declare CNT = CNT + 1;
      #end
    #end //make_grass 
    
    
    
    //PLANT TREES
    #if(FUNC_TYPE = 2)
      #local bonus = (Z-Z_START)/(Z_MAX-Z_START);
      #if((rand(R1) < bonus*0.25) | (rand(R1) < 0.05))
      
      
        #if(DIST_FUNC(rx,rz,0) < 0.50)
          
          object{SCATTER_MAPLE_ARRAY[floor(rand(R1)*SCATTER_MAPLE_MAX)] scale (rand(R1)*0.20 + 0.8) rotate x*rand(R1)*12 rotate y*rand(R1)*360 translate<rx,ry,rz>}
          #declare CNT = CNT + 1;
        
        #else
          
          object{SCATTER_BIRCH_ARRAY[floor(rand(R1)*SCATTER_BIRCH_MAX)] scale (rand(R1)*0.20 + 0.8) rotate x*rand(R1)*12 rotate y*rand(R1)*360 translate<rx,ry,rz>}
          #declare CNT = CNT + 1;
        
        #end
      
      #end   
    #end
    
    
    
    #local X = X + STEP;
    #if(X >= X_MAX)
      #local X_MAX = min(X_MAX + STEP, HF_X_END);
      #local X = -X_MAX;
      #local Z = Z + STEP;
    #end
  #end
  
#end //Populate_Height_Field 



   





   
   
   
      
      
      
      
   
  //                                               \\
 //--------------- MAKE TREES ----------------------\\
//                                                   \\

//The trees are generated using the Make_Scatter_Tree.inc file.  The values listed below are described in greater detail in that file.

#if(render_trees)

  //MAPLE TREES
  #local SCATTER_TREE_CNT = 10;
  #local VARIETY = 0.2;
  #local TREE_TYPE = 0;
  
  #local LEVEL_MAX = 4;
  #local HEIGHT = 15.0;
  #local THICKNESS = 0.040;
  
  #local SMOOTHNESS = 0.10;
  #local NORM = <0,1,0>;
  
  #local CURVINESS = 0.90;
  #local LEAFINESS = 0.30;
  #local LEAF_LENGTH = 0.40;
  
  #local COLOR_1 = rgb<0.1,0.90,0>;
  #local COLOR_2 = rgb<0.2,0.70,0>;
  #local C_VAR = 0.15;
  
  #local LUSTER = 0.30;
  
  #local FILTER = 0.40;
  #if(!use_filter)
    #local FILTER = 0.00;
  #end
  
  #local AMBIENT = 0.00;
  #if(use_radiosity)
    #local AMBIENT = 0.00;
  #end
  
  #local SEED = 6765;
  
  Populate_Scatter_Tree_Array(SCATTER_TREE_CNT, VARIETY, TREE_TYPE, LEVEL_MAX, HEIGHT, THICKNESS, SMOOTHNESS, NORM, CURVINESS, LEAFINESS, LEAF_LENGTH, COLOR_1, COLOR_2, C_VAR, FILTER, LUSTER, AMBIENT, SEED)
  
  
  
  
  //BIRCH TREES       
  #local TREE_TYPE = 1;
  #local THICKNESS = 0.032;
  #local CURVINESS = 0.20;
  #local SEED = 2343;
  #local LEAFINESS = 0.10;
  #local COLOR_1 = rgb<0.1,0.90,0>;
  #local COLOR_2 = rgb<0.2,0.70,0>;
  #local C_VAR = 0.15;
  
  Populate_Scatter_Tree_Array(SCATTER_TREE_CNT, VARIETY, TREE_TYPE, LEVEL_MAX, HEIGHT, THICKNESS, SMOOTHNESS, NORM, CURVINESS, LEAFINESS, LEAF_LENGTH, COLOR_1, COLOR_2, C_VAR, FILTER, LUSTER, AMBIENT, SEED)
  
       
  
  
  //Add the trees to the landscape 
  #local tree_func = 
  function
  {
    pattern
    {
      granite 
      turbulence 0.15  
    
      scale 500
      translate y*9043//454567
    }
  } 
  
  
  #local maple_cyl = cylinder{<0,0,0> <0,10,0> 0.5 pigment{rgb<1,0,0>}}
  #local birch_cyl = cylinder{<0,0,0> <0,10,0> 0.5 pigment{rgb<0,0,1>}}
  
  #local ARRAY_MAX = 1;  
  #local ARRAY = 1;
  
  
  #local X_MAX = 90;
  #local Z_MAX = HF_Z_END;
  #local X_START = -X_MAX;
  #local Z_START = HF_Z_START;
  
  #local STEP = 5; //3.5
  
  #local PROB = 0.70;
  
  #local WIND_BEND = 0;
  #local Y_WIND_ROT = 0;
  
  #local FUNC_TYPE = 2;
    
  Populate_Height_Field(tree_func, ARRAY, ARRAY_MAX, X_MAX, Z_MAX, X_START, Z_START, STEP, PROB, WIND_BEND, Y_WIND_ROT, FUNC_TYPE)
  
  #debug concat("\n************ TOTAL SCATTER TREES (BIRCHES AND MAPLES) = ", str(CNT,0,0), " ************\n\n")

#end    
    
    
    
    










  //                                               \\
 //------------------ MAIN GRASS -------------------\\
//                                                   \\

//The grass is generated using the Make_Grass.inc file.  The values listed below are described in greater detail in that file.

#if(render_grass)

  #debug "\n\n************ PARSING MAIN GRASS ************\n\n"
  #local SEED = 6765;
  #local R1 = seed(SEED);
  
  
  #local GRASS_CNT = 1;
  #local VARIETY = 0.5;
  
  #local HEIGHT = 2.50; //5.00
  #local THICKNESS = 0.10; //0.023 
  
  #local SMOOTHNESS = 0.40;
  #local SEED = 753;
  
  #local RAD_MIN = 0.40;
  #local RAD_MAX = 0.70;
  
  #local X_OFFSET = 0;
  #local Z_OFFSET = 0;
  #local X_BEND = -pi/3;
  #local TWIST = 0;
  
  #local STEM = 0.05;
  #local CENTER = 0.1;
  #local MIDDLE = 0.7;
  
  #local COLOR_1 = rgb<0.40,0.85,0.25>; //green
  #local COLOR_2 = rgb<0.65,0.88,0.35>; //green
  #local COLOR_VAR = 0.50;
  
  #local FILTER = 0.35; //0.35
    #if(!use_filter) #local FILTER = 0; #end
  #local LUSTER = 0.50;//0.435;
  #local AMBIENT = 0.0;
    #if(use_radiosity) #local AMBIENT = 0; #end
  #local WRINKLINESS = 0.00;
  
  #local ARRAY_NUM = 0;
  
  //make green grass
  Populate_Grass_Array(GRASS_CNT, VARIETY, HEIGHT, THICKNESS, SMOOTHNESS, SEED, RAD_MIN, RAD_MAX, X_OFFSET, Z_OFFSET, X_BEND, TWIST, STEM,CENTER,MIDDLE, COLOR_1, COLOR_2, COLOR_VAR, LUSTER, AMBIENT, FILTER, WRINKLINESS, ARRAY_NUM)
  
    
    
    
  //make brown grass
  #local ARRAY_NUM = 1;
  #local SEED = 2439;
  #local COLOR_1 = rgb<0.72,0.82,0.35>; //brown
  #local COLOR_2 = rgb<0.80,0.85,0.45>; //brown
                      
  Populate_Grass_Array(GRASS_CNT, VARIETY, HEIGHT, THICKNESS, SMOOTHNESS, SEED, RAD_MIN, RAD_MAX, X_OFFSET, Z_OFFSET, X_BEND, TWIST, STEM,CENTER,MIDDLE, COLOR_1, COLOR_2, COLOR_VAR, LUSTER, AMBIENT, FILTER, WRINKLINESS, ARRAY_NUM)
    
  
  
  
  
  
  
   
  //populate height-field with green and brown grass

  #local grass_func = 
  function
  {
    pattern
    {
      granite 
      turbulence 0.2  
    
      scale 100
      translate y*45489
    }
  } 
  
    
  #local ARRAY = GRASS_ARRAY_0;
  #local ARRAY_MAX = GRASS_MAX_0;
  
  #local X_MAX = 90;
  #local Z_MAX = HF_Z_END;
  #local X_START = -X_MAX;
  #local Z_START = HF_Z_START;
  
  #local STEP = 0.50;
  
  #local PROB = 0.35; 
  
  #local WIND_BEND = 10;
  #local Y_WIND_ROT = 8;//2
  
  #local FUNC_TYPE = 1;
    
  Populate_Height_Field(grass_func, ARRAY, ARRAY_MAX, X_MAX, Z_MAX, X_START, Z_START, STEP, PROB, WIND_BEND, Y_WIND_ROT, FUNC_TYPE)
  
  #debug concat("\n************ TOTAL BLADES OF GRASS = ", str(CNT,0,0), " ************\n\n")

#end









  //                                    \\
 //----------------- SUMAC --------------\\
//                                        \\

//The sumac plants are generated using the Make_Sumac.inc file.  The values listed below are described in greater detail in that file.

#if(render_sumac)

  #debug "\n\n************ PARSING SUMAC ************\n\n"
  
  #local sumac_cnt = 0; 
  #local SEED = 5778;
  #local R1 = seed(SEED);
    
    

  #local RADIUS = 0.03;
  #local SMOOTHNESS = 0.90;
  #local AMBIENT = 0.00;
    #if(use_radiosity) #local AMBIENT = 0.00; #end
  #local LUSTER = 0.00;
  
  Make_Sumac_Berry(RADIUS, SMOOTHNESS, AMBIENT, LUSTER)
  
  
  
  
  #local LEAF_CNT = 1;
  #local VARIETY = 0.1;
  #local LEAF_HEIGHT = 1.00;
  #local LEAF_THICKNESS = 0.33;
  #local BEND = pi/8;
  #local RUFFLE = 0.50;
  #local SMOOTHNESS = 0.60;
  #local INNER_COLOR = rgb<0.0,0.6,0>;
  #local OUTER_COLOR = rgb<0.0,0.7,0>;
  #local C_VAR = 0.2;
  
  #local FILTER = 0.35;
    #if(!use_filter) #local FILTER = 0.00; #end
  
  #local LUSTER = 0.50;
  
  #local AMBIENT = 0.00;
    #if(use_radiosity) #local AMBIENT = 0.00; #end
  
  #local SEED = 3437;
  
  Populate_Sumac_Leaf_Array(LEAF_CNT, VARIETY, LEAF_HEIGHT, LEAF_THICKNESS, BEND, RUFFLE, SMOOTHNESS, INNER_COLOR, OUTER_COLOR, C_VAR, FILTER, LUSTER, AMBIENT, SEED)
  
  
  
  
  
  #local SUMAC_CNT = 1;
  #local VARIETY = 0.2;
  #local HEIGHT = 3.50;
  #local THICKNESS = 0.02;
  #local MAX_BEND = -pi/8;
  #local SMOOTHNESS = 0.60;
  #local CURVINESS = 0.60;
  #local BERRY_RADIUS = RADIUS; //see Make_Sumac_Berry above
  #local LEAF_WIDTH = LEAF_HEIGHT*LEAF_THICKNESS;
  #local SEED = 6764;
  
  
  Populate_Sumac_Array(SUMAC_CNT, VARIETY, HEIGHT, THICKNESS, MAX_BEND, SMOOTHNESS, CURVINESS, BERRY_RADIUS, LEAF_WIDTH, SEED)    
      



 //Add Sumac to Landscape
  
  #local Sumac_Func = 
  function
  {
    pattern
    {
      granite 
      turbulence 0.4  
    
      scale 200
      translate y*7895
    }
  }
  
  #local ARRAY = SUMAC_ARRAY;
  #local ARRAY_MAX = SUMAC_MAX;
  
  #local X_MAX = 90;
  #local Z_MAX = HF_Z_END;
  #local X_START = -X_MAX;
  #local Z_START = HF_Z_START;
  
  #local STEP = 2.5;
  
  #local PROB = 0.75;//0.40; 
  
  #local WIND_BEND = 25;
  #local Y_WIND_ROT = 360;
  
  #local FUNC_TYPE = 0;
    
  Populate_Height_Field(Sumac_Func, ARRAY, ARRAY_MAX, X_MAX, Z_MAX, X_START, Z_START, STEP, PROB, WIND_BEND, Y_WIND_ROT, FUNC_TYPE)

 
  #debug concat("\n************ TOTAL SUMAC PLANTS = ", str(CNT,0,0), " ************\n\n")
  
#end     

    
    











  //                                               \\
 //------------------ CLUSTER GRASS ----------------\\
//                                                   \\

//The clusters of grass are generated using the Make_Grass.inc file.  The values listed below are described in greater detail in that file.

#if(render_tuff_grass)

  #debug "\n\n************ PARSING CLUMP GRASS ************\n\n"
  #local tuff_cnt = 0; 
  #local SEED = 6765;
  #local R1 = seed(SEED);
  
  
  //Thin Green Grass
  #local GRASS_CNT = 6;
  #local VARIETY = 0.3;
  
  #local HEIGHT = 2.50;
  #local THICKNESS = 0.040; //0.064 //the width of the blade will equal the HEIGHT times this number
  
  #local SMOOTHNESS = 0.50; //0.75
  #local SEED = 68865;
  
  #local RAD_MIN = 0.20;
  #local RAD_MAX = 0.40;
  
  #local X_OFFSET = 0.1;
  #local Z_OFFSET = 0.1;
  #local X_BEND = pi/4;
  #local TWIST = 2*pi;
  
  #local STEM = 0.1;
  #local CENTER = 0.2;
  #local MIDDLE = 0.7;
  
  #local COLOR_1 = rgb<0.40,0.80,0.30>; //green
  #local COLOR_2 = rgb<0.65,0.82,0.40>;
  #local COLOR_VAR = 0.75;//1.00
  
  #local FILTER = 0.30;//0.35;
    #if(!use_filter) #local FILTER = 0; #end
  #local LUSTER = 0.3;//0.40
  #local AMBIENT = 0.00;
    #if(use_radiosity) #local AMBIENT = 0; #end
  #local WRINKLINESS = 0.00;
  #local ARRAY_NUM = 2;
    
  Populate_Grass_Array(GRASS_CNT, VARIETY, HEIGHT, THICKNESS, SMOOTHNESS, SEED, RAD_MIN, RAD_MAX, X_OFFSET, Z_OFFSET, X_BEND, TWIST, STEM,CENTER,MIDDLE, COLOR_1, COLOR_2, COLOR_VAR, LUSTER, AMBIENT, FILTER, WRINKLINESS, ARRAY_NUM)
  
  
  //Thin Brown Grass
  #local SEED = 4547;
  
  #local COLOR_1 = rgb<0.89,0.78,0.45>; //brown
  #local COLOR_2 = rgb<0.94,0.80,0.55>; //brown
  
  #local ARRAY_NUM = 3;
    
  Populate_Grass_Array(GRASS_CNT, VARIETY, HEIGHT, THICKNESS, SMOOTHNESS, SEED, RAD_MIN, RAD_MAX, X_OFFSET, Z_OFFSET, X_BEND, TWIST, STEM,CENTER,MIDDLE, COLOR_1, COLOR_2, COLOR_VAR, LUSTER, AMBIENT, FILTER, WRINKLINESS, ARRAY_NUM)

  
  
  
  
  //wide grass
  #local ARRAY_NUM = 4;
  
  #local VARIETY = 0.20;
  
  #local GRASS_CNT = 5;
  #local HEIGHT = 2.50;
  #local THICKNESS = 0.080;
  #local TWIST = pi*2;
  #local X_BEND = pi*0.75;
  
  #local SEED = 3453;
  #local COLOR_1 = rgb<0.20,0.95,0.25>; //green
  #local COLOR_2 = rgb<0.65,1.00,0.35>; //green
                      
  Populate_Grass_Array(GRASS_CNT, VARIETY, HEIGHT, THICKNESS, SMOOTHNESS, SEED, RAD_MIN, RAD_MAX, X_OFFSET, Z_OFFSET, X_BEND, TWIST, STEM,CENTER,MIDDLE, COLOR_1, COLOR_2, COLOR_VAR, LUSTER, AMBIENT, FILTER, WRINKLINESS, ARRAY_NUM)

  

  
  
  //Make the clusters
  #local THIN_RADIUS = 0.5;
  #local WIDE_RADIUS = 0.5;
  #local THIN_GRASS_CNT = 50;
  #local WIDE_GRASS_CNT = 25;
  #local MAX_BEND = 30;
  #local SEED = 1235;                       
  
  Make_Grass_Cluster(THIN_RADIUS, WIDE_RADIUS, THIN_GRASS_CNT, WIDE_GRASS_CNT, MAX_BEND, SEED)
  
 
 
 
 
  
  //populate Height-Field with Cluster Grass 
  #local grass_cluster_func = 
  function
  {
    pattern
    {
      granite 
      turbulence 0.15  
    
      scale 200
      translate y*4548
      translate z*-10
    }
  } 
  
    
  #local ARRAY = GRASS_CLUSTER_ARRAY;
  #local ARRAY_MAX = GRASS_CLUSTER_MAX;
  
  #local X_MAX = 90;
  #local Z_MAX = HF_Z_END;
  #local X_START = -X_MAX;
  #local Z_START = HF_Z_START;
  
  #local STEP = 3;//2.0
  
  #local PROB = 0.85;
  
  #local WIND_BEND = 0;
  #local Y_WIND_ROT = 360;
  
  #local FUNC_TYPE = 0;
    
  Populate_Height_Field(grass_cluster_func, ARRAY, ARRAY_MAX, X_MAX, Z_MAX, X_START, Z_START, STEP, PROB, WIND_BEND, Y_WIND_ROT, FUNC_TYPE)

 
  #debug concat("\n************ TOTAL CLUSTERS OF GRASS = ", str(CNT,0,0), " ************\n")
  
#end





 
 
 
 
 
 
 

  //                                               \\
 //----------- BLACK EYED SUSAN FLOWERS ------------\\
//                                                   \\

//The Black-eyed susan flowers are generated using the Make_Flower_Susan.inc file.  The values listed below are described in greater detail in that file.

#if(render_susans)

  #debug "\n\n************ PARSING SUSANS ************\n\n"
  #local SEED = 4324;//6765;
  #local R1 = seed(SEED);
  
              
              
              
  //SUSAN HEAD
  #local RADIUS = 0.10;//0.20
  #local SMOOTHNESS = 0.65;
  #local COLOR = rgb<0.2,0.1,0.0>;
  #local FILTER = 0.30;
    #if(!use_filter) #local FILTER = 0; #end
  #local LUSTER = 0.1;
  #local AMBIENT = 0.0;
    #if(use_radiosity) #local AMBIENT = 0; #end
  
  Make_Susan_Head(RADIUS, SMOOTHNESS, COLOR, FILTER, LUSTER, AMBIENT) 
   
   
  
  
  //SUSAN PETAL 
  #local PETAL_CNT = 1;
  #local HEIGHT = 0.80;
  #local THICKNESS = 0.50;
  #local VARIENCE = 0.15;
  #local BEND = pi*0.25;
  #local RUFFLE = 0.25;//0.30
  #local SMOOTHNESS = 0.70;//0.90
  #local COLOR_1 = rgb<1.00,0.85,0.25>;//rgb<1.0,0.9,0.20>;
  #local COLOR_2 = rgb<0.95,0.72,0.12>;//rgb<0.9,0.7,0.0>;
  #local C_VAR = 0.9;
  #local FILTER = 0.20;//0.25
    #if(!use_filter) #local FILTER = 0; #end
  #local LUSTER = 0.4;
  #local AMBIENT = 0.0;//0.20
    #if(use_radiosity) #local AMBIENT = 0.00; #end
    
  #local SEED = 23423;
  
  Populate_Susan_Petal_Array(PETAL_CNT, HEIGHT, THICKNESS, VARIENCE, BEND, RUFFLE, SMOOTHNESS, COLOR_1, COLOR_2, C_VAR, FILTER, LUSTER, AMBIENT, SEED)
  
  
  
   
  #local FLOWER_CNT = 1; //12
  #local HEIGHT =3.85;//6
  #local RADIUS = 0.08;
  #local HEAD_RADIUS = 0.10;//0.20
  #local BEND = pi/10;//pi/8
  #local SMOOTHNESS = 0.75;
  #local PETALS = 5;
  #local SEED = 123;
  
  Populate_Susan_Array(FLOWER_CNT, HEIGHT, RADIUS, HEAD_RADIUS, BEND, SMOOTHNESS, PETALS, SEED)
                 
  
  
  
  //Add Yellow susans to Landscape
  
  #local flower_func = 
  function
  {
    pattern
    {
      agate 
      turbulence 0.2  
    
      scale 50
      translate y*7685
    }
  }
    
    
      
  #local ARRAY = SUSAN_ARRAY;
  #local ARRAY_MAX = SUSAN_MAX;   
  
  #local X_MAX = 90;
  #local Z_MAX = HF_Z_END;
  #local X_START = -X_MAX;
  #local Z_START = HF_Z_START;
  
  #local STEP = 1.00;//1.50;
  
  #local PROB = 0.50; //0.35 
  
  #local WIND_BEND = 40;
  #local Y_WIND_ROT = 30;
  
  #local FUNC_TYPE = 0;
    
  Populate_Height_Field(flower_func, ARRAY, ARRAY_MAX, X_MAX, Z_MAX, X_START, Z_START, STEP, PROB, WIND_BEND, Y_WIND_ROT, FUNC_TYPE)    

 
  #debug concat("\n************ TOTAL SUSAN FLOWERS = ", str(CNT,0,0), " ************\n\n")

    
#end     
 
 

    
    
    
    


  //                                               \\
 //------------------ FLOWER_STALK -----------------\\
//                                                   \\

//The flower stalks are generated using the Make_Flower_Stalk.inc file.  The values listed below are described in greater detail in that file.

#if(render_flower_stalk)

  #debug "\n\n************ PARSING FLOWER_STALK ************\n\n"
  
  #local SEED = 4324;//6765;
  #local R1 = seed(SEED);
    
  
  
  //PETALS       
  #local PETAL_CNT = 1;
  #local VARIENCE = 0.2;
  #local HEIGHT = 0.30; //0.41;
  #local THICKNESS = 0.38;
  #local BEND = pi/8;
  #local RUFFLE = 1.5;
  #local SMOOTHNESS = 0.70;
  #local COLOR_1 = rgb<1,0.3,0.9>;
  #local COLOR_2 = rgb<0.90,0.0,0.6>;
  #local C_VAR = 0.9;
  #local FILTER = 0.05;
    #if(!use_filter) #local FILTER = 0.00; #end   
  #local LUSTER = 0.6;
  #local AMBIENT = 0.00;
    #if(use_radiosity) #local AMBIENT = 0.0; #end
  #local SEED = 13687;   
  
  Populate_FS_Petal_Array(PETAL_CNT, HEIGHT, THICKNESS, VARIENCE, BEND, RUFFLE, SMOOTHNESS, COLOR_1, COLOR_2, C_VAR, FILTER, LUSTER, AMBIENT, SEED)
  
  
  
  
  //FLOWERS
  #local FLOWER_CNT = 2;
  #local SEED = 232;
  Populate_FS_Flower_Array(FLOWER_CNT, SEED)
  
  
  
  
  //BUDS
  #local BUD_CNT = 1;
  #local HEIGHT = 0.30;
  #local RADIUS = HEIGHT*0.30;
  #local SMOOTHNESS = 0.90;
  #local R_SEED = 2342;
  #local COLOR = rgb<0.6,0.3,0.5>;
  #local COLOR_VAR = 0.1;
  #local FILTER = 0.05;
    #if(!use_filter) #local FILTER = 0.00; #end   
  #local LUSTER = 0.1;
  #local AMBIENT = 0.00;
    #if(use_radiosity) #local AMBIENT = 0.0; #end
  Populate_FS_Bud_Array(BUD_CNT, HEIGHT, RADIUS, SMOOTHNESS, R_SEED, COLOR, COLOR_VAR, FILTER, LUSTER, AMBIENT)
  
  
  
  
  //Plant Array
  #local FLOWER_STALK_CNT = 3;
  #local VARIENCE = 0.3;
  #local HEIGHT = 3.00;//3.75;
  #local RADIUS = 0.045;
  #local SMOOTHNESS = 0.94;
  #local BEND = pi/8;
  #local STEM_COLOR = rgb<0.5,0.6,0.3>;;
  #local FILTER = 0.05;
    #if(!use_filter) #local FILTER = 0.00; #end
  #local LUSTER = 0.1;
  #local AMBIENT = 0.00;
    #if(use_radiosity) #local AMBIENT = 0.0; #end
  #local SEED = 23437;
  #local FLOWER_DIST = 0.30; //0.15
  #local FLOWERINESS = 0.60;
  Populate_Flower_stalk_Array(FLOWER_STALK_CNT, VARIENCE, HEIGHT, RADIUS, SMOOTHNESS, BEND, STEM_COLOR, FILTER, LUSTER, AMBIENT, SEED, FLOWER_DIST, FLOWERINESS)
  
 
 
 
 
 
  
  //Add Flower stalks to Landscape
  
  #local flower_stalk_func = 
  function
  {
    pattern
    {
      granite 
      turbulence 0.2  
    
      scale 100
      translate y*6785
    }
  }
   
   
  #local ARRAY = FLOWER_STALK_ARRAY;
  #local ARRAY_MAX = FLOWER_STALK_MAX;
  
  #local X_MAX = 90;
  #local Z_MAX = HF_Z_END;
  #local X_START = -X_MAX;
  #local Z_START = HF_Z_START;
  
  #local STEP = 1.00;//1.25;
  
  #local PROB = 0.70;//0.65; 
  
  #local WIND_BEND = 25;
  #local Y_WIND_ROT = 40;
  
  #local FUNC_TYPE = 0;
    
  Populate_Height_Field(flower_stalk_func, ARRAY, ARRAY_MAX, X_MAX, Z_MAX, X_START, Z_START, STEP, PROB, WIND_BEND, Y_WIND_ROT, FUNC_TYPE)

 
  #debug concat("\n************ TOTAL FLOWER STALK PLANTS = ", str(CNT,0,0), " ************\n\n")
  
#end 
 

    



    
    



  //                                               \\
 //----- Background Image and Camera Location ------\\
//                                                   \\  


//This macro was copied from the PovRay Cyclopedia at: http://www.spiritone.com/~english/cyclopedia/background.html
//downloaded 3-24-06
//John Van Sickle was mentioned in the credits, though it wasn't made exactly clear who created this code.

#declare CamLoc =  <0.00,10.00,-10.00>; //where the camera's location is
#declare CamLook = <0.00,11.00, 10.00>; // Camera's Look_at 


#declare cam_z = 1; //the amount of camera zoom you want
#declare back_dist = 6000; // how far away the background is
#declare cam_a = 4/3; // camera aspect ratio
#declare cam_s = <0,1,0>; // camera sky vector
#declare cam_d = vnormalize(CamLook-CamLoc); // camera direction vector
#declare cam_r = vnormalize(vcross(cam_s,cam_d)); // camera right vector
#declare cam_u = vnormalize(vcross(cam_d,cam_r)); // camera up vector
#declare cam_dir = cam_d * cam_z; // direction vector scaled
#declare cam_right = cam_r * cam_a; // right vector scaled

#declare fz = vlength(cam_dir);
#declare fx = vlength(cam_right)/2;
#declare fy = vlength(cam_u)/2; 

#macro OrientZ(p1,p2,cs)
  #local nz = vnormalize(p2-p1);
  #local nx = vnormalize(vcross(cs,nz)); 
  #local ny = vcross(nz,nx);
  matrix <nx.x,nx.y,nx.z, ny.x,ny.y,ny.z, nz.x,nz.y,nz.z, p1.x,p1.y,p1.z>          
#end


camera 
{
  location CamLoc
  up cam_u
  right cam_r * cam_a
  direction (cam_d * cam_z) 
}


light_group //insures that the Background does not interact with any light sources
{

  
  box 
  { 
    <0,0,0> 
    <1,1,0.1>
    pigment 
    { 
      image_map 
      {   
        jpeg "Blueground.jpg"      
      } 
    }
    
    finish 
    { 
      ambient 1.0
    }
    
    translate <-0.5,-0.5,0>
    scale 2*<fx,fy,0.5>
    translate fz*z
    scale back_dist
    OrientZ(CamLoc,CamLook,cam_s)
  }
  
  global_lights false
}





