// Persistence of Vision Ray Tracer Scene Description File
// File: rf_mcc_arch.inc
// Vers: 3.6
// Desc: Mission Control Architectural elements (walls, etc.) 
// Date: Dec 4-27, 2005
// Auth: Rob Fitzel
// Units: feet

#ifndef (included_rf_mcc_textures)
  #include "rf_mcc_textures.inc"
#end 

#include "rf_coat_rack.inc" 

#ifndef (included_rf_filing_cabinet)
  #include "rf_filing_cabinet.inc" 
#end 

#include "rf_mcc_objs.inc"         
#include "rf_tiled_ceiling.inc" 

//  walls 
#declare front_wall = 
union {
  box {<0,0,0>,<45,y_ceil,1>  texture {t_front_wall_black} } 
  
  
  // big three displays
  
  light_group {
    light_source {0*x rgb 0.8 translate <45/2,5,-5> parallel point_at <45/2,5,0>} 
    box {<0,0,0>,<1,1,-0.002> texture {t_big_front_display1} scale <11.3,10,1> translate <5,4,0> }
    box {<0,0,0>,<1,1,-0.002> texture {t_big_front_display2} scale <11.3,10,1> translate <16.8,4,0>}
    box {<0,0,0>,<1,1,-0.002> texture {t_big_front_display3} scale <11.3,10,1> translate <28.9,4,0>}  
    
    box{<5,4,0>,<28.9+11.3,14,-0.001> pigment {rgb 0.3}} // need to match color to screen bkg
    
    global_lights
    }

  light_group {
    light_source {0*x rgb 3*<0.5,0.5,1>*10 translate <3.3,1.5,0> fade_distance 2.1 fade_power 2} 
    light_source {0*x rgb 3*<0.5,0.5,1>*10 translate <6.75,1.5,0> fade_distance 2.1 fade_power 2} 
    
    light_source {0*x rgb 0.5 translate <45/2,1.5,-5> parallel point_at <45/2,1.5,0>}
      
    union { // front wall bulkhead with all the logos 
  
  
      
      box {<0,0,0>,<45,3,1>  } // angled part
      box {<0,0,0>,<45,1,1>  rotate x*30} // shelf to flatten bottom of bulkhead
      
      object {display_nasa_logo  scale 2 translate <2.3,0.5,0>}
      object {display_csa_logo   scale 2 translate <5.75,0.5,0>} 
      object {display_mcc_logo   scale 2.2 translate <14.6,0.5,0>}
      object {display_mcc2_logo  scale 1.6*<7.5,1,1> translate <16.6+0.4,0.7,0>} 
      object {display_esa_logo   scale 0.8*<2.2,1,1>   translate <35.3,0.7,0>}
      object {display_rsa_logo   scale 0.9*<2,1,1>   translate <38,0.6,0>} 
      object {display_jaxa_logo  scale 1*<1,1,1>   translate <40.5,0.7,0>}  
      object {display_status1    scale <5.2,2.2,1> translate <9,0.2,-0.4>}
      object {display_status2    scale <5.2,2.2,1> translate <29,0.2,0>} 
      

    texture {t_front_wall_black}  
    rotate -x*30 
    translate <0,y_ceil-2.5,-1> 
    
    }
  global_lights
  }
     
    // American flag on left side 
    union {
      box{<0,0,0>,<1,1,-0.001> texture {pigment{image_map{png FlagUSA}} rotate y*180  } finish {ambient rgb 0 diffuse 0.8} normal {bumps scale 0.02*<2,1,1> bump_size 1}  }
      box{<0,0,0>,<-0.02,1,-0.001> texture {pigment {rgb <0.525,0.376,0.188>} finish {ambient rgb 0 }}  }  // gold trim
      scale <1.7,1,1>*4 rotate z*90  translate <4.5,5,-0.1>
      } 
      
    // NASA seal on the right side  
  
    #declare seal_cloth = 
    union {
      #local i=0;
      #while (i<4)
        #local w = RRand(0.2,0.3,csd);
        cone {<0,0,0>,1.5*w, <0,8,0>,w  translate <i,0,0> scale <1,1,0.5>}                                                            
        
        #local i=i+RRand(0.2,0.5,csd);
      #end 
      texture {t_seal_cloth}
      texture {pigment{image_map{png NASASeal  once }} scale 2 translate <1,3,0>}
    };      
    object {seal_cloth translate <45-4.5,5,-0.1> } 
    
    
      
      
    translate z*50
  }; 
  
  // front corner
  object {coat_rack scale 1/12 translate <44,0,48> } 
  filing_cabinet(36,32,5,transform{rotate y*85 translate <45-32/12,0,47>} )  
  shelving_unit(36, bsd, transform { scale <0.5,0.5,1> rotate y*90 translate <43.4,yf5,47>})  // tiny shelf

  

#declare door = 
union {
  // door
  box {<0.05,0,0>,<3-0.05,8,0.2>} 
  union {
    // hinges
    cylinder {<0,7,0>,<0,7.4,0>,0.05}
    cylinder {<0,3.8,0>,<0,4.2,0>,0.05}
    cylinder {<0,1,0>,<0,1.4,0>,0.05} 
  
  
    box {<0.5,7.7,-0.2>,<1.3,7.9,0>} 
    cylinder {<1,0,0>,<0.8,0,-0.4> 0.05 scale <1,0.1,1> translate y*7.9 }
    cylinder {<0.4,0,0>,<0.8,0,-0.4> 0.05 scale <1,0.1,1> translate y*7.95}
    texture {T_Chrome_1A}
    }
  texture {
    pigment {rgb <0.314,0.353,0.376> }
    finish {ambient rgb 0.1 diffuse 0.5 specular 1 roughness 0.05 metallic brilliance 1 }
  }
};

#declare side_wall_doors = 
union { 
  
  // frame 
  union {
    box {< 0,0,0>,<0.2,11,-0.1> translate -x*0.2}
    box {< 0,0,0>,<0.2,11,-0.1> translate  x*6}
    box {<-0.2,11,0>,<6,11-0.2,-0.1>}
    texture {pigment {rgb <0.52,0.524,0.48>}}
    }
    
  box {<0,8,0>,<6,11,0.1> texture {pigment {rgb <0.52,0.524,0.48>}} }// top panel 
  
  box {<-0.5,7.8,0>,<0.5,8.2,-0.2> translate x*3 pigment {rgb 0}} 
  union {
    box {<-0.9,7.8,0>,<-0.5,8.2,-0.2> translate x*3 }
    box {< 0.9,7.8,0>,< 0.5,8.2,-0.2> translate x*3 }
    texture {T_Chrome_1C}
    }                           
  box {<0,0,-0.101>,<1,1,-0.05> texture {t_logo_mission_operations} translate -x*0.5 scale 2 translate <3,8.5,0>}
  
  
  
  object {door}
  object {door scale <-1,1,1> translate x*6}
  // handle 
  union {
    box {<2.5,3.5,0>, <3-0.05,4.5,-0.05> }
    cylinder {<2.8,4,0>,<2.8,4,-0.4> 0.05}
    cylinder {<2.8,4,-0.4>,<2.2,3.9,-0.4> 0.05}  
    texture {T_Chrome_1A}
    }
};


#declare t_side_wall_cream   = texture {randbozo3(<0.541,0.506,0.38>,1,0.01)};
#declare t_side_wall_lt_gray = texture {randbozo3(<0.471,0.443,0.408>,1,0.01)};
#declare t_side_wall_dk_gray = texture {randbozo3(<0.261,0.214,0.245>,1,0.01)};
#declare t_side_wall_black   = texture {pigment {rgb 0.15}};  
                                                  
#declare t_side_wall_cream   = texture {randbozo3(<0.698,0.682,0.635>*0.9, /*<0.643,0.624,0.518>*/ 1,0.01)};
#declare t_side_wall_lt_gray = texture {randbozo3(<0.537,0.506,0.498>*1.2,1,0.01)};
#declare t_side_wall_dk_gray = texture {randbozo3(<0.537,0.506,0.498>,1,0.01)};

#declare side_wall = 
  union {
  difference {
    union {
      box {<0,       0,0>, <-1,y_ceil-5,50> texture {t_side_wall_cream}   }
      box {<0,y_ceil-5,0>, <-1,y_ceil-3,50> texture {t_side_wall_lt_gray} }
      box {<0,y_ceil-3,0>, <-1,y_ceil-1,50> texture {t_side_wall_dk_gray} }
      box {<0,y_ceil-1,0>, <-1,y_ceil-0,50> texture {t_side_wall_black} } 
      //box {<-3,0,35>,<0,12,46>  texture {t_side_wall_cream}} // hallway 
    }
    box {<-2,-1,0>,<2,10,4> translate <0,0,38> } // door cutout
    texture {t_side_wall_cream}
  }  
  cylinder {<0,y_ceil-5,0>, <0,y_ceil-5,50> 0.03 scale <0.1,1,1> texture {t_side_wall_black}}
  cylinder {<0,y_ceil-3,0>, <0,y_ceil-3,50> 0.03 scale <0.1,1,1> texture {t_side_wall_black}}
};


#declare left_wall = 
union { 

  light_group {
    #if (ceiling_lights>0)
    #local i=0;        
    #while (i<5)  
       light_source {0*x rgb ceiling_lights translate <1,y_ceil-0.5, 1+i*10> fade_distance 1 fade_power 1}
        #local i=i+1;
    #end
  #end
  object {side_wall}
  global_lights 
  }
  object {side_wall_doors rotate -y*90 translate <-2,0,37-0.2>}
  union {  // mission operations logo
    box {<0,0,0>,<0.1,1,1>  texture {pigment {rgb 0}} }
    box {<0,0,0>,<0.11,1,1> texture {t_logo_mission_operations rotate -y*90} finish {reflection 0.1} } 
    scale 1.5
    translate <0,6,42.5>
    } 
   
   union { // plaque
     box {<0,0,0>,<0.05,1,1> pigment {rgb 0} }
     box {<0,0.1,0.2>,<0.051,0.9,0.8> pigment {rgb 0.9} } 
     finish {reflection 0.1}
     scale <1,1.3,1>
     translate <0,4.4,42.8>
     }
    
    box {<0,0,0>,<0.001,1,1> texture {t_print_earthrise rotate -y*90} scale <1,2.5,1>*4 translate <0,5,33>} 
   
    // shuttle mission insignia
    #macro t_insignia()
      texture {
        pigment {
          bozo
          color_map {
            [0.2 rgb <rand(msd),rand(msd), rand(msd)>/2]
            [0.5 rgb <rand(msd),rand(msd), rand(msd)>/2]
            [0.8 rgb <rand(msd),rand(msd), rand(msd)>/2]
          }
        }
        scale 0.3
      }
    #end
    
    #declare max_insignia_top_row = 21;
    #declare Insignia_Top_Row = array[max_insignia_top_row] 
                                    {95,91,90,89,87,86,85,94,84,83,82,81,80,79,78,77,76,75,72,74,73}  
    #local i=0;
    #local zpos = 46;
    #while (i < max_insignia_top_row)
      #local img_num = Insignia_Top_Row[i];    
      #local img_name = concat("sts",str(img_num,-3,0),".png");       
      #if (draw_insignia)
        box {<-0.1,0,0>,<0.001,1,1> texture {pigment{image_map{png img_name} rotate -y*90} } scale 1.2 translate <0,0.3+y_ceil-3,zpos>  }
      #else
        cylinder {<-0.1,0.5,0.5>,<0.01,0.5,0.5> 0.5  scale 1.2 translate <0,0.3+y_ceil-3,zpos> t_insignia() }  
      #end
      #local zpos=zpos-1.6;
      #local i=i+1;
    #end 

    #declare max_insignia_bot_row = 22;
    #declare Insignia_Bot_Row = array[max_insignia_bot_row] 
                                    {111,110,109,108,105,104,100,0,0,0,102,98,97,92,106,101,99,103,0,0,0,93}  
    
    #local i=0;
    #local zpos = 47;
    #while (i < max_insignia_bot_row)
      #local img_num = Insignia_Bot_Row[i];
      #local img_name = concat("sts",str(img_num,-3,0),".png");             
      #if (img_num != 0) 
        #if (draw_insignia)
          box {<-0.1,0,0>,<0.001,1,1> texture {pigment{image_map{png img_name} rotate -y*90} } scale 1.2 translate <0,0.3+y_ceil-5,zpos>  }
        #else
          cylinder {<-0.1,0.5,0.5>,<0.01,0.5,0.5> 0.5  scale 1.2 translate <0,0.3+y_ceil-5,zpos> t_insignia() }  
        #end
      #end
      #local zpos=zpos-1.6;
      #local i=i+1;
    #end 
    
        
    

    // misc lightswitches/boxes on wall
    box {<0,0,0>,<0.01,0.5,0.6>  translate <0,y_ceil-5.6,48.5> pigment {rgb 0.1}}
    object {thermostat translate <0,4,36>}
    object {metallic_light_switch translate <0,3.5,37>}
     
   };
  
#declare right_wall = 
union {
  object {side_wall translate <45+1,0,0>} 
  wall_mounted_camera(-40, transform {rotate -y*90 translate <45,12.5,48>})
  wall_mounted_camera(-40, transform {rotate -y*90 translate <45,12.5,27>})

  // memorial plaques 
  #if (draw_memorial_plaques)
    box {<-0.1,0,0>,<0.001,1,1> texture {pigment{image_map{png "sts107.png"} rotate y*90} } scale 1.2 translate <45,10,46.5>  } // Columbia
    box {<-0.1,0,0>,<0.001,1,1> texture {pigment{image_map{png "sts51l.png"} rotate y*90} } scale 1.2 translate <45,9,45.5>  } // Challenger
    box {<-0.1,0,0>,<0.001,1,1> texture {pigment{image_map{png "apollo1.png"} rotate y*90} } scale 1.2 translate <45,10,44.5>  } // Apollo 1
    box {<-0.1,0,0>,<0.001,1,1> texture {pigment{image_map{png "logo_mission_operations.png"} rotate y*90} } scale 1.2 translate <45,11,45.5>  } // MCC
  #end
  // current mission plaque
  #if (draw_mission_plaque)
    box {<-0.1,0,0>,<0.001,1,1> texture {pigment{image_map{png "sts116.png"} rotate y*90} } scale 1.5 translate <45,7,35>  }
  #end
  
  object {side_wall_doors rotate y*90 translate <44.999,0,37+6>}  
  union {
    box {<0,0,0>,<0.1,1,1>  texture {pigment {rgb 0}} scale <1,2.5,1>*4 } 
    #if(draw_shuttle_print)
      box {<0,0,0>,<-0.001,1,1> texture {t_print_shuttle rotate y*90} scale <1,2.5,1>*4 } 
    #end
    translate <45-0.1,5,28> 
    }
  //fire alarm
  box {<0,0,0>,<-0.2,0.6,0.4> texture {pigment {rgb <0.424,0.243,0.231>}} translate <45,4,35.5>}
  box {<0,0,0>,<-0.2,0.6,0.4> texture {pigment {rgb <0.424,0.243,0.231>}} translate <45,4,34>}
  object {thermostat scale 2 rotate y*180 translate <45,9,34>}

  #local i=0;
  #while (i<6)  
    object {metallic_light_switch scale 1.6 rotate y*180 translate <45,4,30-0.8*i>}
    #local i=i+1;
  #end
  
  };
                     
#declare back_wall_metal_frame = 
union 
  {
    box {<-0.1,0,0.05>,<0.1,1,-0.2> texture {T_Chrome_3A}}
    box {<-0.1,0,-0.2>,<0.1,1, -0.8> texture {pigment {rgb 0}} }
    box {<-0.1,0, -0.8>,<0.1,1,1.1> texture {T_Chrome_3A}} 
    scale <1,y_ceil-5,0.4>
  } 

#declare back_wall_metal_h_frame =  box {<7.5,0,-0.2>,<45-7.5,0.2,0.2> texture {T_Chrome_3A}}; 
 
                     
#declare back_wall = 
union {
  //box {<0,0,0>,<45,y_ceil,-1> texture {t_white_wall} };
  box {<0,0,0>,<45,5,-1> }
  box {<0,5,0>,<7.5,y_ceil,-1>}
  box {<45,5,0>,<45-7.5,y_ceil, -1>}
  // windows:
  box {<7.5,5,0>,<45-7.5,y_ceil,-1> texture {pigment {rgbt 1} finish {reflection 0.1 phong 1 phong_size 100}} }
  // metal frames  
  #local i=0;
  #while (i<7)
    object {back_wall_metal_frame translate <7.5+5*i,5,0> }
    #local i=i+1;
  #end
  object {back_wall_metal_h_frame translate y*7} 
  
  #local i=0;
  #while (i<12)
    filing_cabinet(36,24,5,transform{rotate y*180 translate <15+i*2,0,2>} )
    #local i=i+1;
  #end

  #if (draw_back_wall_plants)
    #include "mosaic_plant.inc"
    #local ssd = seed(83899);
    #local i=12;
    #while (i<37)
      object {mosaic_plant_  rotate 360*y*rand(ssd) scale RRand(1,2,ssd)*<1,1.4,1> translate <i,yf5,1> finish {ambient rgb 0.5}} 
      #local i=i+RRand(0.2,0.5,ssd);
    #end
  #end
  
  // "room" beyond - the gallery
  plane {x,-5 pigment {rgb 0.1}}
  texture {t_white_wall}
  }; 
  
 

// ceiling
#declare mcc_ceiling =  
union {
  light_group {
    //light_source { 0*x rgb 0.7 translate <23,y_ceil-1,25> parallel point_at <23,y_ceil,25>} // illuminate ceiling
    light_source { 0*x rgb 0.2*<0.5,0.5,1> translate <23,y_ceil-1,25> parallel point_at <23,y_ceil,25+1>} // illuminate ceiling
    draw_tiled_ceiling(55,55,rect_ceiling_tiles, 5, 2, transform {rotate y*0  translate <0,y_ceil,0>})
    }
  union {
    object {ceiling_projector translate x*11}
    object {ceiling_projector translate x*2*45/4}
    object {ceiling_projector translate x*34} //45-11
    translate <0,y_ceil-3.5-0.8,27.5+0.5>
    }
};