// Persistence of Vision Ray Tracer Scene Description File
// File: mcc_pods.inc  
// Vers: 3.6
// Desc: Computer Pod positions
// Date: Dec 10, 2006
// Auth: Rob Fitzel
// Units: feet 

#declare draw_kleenex_imagemaps = 0;
#include "rf_kleenex.inc" 



// Flight Dynamics Officer ////////////////////////////////////////////////////
#declare pod_fdo = 
  union { 
  draw_computer_pod(         1,2,3,     transform {translate 0*x}) 
  callsign_sign1("TRAJECTORY", 1.5, 1,transform {scale 1/12 rotate x*10 rotate -y*10 translate <-2.6,yc,-1.75> })  
  callsign_sign1("FDO", 8, 1,transform {scale 1/12 rotate x*10 rotate y*12 translate <2.5,yc,-1.75> })
  mini_flag(FlagUSA,transform {translate <-1.5,yc,-1.8>})
  binder_open(t_binder_cover, t_white_paper ,0.3,0.9,1,1,transform {rotate -y*10 scale 1/12 translate <-0.1,yc,-2>}  )
  
  object {pod_end_table  rotate y*170 translate <-3.9,0,-3.5> } 
  union { // desktop objects
    flatscreen(get_random_screen(),transform {rotate y*180 scale 1.5/12 })
    keyboard(keyboard_dark_scheme, transform {scale 1/12 rotate -y*10 translate <0,0,-0.5>}) 
    rotate -y*50
    translate <-3.8,yd,-3.1>
    } 
    #if (draw_people)  
      #include "mcc_fdo.inc"
      union {
        object {mcc_fdo_ scale 8*<-1,1,1> translate y*1.5*0}
        object {office_chair scale 1/12 rotate y*90 }  
        rotate y*40
        translate <1.5,0,-4> 
      }
      
      #ifndef(included_mmacs1)
        #include "mcc_mmacs1.inc"        
      #end
      union {
        object {mcc_mmacs1_ scale 8*<-1,1,1> translate y*1.5*0}
        object {office_chair scale 1/12 rotate y*90 }  
        rotate -y*40
        translate <-2,0,-5> 
      } 
      
    #end 
         
  };

// Ascent Entry Guidance and Procedures ///////////////////////////////////////
#declare pod_ae = 
  union { 
    draw_computer_pod(1,2,3,     transform {translate 0*x})
     
    object {binder scale 1/12 rotate y*0 translate <-2,yc,-2.2> texture {t_binder_cover} }
    object {binder scale 1/12 rotate y*0 translate <-3,yc,-2.3> texture {t_binder_cover} } 
    callsign_sign1("GUIDANCE", 3.5, 1,transform {rotate x*10 translate <0,46,-21> scale 1/12}) 
    mini_flag(FlagUSA,transform {translate <3.5,yc,-1.8>})
    paper_tray(0.5,transform {rotate x*5 translate <-3,yd,-3> })
    
    binder_open(t_binder_cover, t_white_paper ,0.3,0.3,1,1,transform {rotate -y*20 scale 1/12 translate <-0.5,yd,-3>}  )
    binder_open(t_binder_cover, t_white_paper ,0.5,0.5,1,1,transform {rotate -y*30 scale 1/12 translate <1.5,yd,-3>}  )
    object {mug1 texture {pigment {rgb 1} finish {phong 1 phong_size 40 reflection {0.05}}} scale 1.2/12 translate <1.2,yd+0.2,-2.5>}

    #if (draw_people)    
      #ifndef (included_mcc_ae)        
        #include "mcc_ae.inc"
      #end
      union {
        object {mcc_ae_ scale 8*<-1,1,1> translate y*1.5*0}
        object {office_chair scale 1/12 rotate y*90 }  
        rotate -y*5
        translate <-1,0,-5> 
      } 
      
      #include "mcc_ae_jacket.inc"
      union {
        object {office_chair scale 1/12 rotate -y*0}
        object {mcc_ae_jacket_ scale 8 rotate -y*90 translate <0.8,0.9,0>}
        rotate  y*40 
        translate <2,0,-4.7>
      } 
   #end 
    
  };

// Ground Controller //////////////////////////////////////////////////////////
#declare pod_gc = 
  union {  
    draw_computer_pod(1,2,3,transform {translate 0*x})  
    callsign_sign2("GROUND CONTROL","(GC)" 3, 8,  1,transform {rotate x*10 translate <0,46,-21> scale 1/12})
    mini_flag(FlagUSA,transform {rotate y*20 translate <-1,yc,-1.8>})

    object {gc_plaque rotate y*90 translate <-2,yc,-1.8>}
    object {gc_plaque rotate y*120 translate < 3,yc,-1.8>}
    
    union { // desktop objects
      flatscreen(get_random_screen(),transform {rotate y*180 scale 1.5/12 })
      keyboard(keyboard_dark_scheme, transform {scale 1/12 rotate -y*10 translate <0,0,-0.5>}) 
      rotate -y*50
      translate <-3.6,yd,-3.1>
      } 
      
  union { // outside end
    object {pod_end_table }
    union {
      tv1(20,18, 3, transform {scale 1/12  }) 
      object {computer_cable scale 1 rotate x*90 rotate -y*90 translate  <0.5,0.4,-1>}
      rotate y*60 translate <1.5,yt,1> 
    }
    
    filing_cabinet(24,16,4,transform{rotate 90 translate <-1.5,0,0>} )  
    object {quick_vase scale 0.8 translate <-1.0,yf4,-1>}
    rotate y*190 translate <5.7,0,-3.9>
  }         


       

  #if (draw_people)
    #ifndef (include_mcc_payload1)  
      #include "mcc_payload1.inc" 
    #end
    union {  
      object {mcc_payload1_ scale 8 translate y*0}
      object {office_chair scale 1/12 rotate y*90 } 
      
      rotate y*0
      translate <-1.8,0,-4.1>
    } 
    
      #ifndef (included_mcc_flight1)
        #include "mcc_flight1.inc" 
      #end
      union {
        object {mcc_flight1_ scale 8 translate y*0}
        object {office_chair scale 1/12 rotate y*90 }  
        rotate y*0
        translate < 1.7,0,-4.5>
      }
  #end          


                 
    }; 
      
// Propulsion /////////////////////////////////////////////////////////////////
#declare pod_prop = 
  union { 
    draw_computer_pod(1,2,3,             transform {translate 0*x})  // propulsion
   
   mini_flag(FlagChile,transform {translate <-2.5,yc,-1.8>}) 
   callsign_sign2("PROPULSION","(PROP)" 5,7.5, 1,transform {scale 1/12 rotate x*0 rotate -y*10 translate <-1,yc,-1.75>})
   mini_flag(FlagUSA,transform {translate <0.5,yc,-1.8>})

  union { // desktop objects
    flatscreen(get_random_screen(),transform {rotate y*180 scale 1.5/12 })
    keyboard(keyboard_dark_scheme, transform {scale 1/12 rotate -y*10 translate <0,0,-0.5>}) 
    rotate y*60
    translate <3.8,yd,-3.1>
    } 
    
    #if (draw_people)
      #ifndef (included_mcc_ae)        
        #include "mcc_ae.inc"
      #end
      union {
        object {mcc_ae_ scale 8*<-1,1,1> translate y*1.5*0}
        object {office_chair scale 1/12 rotate y*90 }  
        rotate -y*10
        translate <-1,0,-5> 
      }
    #end     
    
  };
  
// Guidance, Navigation and Controls Systems /////////////////////////////////
#declare pod_gnc =
  union {
    draw_computer_pod(1,2,3,              transform {translate 0*x})  // guidance, navagation, and controls systems
    mini_flag(FlagUSA,transform {rotate y*100 translate <1.5,yc,-1.8>})
    callsign_sign2("GUIDANCE/NAVIGATION","(GNC)" 1.5,7.5, 1,transform {scale 1/12 rotate x*10 translate <0,yc,-1.75>}) 
    union { // inside end
      object {pod_end_table }
      
      #local i=0;
      #while (i<10)                                                                                                          
        object {binder scale 1/12 rotate y*rand(bsd) translate <0.5,yt,-1.5>+<RRand(-0.5,0.5,bsd),0.25*rand(bsd),RRand(-1.5,0.5,bsd)> texture {t_binder_cover} } 
        #local i=i+1;
      #end
      filing_cabinet(24,16,4,transform{rotate 0 translate <0,0,-3.5>} )
      rotate y*190 translate <5.8,0,-3.9>
    }

  union { // desktop objects
    flatscreen(get_random_screen(),transform {rotate y*180 scale 1.5/12 })
    keyboard(keyboard_dark_scheme, transform {scale 1/12 rotate -y*10 translate <0,0,-0.5>}) 
    rotate y*50
    translate <3.8,yd,-3.1>
    } 

  union { // outside end
  object {pod_end_table }
  filing_cabinet(24,16,4,transform{rotate 0 translate <0,0,-3.5>} )  
  
  rotate y*190 translate <5.7,0,-3.9>
  }         
     

    #if (draw_people)
      #include "mcc_gnc.inc"  
      union {
        object {mcc_gnc_ scale 8*<-1,1,1> translate y*0}
        object {office_chair scale 1/12 rotate y*90 }  
        rotate -y*10
        translate <1.2,0,-5> 
      } 
    #end

     
  };         
 
// MMACS: maintenance, mechanical, arm, and crew systems //////////////////////
#declare pod_mmacs = 
  union { 
    draw_computer_pod(1,2,3,            transform {translate 0*x})
    callsign_sign2("MECHANICAL","(MMACS)" 5.5,6.5, 1,transform {scale 1/12 rotate x*10 translate <0,yc,-1.75>})
    mini_flag(FlagUSA,transform {rotate y*60 translate <1.5,yc,-1.8>})
    binder_open(t_binder_cover, t_white_paper ,0.1,0.2,1,1,transform {scale 1/12 rotate -y*20 translate <4,yc,-2.3>}  )
   
    union {
      flatscreen(get_random_screen(),transform {rotate y*180 scale 1.5/12 })
      keyboard(keyboard_dark_scheme, transform {scale 1/12 rotate -y*10 translate <0,0,-0.5>}) 
      rotate -y*50
      translate <-3.8,yd,-3.1>
      } 
  
      binder_open(t_binder_cover, t_white_paper ,0.3,0.7,1,1,transform {scale 1/12 rotate -y*20 translate <0,yd,-3.2>}  )
      binder_open(t_binder_cover, t_white_paper ,0.3,0.7,1,1,transform {scale 1/12 rotate  y*10 translate <1.5,yd,-3.2>}  )

      
    #if (draw_people)  
      #ifndef(included_mmacs1)
        #include "mcc_mmacs1.inc"        
      #end
      union {
        object {mcc_mmacs1_ scale 8*<-1,1,1> translate y*1.5*0}
        object {office_chair scale 1/12 rotate y*90 }  
        rotate -y*10
        translate <0,0,-5> 
      } 
      object {office_chair scale 1/12 rotate -y*30 translate <2,0,-5>}
      
    #end 
             
    union { // end of MMACS
      object {pod_end_table }
      shelving_unit(36, bsd, transform {rotate -y*90 translate <3,0,-2.5>}) 
      filing_cabinet(24,16,4,transform{rotate 0 translate <0.5,0,-3.5>} )
      rotate y*170 translate <-3.3,0,-3.5>
      }      
   
  }; // end mmacs

// EGIL: electrical generation and illumination ///////////////////////////////     
#declare pod_egil =       
  union {  
    draw_computer_pod(1,2,3,             transform {translate 0*x})
    callsign_sign1("EGIL", 7.5, 1,transform {scale 1/12 rotate x*10 translate <0,yc,-1.75>})
    mini_flag(FlagUSA,transform {rotate y*270 translate <1.5,yc,-1.8>})     
    union {
      flatscreen(get_random_screen(),transform {rotate y*180 scale 1.5/12 })
      keyboard(keyboard_dark_scheme, transform {scale 1/12 rotate -y*10 translate <0,0,-0.5>}) 
      rotate -y*50
      translate <-3.8,yd,-3.1>
    }
  };

// DPS: data processing system ////////////////////////////////////////////////
#declare pod_dps = 
  union {  
    draw_computer_pod(1,2,3,              transform {translate 0*x})
    callsign_sign2("DATA PROCESSING","(DPS)" 3.5,7.5, 1,transform {scale 1/12 rotate x*10 rotate -y*10 translate <-2,yc,-1.75>}) 
    binder_open(t_binder_cover, t_white_paper ,0.5,0.2,1,1,transform {scale 1/12  translate <0.2,yc,-1.9>}  )
    mini_flag(FlagUSA,transform {rotate y*0 translate <3.5,yc,-1.8>})     
    paper_tray(0.5,transform {rotate x*10 translate <1.5,yc,-2> })
    union {
      flatscreen(get_random_screen(),transform {rotate y*180 scale 1.5/12 })
      keyboard(keyboard_dark_scheme, transform {scale 1/12 rotate -y*10 translate <0,0,-0.5>}) 
      rotate -y*50
      translate <-3.8,yd,-3.1>
      } 
  binder_open(t_binder_cover, t_blue_paper ,0.3,0.7,1,1,transform {scale 1/12 rotate -y*20 translate <-1.2,yd,-3.2>}  )
  binder_open(t_binder_cover, t_blue_paper ,0.3,0.7,1,1,transform {scale 1/12 rotate  y*10 translate <0.7,yd,-3.2>}  )
      
    #if (draw_people)  
      #ifndef(included_mcc_capcom_person)
        #include "mcc_capcom_person.inc" 
      #end
      union {
        object {mcc_capcom_person_ scale 8*<-1,1,1> translate y*1.5}
        object {office_chair scale 1/12 rotate y*90 }  
        rotate -y*40
        translate <0,0,-5> 
      } 
      object {office_chair scale 1/12 rotate -y*30 translate <2,0,-5>}
    #end          
  }; 

// Payloads ///////////////////////////////////////////////////////////////////
#declare pod_payload = 
  union {
  draw_computer_pod(1,2,3,         transform {translate 0*x}) 
  callsign_sign1("PAYLOADS", 3.5, 1,transform {scale 1/12 rotate x*10 translate <0,yc,-1.75>}) 
  mini_flag(FlagUSA,transform {rotate y*300 translate <-1.5,yc,-1.8>})     

  union {
    flatscreen(get_random_screen(),transform {rotate y*180 scale 1.5/12 })
    keyboard(keyboard_dark_scheme, transform {scale 1/12 rotate -y*10 translate <0,0,-0.5>}) 
    rotate y*80
    translate < 4.5,yd,-3.1>
    } 
  
  binder_open(t_binder_cover, t_white_paper ,0.3,0.7,1,1,transform {scale 1/12 rotate -y*20 translate <-1,yd,-3.2>}  )
  binder_open(t_binder_cover, t_white_paper ,0.3,0.7,1,1,transform {scale 1/12 rotate  y*10 translate <0.5,yd,-3.2>}  )
  paper_tray(2,transform {rotate -y*90 translate <4.6,yd,-2.8> })
  
    
  #if (draw_people)
    #ifndef (include_mcc_payload1)  
      #include "mcc_payload1.inc" 
    #end
    union {  
      light_group {
        light_source {0*x rgb <0.518,0.753,0.882>*2 translate <0,4,2>  fade_distance 0.9 fade_power 2}
        object {mcc_payload1_ scale 8 translate y*0}
        object {office_chair scale 1/12 rotate y*90 } 
       // sphere {0, 0.2 translate pigment {rgb 1}} 
        
        rotate y*40
        translate <2.0,0,-4.5>
        } 
    } 
    object {office_chair scale 1/12 rotate -y*90 translate <-2,0,-5>}
  #end          
  
  union { // end of Payloads
  object {pod_end_table }
  filing_cabinet(24,16,4,transform{rotate 0 translate <0,0,-3.5>} )  
  object {screen_wipe_box  rotate y*120 translate <1,yf4,-2>}
  
  rotate y*190 translate <5.7,0,-3.9>
  }         
    
    
  };
    
// FAO: Flight Activities Officer /////////////////////////////////////////////
#declare pod_fao =
union { 
  #debug "FAO\n"
  draw_computer_pod(1,2,3,              transform {translate 0*x})  // flight activities officer 
  callsign_sign2("FLIGHT ACTIVITIES","(FAO)" 3.5,7.5, 1,transform {scale 1/12 rotate x*10 translate <0,yc,-1.75>})
  shelving_unit(36, bsd, transform {rotate -y*90 translate <4.7,0,-5>}) 
  mini_flag(FlagUSA,transform {translate <4,yc,-1.7>}) 
  
  object {sheet_of_blue_paper translate <-1,yd,-3.5>}     
  object {sheet_of_blue_paper translate < 0,yd,-3.2>}
  object {sheet_of_blue_paper translate < 1,yd,-3.2>}
  binder_open(t_binder_cover, t_white_paper ,0.3,0.7,1,1,transform {scale 1/12 translate <-2,yd,-3.2>}  )
  object {office_phone scale 1.3/12 rotate y*20 translate < 2.2,yd,-3.2>}
  keyboard(keyboard_light_scheme, transform {scale 1/12 rotate -y*10 translate <-0.2,yd,-2.2>}) 
  keyboard(keyboard_light_scheme, transform {scale 1/12 rotate -y*10 translate < 2,yd,-2.2>}) 
  
  union {
    flatscreen(get_random_screen(),transform {rotate y*180 scale 1.5/12 })
    keyboard(keyboard_dark_scheme, transform {scale 1/12 rotate -y*10 translate <0,0,-0.5>}) 
    rotate -y*60
    translate <-3.8,yd,-3.1>
    } 

    union { // end of FAO
      object {pod_end_table } 
      object {paper_shelves rotate y*180 translate <1.5,yt,0>+<0.5,0,0>}
      shelving_unit(36, bsd,transform {rotate -y*90 translate <3,0,-2.5>} )
      filing_cabinet(24,16,4,transform{rotate 0 translate <0.5,0,-3.5>} )
      rotate y*170 translate <-3.3,0,-3.5>
      } 
          
    #if (draw_people) 
  
      #include "mcc_fao1.inc" 
      union {
        object {mcc_fao1_ scale 8 translate y*1.5}
        object {office_chair scale 1/12 rotate y*90 }  
        rotate -y*45
        translate <-1.5,0,-5.5>   
      }
       
      #include "mcc_fao2.inc"
      union {
        object {mcc_fao2_ scale 8 }
        object {office_chair scale 1/12 rotate y*90 }
        rotate -y*20
        translate <1.5,0,-4>
      }       
     
    #end
  }      

// EECOM: Emergency, Environmental and Consumables Operations Manager ///////
#declare pod_eecom =       
  union { 
    draw_computer_pod(1,2,3,            transform {translate 0*x})  
    callsign_sign2("ENVIRONMENTAL","(EECOM)" 4,7, 1,transform {scale 1/12 rotate x*10 translate <0,yc,-1.75>})
    shelving_unit(36, bsd, transform {rotate  y*90 translate <-5,0,-3>}) // middle EECIN 
    shelving_unit(36, bsd, transform {rotate y*90 translate <4,0,-4.5>}) // against wall
    shelving_unit(36, bsd, transform {rotate y*90 translate <4,ys,-4.5>}) // stacked ontop
    
    // stuff on top
 //   binder_open(t_binder_cover, t_white_paper ,0.3,0.7,1,1,transform {scale 1/12 rotate y*10 translate <1,yc,-1.4>}  ) 
    binder_open(t_binder_cover, t_white_paper ,0.3,0.7,1,1,transform {scale 1/12 rotate -y*20 translate <2,yc,-2>}  )
    object {sheet_of_white_paper rotate y*5 translate <-1.7,yc,-1.9>}

    mini_flag(FlagUSA,transform {translate <3.5,yc,-1.8>})

    
    union { // desk objects
      flatscreen(get_random_screen(),transform {rotate y*180 scale 1.5/12 })
      keyboard(keyboard_dark_scheme, transform {scale 1/12 rotate -y*10 translate <0,0,-0.5>})  
      rotate -y*50
      translate <-3.8,yd,-3.1>
      }
       
    computer_mouse(0 transform {rotate y*0 translate <3.2,yd,-3>})
      
    binder_open(t_binder_cover, t_white_paper ,0.7,0.2,1,1,transform {scale 1/12 translate <-1,yd,-3.5>}  )  
    binder_open(t_binder_cover, t_white_paper ,0.7,0.2,1,1,transform {scale 1/12 rotate y*10 translate <0,yd,-3.6>}  ) 
    binder_open(t_binder_cover, t_white_paper ,0.7,0.2,1,1,transform {scale 1/12 rotate y*20 translate <1,yd,-3.2>}  ) 
    binder_open(t_binder_cover, t_white_paper ,0.7,0.2,1,1,transform {scale 1/12 rotate y*30 translate <2,yd,-3>}  ) 
      
    #if (draw_people)  
    #include "mcc_eecom1.inc"
      union {
        object {mcc_eecom1_ scale 8 translate y*0}  
        object {office_chair scale 1/12 rotate y*90 }  
        rotate y*30 
        translate <-1,0,-4>
      } 
      
    #include "mcc_eecom2c.inc"
      union {
        object {mcc_eecom2c_ scale 7 translate y*0}  
        object {office_chair scale 1/12 rotate y*90 }  
        rotate -y*0 
        translate <2,0,-4>
      } 
      
    #end  
  }; 
  
// INstrumentation and Communications Officer /////////////////////////////////
#declare pod_inco = 
  union { // instrumentation and communications officer
    draw_computer_pod(1,2,3,             transform {translate 0*x}) 
    callsign_sign1("INCO", 7.5, 1,transform {scale 1/12 rotate x*10 translate <0,yc,-1.75>}) 
    };

// Flight Director ////////////////////////////////////////////////////////////
#declare pod_flight =   
  union { // flight director 
    #debug "Flight\n"
    draw_computer_pod(1,2,3,           transform {translate 0*x}) 
    callsign_sign1("FLIGHT DIRECTOR",1, 0.8,transform {scale 1/12 rotate x*10 translate <0,yc,-1.75>})
    paper_tray(1.5,transform {rotate -y*80 translate <-1.5,yd,-3.5> })
    
    union {
      tv1(20,18, 2, transform {scale 1/12  }) 
      object {computer_cable scale 1 rotate x*90 rotate -y*90 translate  <0.5,0.4,-1>}
      scale 0.7
      rotate y*90 translate <-3,yd,-3> 
    }
    

    
    

    binder_open(t_binder_cover, t_white_paper ,0.3,0.3,1,1,transform {rotate -y*20 scale 1/12 translate <-0.5,yd,-3>}  )
    binder_open(t_binder_cover, t_white_paper ,0.5,0.5,1,1,transform {rotate -y*30 scale 1/12 translate <1.5,yd,-3>}  )
    object {mug1 texture {pigment {rgb 1} finish {phong 1 phong_size 40 reflection {0.05}}} scale 1.2/12 translate <1.2,yd+0.2,-2.5>}
    
    #if (draw_people)
      #ifndef (included_mcc_flight1)
        #include "mcc_flight1.inc" 
      #end
      union {
        object {mcc_flight1_ scale 8 translate y*0}
        object {office_chair scale 1/12 rotate y*90 }  
        rotate -y*40
        translate <1.7,0,-4.5>
      } 
    #end      
    
    union { 
      flatscreen(get_random_screen(),transform {rotate y*180 scale 1.5/12 })
      keyboard(keyboard_dark_scheme, transform {scale 1/12 rotate -y*10 translate <0,0,-0.5>})  
      rotate  y*80
      translate < 3.2,yd,-3.1>
      }
    }; 
    
// spaceflight communicator (capsule communications) //////////////////////////
#declare pod_capcom =     
  union {  
    #debug "CAPCOM\n"
    draw_computer_pod(1,2,3,           transform {translate 0*x}) 
    callsign_sign1("CAPCOM", 4.5, 1,transform {scale 1/12 rotate x*10 translate <0,yc,-1.75>})
    mini_flag(FlagUSA,transform {translate <2.5,yc,-1.8>}) 
    binder_open(t_binder_cover, t_white_paper ,0.3,1,1,1,transform {scale 1/12 translate <-3.3,yc+0.05,-2>}  )
    object {binder scale 1/12 rotate y*10 translate <-2,yc,-1.7> texture {t_binder_cover} } 
    
    filing_cabinet(36,16,4,transform{rotate -y*90 translate <5.68,0,-3>} ) 
    object {kleenex_box scale 1/12 rotate y*80 translate <7-2,yf4,-2.5>}     
    paper_tray(1.8,transform {rotate y*90 translate <4.5,yf4,-0.5> })    
                                                                     //-3
    shelving_unit(36, bsd, transform {rotate  y*90 translate <2.38+1,0,-4>}) // end of desk
    object {binder scale 1/12 rotate y*80 translate <2.38+1,ys,-5> texture {t_binder_cover} } 
    
    #if (draw_slow_to_render_objs)
      object {garbage_can translate <5,0,-4>} //
    #end
    
    shelving_unit(36, bsd, transform {rotate -y*90 translate <-2.85,0,-5>}) // middle capcom
    shelving_unit(36, bsd, transform {rotate  y*90 translate <-4.85,0,-3>}) // middle flight director
    
    union {
      tv1(20,18, 2, transform {scale 1/12  }) 
      object {computer_cable scale 1 rotate x*90 rotate -y*90 translate  <0.5,0.4,-1>}
      rotate y*270 translate <3,yd,-4> 
    }
    object {binder scale 1/12 rotate y*20 translate <2.8,yd,-3.3> texture {t_binder_cover}} 

    #local i=0;      
    #while(i<20)
      object {sheet_of_white_paper rotate y*RRand(-20,20,bsd) translate <RRand(-4,4,psd),yd+0.0001*i,RRand(-3.5,-3,psd)>}  //<0.5,yd,-3>
      #local i=i+1;
    #end

    
    union {
      binder_open(t_binder_cover, t_white_paper ,0.3,0.7,1,0,transform {scale 1/12}  )
      binder_open(t_binder_cover, t_white_paper ,0.3,0.7,0,1,transform {scale 1/12 rotate -z*40}  )
      rotate y*70 
      translate <-0.5,yd,-3.3>
      }
    union { 
      flatscreen(get_random_screen(),transform {rotate y*180 scale 1.5/12 })
      keyboard(keyboard_dark_scheme, transform {scale 1/12 rotate -y*10 translate <0,0,-0.5>})  
      rotate -y*80
      translate <-3.8,yd,-3.1>
      }
    
    #if (draw_people)  
      #ifndef(included_mcc_capcom_person)
        #include "mcc_capcom_person.inc" 
      #end
      union {
        object {mcc_capcom_person_ scale 8 translate y*1.5}
        object {office_chair scale 1/12 rotate y*90 }  
        rotate y*30
        translate <-1.3,0,-4>
      } 
      //object {office_chair scale 1/12 rotate y*40 translate <1.5,0,-4.7>}
      
      #include "mcc_capcom_jacket.inc"
      union {
        object {office_chair scale 1/12 rotate -y*0}
        object {mcc_capcom_jacket_ scale 8 rotate -y*90 translate <0.8,0.9,0>}
        rotate  y*40 
        translate <1.5,0,-4.7>
      } 
    #end
  };

// Payload Deployment and Retrieval Systems ///////////////////////////////////
#declare pod_pdrs =     
  union {  // payload deployment and retrieval systems 
    #debug "PDRS\n"  
    
    draw_computer_pod(1,2,3,             transform {translate 0*x}) 
    // things on top of desk  
    callsign_sign2("PAYLOAD DEPLOY/","RETRIEVAL (PDRS)" 3, 3,  1,transform {scale 1/12 rotate x*10 translate <0,yc,-1.75>})
    mini_flag(FlagUSA,transform {rotate y*30 translate <-1.1,yc,-1.6>})
    mini_flag(FlagCanada,transform {rotate y*90 translate <1.2,yc,-1.6>}) 
    object {binder scale 1/12*<1,2,1> rotate y*180 translate <-1.5,yc,-1.3> texture {t_binder_cover} } 
    object {sheet_of_white_paper rotate y*RRand(-20,20,bsd) translate <RRand(-2.5,4,psd),yd+0.0001*i,RRand(-3.5,-3,psd)>}  //<0.5,yd,-3>
    
                      
    shelving_unit(36, bsd, transform { rotate -y*90 translate <-3,0,-5.5>}) 
    object {binder scale 1/12 rotate -y*80 translate <-3,26/12,-5.5> texture {t_binder_cover}}
    binder_open(t_binder_cover, t_blue_paper,0.3,0.7,1,1,transform {scale 1/12  rotate y*10 translate <-0.5,yd,-3.5>})
    #local i=0;      
    #while(i<7)
      object {sheet_of_white_paper rotate y*RRand(-20,20,bsd) translate <RRand(-2.5,3,psd),yd+0.0001*i,RRand(-3.5,-3,psd)>}  //<0.5,yd,-3>
      #local i=i+1;
    #end
    keyboard(keyboard_light_scheme, transform {scale 1/12 rotate y*8 translate <0.6,yd,-2.2>}) 
    keyboard(keyboard_dark_scheme,  transform {scale 1/12 rotate y*40 translate <2.5,yd,-3>})
    flatscreen(get_random_screen(),transform {rotate y*250 scale 1.5/12 translate <3.2,yd,-3.2>})
    //object {sticky_note translate <1.6,yd,-3>}
    
    #if (draw_slow_to_render_objs)
      object {water_bottle2 scale 1/12 translate <-3.5,yd,-4.3>}
    #end
    union { // computer 
      object {computer_cable rotate y*40 translate <0,0,-0.5>}
      flatscreen(get_random_screen(),transform {rotate y*180 scale 1.5/12 })
      keyboard(keyboard_dark_scheme, transform {scale 1/12 rotate -y*10 translate <0,0,-0.5>})  
      rotate -y*50
      translate <-3.3,yd,-3.1>
      } 
      
    computer_mouse(0 transform {rotate -y*30 translate <-1.9,yd,-2.8>})
    
    #if (draw_people)  
      #include "mcc_pdrs_person.inc" 
      union {
      object {mcc_pdrs_person_ scale 8 translate y*1.5}
      object {office_chair scale 1/12 rotate y*90 } 
      rotate -y*30
      translate <-1.3,0,-4.5>
      }
    #end
  }; 

  

#declare pod_pao =  union  { // PAO: Public Affairs Officer
    draw_computer_pod(1,2,3,              transform {translate 0*x}) 
    callsign_sign2("PUBLIC AFFAIRS","(PAO)" 4, 7.5,  1,transform {scale 1/12 rotate x*10 translate <0,yc,-1.75>}) 
    };
    
#declare pod_mod =  union  { // mission operations directorate
    draw_computer_pod(1,2,3,              transform {translate 0*x}) 
    callsign_sign1("MOD", 7, 1,transform {scale 1/12 rotate x*10 translate <0,yc,-1.75>})
    }; 
     
#declare pod_boost =  union {   // booster systems
    draw_computer_pod(1,2,3,          transform {translate 0*x}) 
    callsign_sign1("BOOSTER", 4, 1,transform {scale 1/12 rotate x*10 translate <0,yc,-1.75>})
    };    


#declare pod_surgeon =   // flight surgeon
union { 
  draw_computer_pod(1,2,3,      transform {translate 0*x}) 
  callsign_sign1("SURGEON", 4, 1,transform {scale 1/12 rotate x*10 translate <0,yc,-1.75>})
  mini_flag(FlagUSA, transform {rotate y*30 translate <1,yc,-1.8>})
  keyboard(keyboard_light_scheme, transform {scale 1/12 rotate -y*10 translate <-3,yd,-2.4>}) 
  computer_mouse(0 transform {rotate y*0 translate <-1.5,yd,-2.4>})
  object {sheet_of_white_paper translate -z*(11/12) rotate y*5 translate <-3.3,yd,-2.8>}  //<0.5,yd,-3>  
  object {magnetic_clip rotate y*0 translate <-0.9,yd+1.2,-1.8>}
  };
  
